/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.crosswire.common.swing.RowColumns;

public class RowTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 4243175203443082117L;
    private List list;
    private RowColumns rowColumnModel;
    private int[] indexes;
    private int[] keys;
    private int sortColumn;

    public RowTableModel(List aList, RowColumns aRowColumnModel) {
        this.list = aList;
        this.rowColumnModel = aRowColumnModel;
        this.keys = this.rowColumnModel.getSortKeys();
        this.sortColumn = this.keys[0];
        this.allocate();
    }

    public int getRowCount() {
        return this.list == null ? 0 : this.list.size();
    }

    public int getColumnCount() {
        return this.rowColumnModel.getCount();
    }

    public Object getValueAt(int row, int column) {
        return this.getCellValue(this.indexes[row], column);
    }

    private Object getCellValue(int rowIndex, int columnIndex) {
        Object obj = this.list.get(rowIndex);
        return this.rowColumnModel.getValueAt(obj, columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.rowColumnModel.getClass(columnIndex);
    }

    public String getHeaderToolTip(int columnIndex) {
        return this.rowColumnModel.getHeaderToolTip(columnIndex);
    }

    public String getColumnName(int columnIndex) {
        return this.rowColumnModel.getName(columnIndex);
    }

    public void addRow(Object obj) {
        this.list.add(obj);
        this.allocate();
        int visibleRow = this.getRow(obj);
        this.fireTableRowsInserted(visibleRow, visibleRow);
    }

    public Object getRow(int rowIndex) {
        return this.list.get(this.indexes[rowIndex]);
    }

    public int getRow(Object obj) {
        for (int i = 0; i < this.indexes.length; ++i) {
            if (!this.getRow(i).equals(obj)) continue;
            return i;
        }
        return -1;
    }

    public void removeRow(Object obj) {
        int dataIndex = this.list.indexOf(obj);
        int visibleIndex = this.getRow(obj);
        this.list.remove(dataIndex);
        this.fireTableRowsDeleted(visibleIndex, visibleIndex);
        this.allocate();
    }

    public void updateRow(Object obj) {
        int visibleIndex = this.getRow(obj);
        this.fireTableRowsUpdated(visibleIndex, visibleIndex);
    }

    public void reset() {
        this.allocate();
        this.fireTableDataChanged();
    }

    public void clear() {
        this.list.clear();
        this.allocate();
        this.fireTableDataChanged();
    }

    public void sort(int modelIndex) {
        if (modelIndex != -1) {
            this.sortColumn = modelIndex;
        }
        int rowCount = this.getRowCount();
        boolean changed = false;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = i + 1; j < rowCount; ++j) {
                if (this.compareKeys(this.indexes[i], this.indexes[j], this.sortColumn) >= 0) continue;
                this.swap(i, j);
                changed = true;
            }
        }
        if (changed) {
            this.fireTableRowsUpdated(0, this.getRowCount());
        }
    }

    private void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    private int compareKeys(int i, int j, int column) {
        int cmp = this.compare(i, j, column);
        if (this.keys != null) {
            for (int k = 0; cmp == 0 && k < this.keys.length; ++k) {
                if (k == column) continue;
                cmp = this.compare(i, j, this.keys[k]);
            }
        }
        return cmp;
    }

    public int compare(int i, int j, int column) {
        Object io = this.getCellValue(i, column);
        Object jo = this.getCellValue(j, column);
        int cmp = 0;
        cmp = io.getClass().equals(jo.getClass()) && io instanceof Comparable ? ((Comparable)jo).compareTo(io) : (io instanceof Boolean ? io.toString().compareTo(jo.toString()) : jo.toString().compareTo(io.toString()));
        return cmp < 0 ? -1 : (cmp > 0 ? 1 : 0);
    }

    private void allocate() {
        int rowCount = this.getRowCount();
        if (this.indexes == null || this.indexes.length != rowCount) {
            int[] newData = new int[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                newData[i] = i;
            }
            this.indexes = newData;
            this.sort(-1);
        }
    }
}

