/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.crosswire.flashcards.ComplexLessonSet;
import org.crosswire.flashcards.EditPane_imageGenButton_actionAdapter;
import org.crosswire.flashcards.FlashCard;
import org.crosswire.flashcards.FlashCardEditor;
import org.crosswire.flashcards.FlashCardPane;
import org.crosswire.flashcards.Lesson;
import org.crosswire.flashcards.LessonChangeEvent;
import org.crosswire.flashcards.LessonChangeEventListener;
import org.crosswire.flashcards.LessonManager;
import org.crosswire.flashcards.LessonPane;
import org.crosswire.flashcards.LessonSetPane;

public class EditPane
extends JPanel {
    private static final long serialVersionUID = 8637424690635575114L;
    JButton imageGenButton = new JButton();

    public EditPane() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Create and modify Lesson Sets, Lessons and Flash Cards "));
        LessonSetPane lessonSetPanel = new LessonSetPane(true);
        final LessonPane lessonPanel = new LessonPane(true);
        final FlashCardPane flashCardPanel = new FlashCardPane();
        final FlashCardEditor flashCardEditor = new FlashCardEditor();
        final JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LessonManager.instance().store();
            }
        });
        LessonChangeEventListener changeListener = new LessonChangeEventListener(){

            public void lessonChanged(LessonChangeEvent event) {
                boolean modified = LessonManager.instance().isModified();
                saveButton.setEnabled(modified);
            }
        };
        boolean modified = LessonManager.instance().isModified();
        saveButton.setEnabled(modified);
        lessonSetPanel.addLessonChangeEventListener(changeListener);
        lessonPanel.addLessonChangeEventListener(changeListener);
        flashCardPanel.addLessonChangeEventListener(changeListener);
        flashCardEditor.addFlashCardEventListener(flashCardPanel);
        lessonSetPanel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                JList list = (JList)e.getSource();
                lessonPanel.loadLessons((ComplexLessonSet)list.getSelectedValue());
            }
        });
        lessonPanel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                JList list = (JList)e.getSource();
                flashCardPanel.loadFlashCards((Lesson)list.getSelectedValue());
            }
        });
        lessonPanel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                JList list = (JList)e.getSource();
                flashCardEditor.setActive(list.getSelectedValue() != null);
            }
        });
        flashCardPanel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                DefaultListSelectionModel listSelectionModel = (DefaultListSelectionModel)e.getSource();
                int row = listSelectionModel.getMinSelectionIndex();
                FlashCard flashCard = null;
                if (row != -1) {
                    flashCard = flashCardPanel.getFlashCard(row);
                }
                flashCardEditor.setFlashCard(flashCard);
            }
        });
        JSplitPane lessonSplitPane = new JSplitPane();
        lessonSplitPane.setResizeWeight(0.5);
        lessonSplitPane.setDividerLocation(0.5);
        lessonSplitPane.setLeftComponent(lessonSetPanel);
        lessonSplitPane.setRightComponent(lessonPanel);
        JSplitPane flashCardSplitPane = new JSplitPane();
        flashCardSplitPane.setResizeWeight(0.5);
        flashCardSplitPane.setDividerLocation(0.5);
        flashCardSplitPane.setLeftComponent(flashCardPanel);
        flashCardSplitPane.setRightComponent(flashCardEditor);
        flashCardSplitPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Flash Cards: "));
        JSplitPane verticalSplitPane = new JSplitPane(0);
        verticalSplitPane.setDividerLocation(0.35);
        verticalSplitPane.setResizeWeight(0.35);
        verticalSplitPane.setTopComponent(lessonSplitPane);
        verticalSplitPane.setBottomComponent(flashCardSplitPane);
        this.imageGenButton.setText("Prerender Word Images");
        this.imageGenButton.addActionListener(new EditPane_imageGenButton_actionAdapter(this));
        this.add((Component)verticalSplitPane, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.add(saveButton);
        buttonPane.add(this.imageGenButton);
        this.add((Component)buttonPane, "South");
    }

    public void imageGenButton_actionPerformed(ActionEvent e) {
        LessonManager.instance().genImages();
    }
}

