/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.crosswire.flashcards.FlashCard;
import org.crosswire.flashcards.FlashCardEvent;
import org.crosswire.flashcards.FlashCardEventListener;
import org.crosswire.modedit.UniTextEdit;

public class FlashCardEditor
extends JPanel {
    private static final long serialVersionUID = -4278635534357530483L;
    private JPanel answerPanel = new JPanel();
    private JTextField answers = new JTextField();
    private UniTextEdit wordText = new UniTextEdit();
    protected JDialog dlgMain;
    private FlashCard flashCard;
    private JButton btnAdd = new JButton("Add");
    private JButton btnModify = new JButton("Modify");
    private JButton btnDelete = new JButton("Delete");
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public FlashCardEditor() {
        this.jbInit();
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout1);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.wordText.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Front"));
        this.wordText.setText("");
        this.wordText.showIMSelect(true);
        this.wordText.setComponentOrientation(ComponentOrientation.UNKNOWN);
        this.wordText.setFontSize(30.0f);
        this.add((Component)this.wordText, new GridBagConstraints(0, 0, 1, 1, 0.7, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.answers.setSelectionStart(0);
        this.answers.setText("");
        this.answerPanel.setLayout(new BorderLayout());
        this.answerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Back"));
        this.answerPanel.add(this.answers);
        this.add((Component)this.answerPanel, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 5));
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FlashCardEditor.this.createFlashCard();
            }
        });
        this.btnModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FlashCardEditor.this.modifyFlashCard();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FlashCardEditor.this.deleteFlashCard();
            }
        });
        JPanel pnlButtons = new JPanel();
        pnlButtons.add(this.btnAdd);
        pnlButtons.add(this.btnModify);
        pnlButtons.add(this.btnDelete);
        this.add((Component)pnlButtons, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setActive(false);
    }

    public void setFlashCard(FlashCard newFlashCard) {
        boolean selected = false;
        if (newFlashCard != null) {
            selected = true;
            this.flashCard = (FlashCard)newFlashCard.clone();
            this.wordText.setText(this.flashCard.getFront());
            this.answers.setText(this.flashCard.getBack());
        } else {
            this.wordText.setText("");
            this.answers.setText("");
        }
        this.btnDelete.setEnabled(selected);
        this.btnModify.setEnabled(selected);
    }

    public void setActive(boolean state) {
        this.btnAdd.setEnabled(state);
        this.btnModify.setEnabled(this.flashCard != null);
        this.btnDelete.setEnabled(state);
    }

    protected void createFlashCard() {
        this.flashCard = new FlashCard();
        this.flashCard.setFront(this.wordText.getText());
        this.flashCard.setBack(this.answers.getText());
        this.fireFlashCardChanged(new FlashCardEvent(this, this.flashCard, 0));
    }

    protected void modifyFlashCard() {
        if (this.flashCard == null) {
            return;
        }
        this.flashCard.setFront(this.wordText.getText());
        this.flashCard.setBack(this.answers.getText());
        this.fireFlashCardChanged(new FlashCardEvent(this, this.flashCard, 1));
    }

    protected void deleteFlashCard() {
        this.fireFlashCardChanged(new FlashCardEvent(this, this.flashCard, 2));
    }

    public synchronized void addFlashCardEventListener(FlashCardEventListener listener) {
        this.listenerList.add(FlashCardEventListener.class, listener);
    }

    public synchronized void removeFlashCardEventListener(FlashCardEventListener listener) {
        this.listenerList.remove(FlashCardEventListener.class, listener);
    }

    public void fireFlashCardChanged(FlashCardEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$crosswire$flashcards$FlashCardEventListener == null ? FlashCardEditor.class$("org.crosswire.flashcards.FlashCardEventListener") : class$org$crosswire$flashcards$FlashCardEventListener)) continue;
            ((FlashCardEventListener)listeners[i + 1]).flashCardChanged(e);
        }
    }
}

