/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionListener;
import org.crosswire.flashcards.ComplexLesson;
import org.crosswire.flashcards.ComplexLessonSet;
import org.crosswire.flashcards.Lesson;
import org.crosswire.flashcards.LessonChangeEvent;
import org.crosswire.flashcards.LessonChangeEventListener;

public class LessonPane
extends JPanel {
    private static final long serialVersionUID = -4950398737983745837L;
    private JList lessonList = new JList(new DefaultListModel());
    private ComplexLessonSet lessonSet;
    private JMenuItem newItem;
    private boolean editable;

    public LessonPane() {
        this(false);
    }

    public LessonPane(boolean allowEdits) {
        this.editable = allowEdits;
        this.jbInit();
    }

    public void setSelectionMode(int mode) {
        this.lessonList.setSelectionMode(mode);
    }

    public Iterator iterator() {
        return new SelectedLessonIterator(this.lessonList);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.lessonList.addListSelectionListener(listener);
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Lessons: "));
        this.add((Component)new JScrollPane(this.lessonList), "Center");
        JMenuBar menuBar = new JMenuBar();
        JMenu editMenu = new JMenu("Edit");
        this.newItem = new JMenuItem("New Lesson");
        menuBar.add(editMenu);
        editMenu.add(this.newItem);
        if (this.editable) {
            this.add((Component)menuBar, "North");
        }
        this.enableControls();
        this.newItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String answer = JOptionPane.showInputDialog(null, "Lesson Description: ", "Create a New Lesson", -1);
                if (answer == null) {
                    return;
                }
                LessonPane.this.createLesson(answer);
            }
        });
        this.enableControls();
    }

    public void createLesson(String description) {
        ComplexLesson lesson = null;
        try {
            lesson = new ComplexLesson(this.lessonSet.getNextLessonFilename(), description);
        }
        catch (Exception e) {
            // empty catch block
        }
        DefaultListModel model = (DefaultListModel)this.lessonList.getModel();
        if (!model.contains(lesson)) {
            model.addElement(lesson);
            this.lessonSet.add(lesson);
            this.fireLessonChanged(new LessonChangeEvent(this));
        }
        this.lessonList.setSelectedValue(lesson, true);
    }

    public void loadLessons(ComplexLessonSet aLessonSet) {
        this.lessonSet = aLessonSet;
        DefaultListModel model = (DefaultListModel)this.lessonList.getModel();
        model.clear();
        if (this.lessonSet != null) {
            Vector lessons = this.lessonSet.getLessons();
            for (int i = 0; i < lessons.size(); ++i) {
                Lesson lesson = (Lesson)lessons.elementAt(i);
                model.addElement(lesson);
            }
        }
        this.enableControls();
    }

    private void enableControls() {
        this.newItem.setEnabled(this.lessonSet != null);
    }

    public synchronized void addLessonChangeEventListener(LessonChangeEventListener listener) {
        this.listenerList.add(LessonChangeEventListener.class, listener);
    }

    public synchronized void removeLessonChangeEvent(LessonChangeEventListener listener) {
        this.listenerList.remove(LessonChangeEventListener.class, listener);
    }

    public void fireLessonChanged(LessonChangeEvent e) {
        Object[] list = this.listenerList.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$org$crosswire$flashcards$LessonChangeEventListener == null ? LessonPane.class$("org.crosswire.flashcards.LessonChangeEventListener") : class$org$crosswire$flashcards$LessonChangeEventListener)) continue;
            ((LessonChangeEventListener)list[i + 1]).lessonChanged(e);
        }
    }

    private static class SelectedLessonIterator
    implements Iterator {
        private int[] selectedIndexes;
        private DefaultListModel model;
        private int currentIndex;

        public SelectedLessonIterator(JList list) {
            this.model = (DefaultListModel)list.getModel();
            this.selectedIndexes = list.getSelectedIndices();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.currentIndex < this.selectedIndexes.length;
        }

        public Object next() throws NoSuchElementException {
            if (this.hasNext()) {
                return this.model.get(this.selectedIndexes[this.currentIndex++]);
            }
            throw new NoSuchElementException();
        }
    }
}

