/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.crosswire.flashcards.FlashCard;
import org.crosswire.flashcards.Lesson;
import org.crosswire.flashcards.QuizPane_answer_itemAdapter;
import org.crosswire.flashcards.QuizPane_playSoundButton_actionAdapter;
import org.crosswire.flashcards.QuizPane_showAnswerButton_actionAdapter;
import org.crosswire.flashcards.QuizPane_startLessonButton_actionAdapter;
import org.crosswire.flashcards.SetupPane;

public class QuizPane
extends JPanel {
    private static final int NUM_COLUMNS = 2;
    private static final int NUM_ANSWERS = 10;
    private static Hashtable fontCache = new Hashtable();
    float optimalFontSize = 30.0f;
    List picks = new ArrayList();
    private static final long serialVersionUID = 8613458092624929167L;
    SetupPane setupPane;
    List words = new ArrayList();
    List notLearned = new ArrayList();
    WordEntry currentWord = null;
    int wrong = 0;
    int totalAsked = 0;
    int totalWrong = 0;
    boolean shownAnswer = false;
    JButton startLessonButton = new JButton();
    JButton playSoundButton = new JButton();
    JButton showAnswerButton = new JButton();
    JLabel wordText = new JLabel();
    JLabel statusBar = new JLabel();
    JLabel wCount = new JLabel();
    JPanel choicesPanel = new JPanel();
    GridLayout choicesPanelGridLayout = new GridLayout();
    JPanel statusPanel = new JPanel();
    BorderLayout statusPanelBorderLayout = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();

    public QuizPane(SetupPane setupPane) {
        this.setupPane = setupPane;
        this.jbInit();
    }

    private void jbInit() {
        this.choicesPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 10, 10));
        this.startLessonButton.setText("Start");
        this.startLessonButton.addActionListener(new QuizPane_startLessonButton_actionAdapter(this));
        this.playSoundButton.setText("Listen");
        this.playSoundButton.addActionListener(new QuizPane_playSoundButton_actionAdapter(this));
        this.playSoundButton.setVisible(false);
        this.showAnswerButton.setFocusPainted(true);
        this.showAnswerButton.setMnemonic('A');
        this.showAnswerButton.setText("Show Answer");
        this.showAnswerButton.addActionListener(new QuizPane_showAnswerButton_actionAdapter(this));
        this.wordText.setBackground(SystemColor.text);
        this.wordText.setFont(new Font("Dialog", 0, 30));
        this.wordText.setMinimumSize(new Dimension(0, 50));
        this.wordText.setPreferredSize(new Dimension(0, 50));
        this.wordText.setHorizontalAlignment(0);
        this.wordText.setHorizontalTextPosition(0);
        this.statusBar.setBorder(BorderFactory.createEtchedBorder());
        this.statusBar.setText(" ");
        this.wCount.setBorder(BorderFactory.createEtchedBorder());
        this.choicesPanel.setLayout(this.choicesPanelGridLayout);
        this.choicesPanelGridLayout.setColumns(2);
        this.choicesPanelGridLayout.setHgap(10);
        this.choicesPanelGridLayout.setRows(0);
        this.statusPanel.setLayout(this.statusPanelBorderLayout);
        this.statusBar.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.jPanel1.setLayout(this.borderLayout3);
        this.jPanel2.setLayout(this.borderLayout1);
        this.jPanel6.setLayout(this.borderLayout4);
        this.statusPanel.add((Component)this.statusBar, "Center");
        this.statusPanel.add((Component)this.wCount, "East");
        this.setLayout(this.borderLayout2);
        this.jPanel3.add(this.playSoundButton);
        this.jPanel4.add(this.startLessonButton);
        this.jPanel5.add(this.showAnswerButton);
        this.add((Component)this.statusPanel, "South");
        this.add((Component)this.jPanel2, "Center");
        this.add((Component)this.jPanel1, "North");
        this.jPanel1.add((Component)this.jPanel3, "Center");
        this.jPanel1.add((Component)this.jPanel4, "West");
        this.jPanel1.add((Component)this.jPanel5, "East");
        this.jPanel2.add((Component)this.jPanel6, "South");
        this.jPanel2.add((Component)this.wordText, "Center");
        this.jPanel6.add((Component)this.choicesPanel, "Center");
        this.jPanel2.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                QuizPane.this.windowResized();
            }
        });
    }

    public void deleteChildren(JComponent c) {
        while (c.getComponentCount() > 0) {
            c.remove(c.getComponent(0));
        }
    }

    public void loadTest() {
        this.words = new ArrayList();
        Iterator lessonIter = this.setupPane.iterator();
        while (lessonIter.hasNext()) {
            Lesson lesson = (Lesson)lessonIter.next();
            Vector cards = lesson.getFlashcards();
            for (int i = 0; i < cards.size(); ++i) {
                WordEntry we = new WordEntry((FlashCard)cards.get(i));
                we.setFontURL(lesson.getFont());
                this.words.add(we);
            }
        }
        for (int i = 0; i < this.words.size() - 1; ++i) {
            WordEntry w = (WordEntry)this.words.get(i);
            for (int j = i + 1; j < this.words.size(); ++j) {
                WordEntry xx = (WordEntry)this.words.get(j);
                if (!w.flashCard.getFront().equals(xx.flashCard.getFront())) continue;
                w.back = w.back + " or " + xx.back;
                this.words.remove(j);
                --j;
            }
        }
    }

    public Font loadFont(String url) {
        Font retVal = new Font("Dialog", 0, 30);
        if (url != null && url.length() > 0) {
            try {
                retVal = (Font)fontCache.get(url);
                if (retVal == null) {
                    this.statusBar.setText("Loading font...");
                    this.statusBar.paintImmediately(this.statusBar.getVisibleRect());
                    URL fontURL = new URL(url);
                    URLConnection uc = fontURL.openConnection();
                    InputStream is = uc.getInputStream();
                    retVal = Font.createFont(0, is);
                    is.close();
                    fontCache.put(url, retVal);
                    this.statusBar.setText("New Font Loaded.");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return retVal;
    }

    void startLessonButton_actionPerformed(ActionEvent e) {
        this.loadTest();
        this.notLearned = (List)((ArrayList)this.words).clone();
        this.totalAsked = 0;
        this.totalWrong = 0;
        this.showRandomWord(this.currentWord);
    }

    void playSoundButton_actionPerformed(ActionEvent e1) {
        if (this.currentWord.getAudioURL() == null) {
            return;
        }
        int EXTERNAL_BUFFER_SIZE = 128000;
        AudioInputStream audioInputStream = null;
        try {
            URL audioURL = new URL(this.currentWord.getAudioURL());
            audioInputStream = AudioSystem.getAudioInputStream(audioURL);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        AudioFormat audioFormat = audioInputStream.getFormat();
        SourceDataLine line = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(audioFormat);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        line.start();
        int nBytesRead = 0;
        byte[] abData = new byte[128000];
        while (nBytesRead != -1) {
            try {
                nBytesRead = audioInputStream.read(abData, 0, abData.length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (nBytesRead < 0) continue;
            int nBytesWritten = line.write(abData, 0, nBytesRead);
        }
        line.drain();
        line.close();
    }

    public void showRandomWord(WordEntry last) {
        this.deleteChildren(this.choicesPanel);
        int numToLearn = this.notLearned.size();
        if (numToLearn == 0) {
            return;
        }
        while (this.currentWord == last) {
            int wordNum = (int)(Math.random() * (double)this.notLearned.size());
            this.currentWord = (WordEntry)this.notLearned.get(wordNum);
        }
        this.showWord(this.currentWord);
    }

    public void showWord(WordEntry w) {
        this.currentWord = w;
        this.playSoundButton.setVisible(this.currentWord.getAudioURL() != null);
        Font newFont = this.loadFont(this.currentWord.getFontURL()).deriveFont(this.optimalFontSize);
        this.wordText.setFont(newFont);
        this.wordText.setText(w.getSide(!this.setupPane.isFlipped()));
        if (this.setupPane.isNoMultipleChoice()) {
            this.choicesPanel.invalidate();
            this.choicesPanel.validate();
            this.choicesPanel.repaint();
        } else {
            int c;
            List choices = (List)((ArrayList)this.words).clone();
            choices.remove(w);
            boolean flipped = this.setupPane.isFlipped();
            this.picks = new ArrayList();
            this.picks.add(this.createAnswerEntry(w.getSide(flipped)));
            int size = this.words.size();
            while (this.picks.size() < Math.min(10, size)) {
                c = (int)(Math.random() * (double)choices.size());
                WordEntry wc = (WordEntry)choices.get(c);
                String answer = wc.getSide(flipped);
                if (this.picks.contains(answer)) continue;
                this.picks.add(this.createAnswerEntry(answer));
                choices.remove(wc);
            }
            c = (int)(Math.random() * (double)this.picks.size());
            if (c > 0) {
                this.picks.add(0, this.picks.remove(c));
                this.picks.add(c, this.picks.remove(1));
            }
            Iterator iter = this.picks.iterator();
            while (iter.hasNext()) {
                this.choicesPanel.add((Component)iter.next());
            }
            this.wrong = 0;
            this.shownAnswer = false;
            this.setOptimalFontSizes();
            this.updateStats();
            this.choicesPanel.invalidate();
            this.choicesPanel.validate();
            this.choicesPanel.repaint();
        }
    }

    Component createAnswerEntry(String answer) {
        JCheckBox ck = new JCheckBox(answer, false);
        ck.setFont(new Font("Dialog", 0, 16));
        ck.addItemListener(new QuizPane_answer_itemAdapter(this));
        return ck;
    }

    void updateStats() {
        int percent = 100;
        if (this.totalAsked > 0) {
            percent = (int)((float)(this.totalAsked - this.totalWrong) / (float)this.totalAsked * 100.0f);
        }
        this.wCount.setText(Integer.toString(this.notLearned.size()) + " | " + Integer.toString(this.totalAsked - this.totalWrong) + "/" + Integer.toString(this.totalAsked) + " (" + Integer.toString(percent) + "%)");
    }

    void answer_itemStateChanged(ItemEvent e) {
        JCheckBox ck = null;
        try {
            ck = (JCheckBox)e.getItem();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (ck == null) {
            return;
        }
        if (ck.isSelected()) {
            ++this.totalAsked;
            if (ck.getText().compareTo(this.currentWord.getSide(this.setupPane.isFlipped())) != 0) {
                this.statusBar.setText("Please try again. " + ck.getText() + " is not correct.");
                ++this.wrong;
                ++this.totalWrong;
                ck.setSelected(false);
            } else if (this.notLearned.size() > 1) {
                this.statusBar.setText("Correct.  Try this next word");
                if (this.wrong > 0) {
                    this.currentWord.incrementFailures(this.wrong);
                } else {
                    this.currentWord.incrementFailures(-1);
                }
                if (this.currentWord.getFailures() < 0) {
                    this.notLearned.remove(this.currentWord);
                }
                this.showRandomWord(this.currentWord);
            } else {
                this.notLearned.remove(this.currentWord);
                this.deleteChildren(this.choicesPanel);
                this.wordText.setText("-=+* Great! *+=-");
                this.statusBar.setText("Nice Job!  You've mastered all " + this.words.size() + " words!");
            }
            this.updateStats();
        }
    }

    public void showAnswer() {
        for (int i = 0; i < this.choicesPanel.getComponentCount(); ++i) {
            JCheckBox ck = (JCheckBox)this.choicesPanel.getComponent(i);
            if (!ck.getText().equals(this.currentWord.getSide(this.setupPane.isFlipped()))) continue;
            ck.setFont(new Font(ck.getFont().getName(), 3, ck.getFont().getSize()));
            break;
        }
        this.shownAnswer = true;
    }

    void showAnswerButton_actionPerformed(ActionEvent e) {
        if (this.setupPane.isNoMultipleChoice()) {
            ++this.totalAsked;
            String dialogString = this.currentWord.getSide(!this.setupPane.isFlipped()) + "\n" + this.currentWord.getSide(this.setupPane.isFlipped()) + "\n" + "Did You Get It Right?\n";
            int choice = JOptionPane.showConfirmDialog(this, dialogString, "Result", 0);
            if (0 == choice) {
                this.notLearned.remove(this.currentWord);
            } else {
                ++this.totalWrong;
            }
            this.updateStats();
            if (this.notLearned.size() > 0) {
                this.showRandomWord(this.currentWord);
            } else {
                this.wordText.setText("-=+* Great! *+=-");
                this.statusBar.setText("Nice Job!  You've mastered all " + this.words.size() + " words!");
            }
        } else {
            if (!this.shownAnswer) {
                this.showAnswer();
                return;
            }
            int next = this.notLearned.indexOf(this.currentWord) + 1;
            if (next == 0) {
                return;
            }
            if (next >= this.notLearned.size()) {
                next = 0;
            }
            this.deleteChildren(this.choicesPanel);
            this.showWord((WordEntry)this.notLearned.get(next));
            this.showAnswer();
        }
    }

    public Rectangle getMaxBounds(float fontSize) {
        Graphics2D g2d = (Graphics2D)this.wordText.getGraphics();
        Rectangle biggest = new Rectangle(0, 0, 0, 0);
        FontRenderContext fc = g2d.getFontRenderContext();
        Iterator it = this.notLearned.iterator();
        while (it.hasNext()) {
            WordEntry we = (WordEntry)it.next();
            Font f = this.loadFont(we.getFontURL());
            if (f == null) continue;
            f = f.deriveFont(fontSize);
            TextLayout tlo = new TextLayout(we.getSide(!this.setupPane.isFlipped()), f, fc);
            Rectangle2D rect = tlo.getBounds();
            if (rect.getWidth() > (double)biggest.width) {
                biggest.width = (int)rect.getWidth();
            }
            if (!(rect.getHeight() > (double)biggest.height)) continue;
            biggest.height = (int)rect.getHeight();
        }
        return biggest;
    }

    public float getOptimalFontSize(Rectangle bounds) {
        float fontSize = 30.0f;
        Rectangle referenceBounds = this.getMaxBounds(fontSize);
        float xmult = (float)bounds.width / (float)referenceBounds.width;
        float ymult = (float)bounds.height / (float)referenceBounds.height;
        fontSize *= xmult < ymult ? xmult : ymult;
        fontSize = (float)((double)fontSize * 0.75);
        return fontSize;
    }

    public void setOptimalFontSizes() {
        this.jPanel2.invalidate();
        this.jPanel2.validate();
        this.jPanel2.repaint();
        Rectangle bounds = this.jPanel2.getBounds();
        bounds.height /= 2;
        this.optimalFontSize = this.getOptimalFontSize(bounds);
        Font newFont = this.loadFont(this.currentWord.getFontURL());
        Font choiceFont = newFont.deriveFont((float)((double)this.optimalFontSize * 0.9) / 5.0f);
        Iterator iter = this.picks.iterator();
        while (iter.hasNext()) {
            ((Component)iter.next()).setFont(choiceFont);
        }
        this.optimalFontSize = this.getOptimalFontSize(bounds);
        newFont = this.loadFont(this.currentWord.getFontURL()).deriveFont(this.optimalFontSize);
        this.wordText.setFont(newFont);
    }

    protected void windowResized() {
        if (this.wordText != null && this.wordText.getText() != null && this.wordText.getText().length() > 0) {
            this.setOptimalFontSizes();
        }
    }

    static class WordEntry
    implements Serializable {
        protected String back;
        protected FlashCard flashCard;
        protected int attempts;
        protected String fontURL = null;
        private static final long serialVersionUID = -8148656461971656626L;

        public WordEntry(FlashCard flashCard) {
            this.flashCard = flashCard;
            this.back = flashCard.getBack();
        }

        public void incrementFailures(int failures) {
            this.attempts += failures;
        }

        public int getFailures() {
            return this.attempts;
        }

        public String getSide(boolean front) {
            return front ? this.flashCard.getFront() : this.back;
        }

        public String getAudioURL() {
            return this.flashCard.getAudioURL();
        }

        public void setFontURL(String fontURL) {
            this.fontURL = fontURL;
        }

        public String getFontURL() {
            return this.fontURL;
        }

        public String toString() {
            return this.flashCard.getFront();
        }
    }
}

