/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.util.Random;
import java.util.Vector;
import org.crosswire.flashcards.FlashCard;
import org.crosswire.flashcards.Lesson;

public class Quizer {
    Random rand = new Random();
    Vector words = new Vector();
    Vector notLearned = new Vector();
    WordEntry lastWord = null;
    int wrong = 0;
    int totalAsked = 0;
    int totalWrong = 0;

    public Quizer() {
        this.clear();
    }

    public void clear() {
        this.words = new Vector();
        this.reset();
    }

    public void loadLesson(Lesson lesson) {
        int i;
        Vector cards = lesson.getFlashcards();
        for (i = 0; i < cards.size(); ++i) {
            FlashCard f = (FlashCard)cards.elementAt(i);
            this.words.addElement(new WordEntry(f));
        }
        for (i = 0; i < this.words.size() - 1; ++i) {
            WordEntry w = (WordEntry)this.words.elementAt(i);
            for (int j = i + 1; j < this.words.size(); ++j) {
                WordEntry xx = (WordEntry)this.words.elementAt(j);
                if (!w.flashCard.getFront().equals(xx.flashCard.getFront())) continue;
                w.flashCard.setBack(w.flashCard.getBack() + " or " + xx.flashCard.getBack());
                this.words.removeElementAt(j);
                --j;
            }
        }
        this.reset();
    }

    void reset() {
        this.totalAsked = 0;
        this.totalWrong = 0;
        this.words.trimToSize();
        this.notLearned = new Vector();
        for (int i = 0; i < this.words.size(); ++i) {
            this.notLearned.addElement(new WordEntry(((WordEntry)this.words.elementAt(i)).getFlashCard()));
        }
    }

    public FlashCard getRandomWord(int wrongCount) {
        int numToLearn;
        if (this.lastWord != null && wrongCount > -1) {
            ++this.totalAsked;
            if (wrongCount > 0) {
                this.totalWrong += wrongCount;
                this.lastWord.incrementFailures(wrongCount);
            } else {
                this.lastWord.incrementFailures(-1);
            }
            if (this.notLearned.size() == 1 || this.lastWord.getFailures() < 0) {
                this.notLearned.removeElement(this.lastWord);
                this.notLearned.trimToSize();
            }
        }
        if ((numToLearn = this.notLearned.size()) == 0) {
            return null;
        }
        WordEntry currentWord = null;
        if (numToLearn != 1) {
            currentWord = this.lastWord;
            if (wrongCount < 0 && currentWord != null) {
                int next = this.notLearned.indexOf(this.lastWord) + 1;
                if (next >= this.notLearned.size()) {
                    next = 0;
                }
                currentWord = (WordEntry)this.notLearned.elementAt(next);
            }
            while (currentWord == this.lastWord) {
                int wordNum = this.getRandomInt(this.notLearned.size());
                currentWord = (WordEntry)this.notLearned.elementAt(wordNum);
            }
        } else {
            currentWord = (WordEntry)this.notLearned.elementAt(0);
        }
        this.lastWord = currentWord;
        return currentWord.getFlashCard();
    }

    public int getPercentage() {
        int percent = 100;
        if (this.totalAsked > 0) {
            percent = (this.totalAsked - this.totalWrong) * 100 / this.totalAsked;
        }
        return percent;
    }

    public Vector getRandomAnswers(int count) {
        int wordNum;
        Vector<String> ret = new Vector<String>();
        if (count > this.words.size()) {
            count = this.words.size();
        }
        while (count > 0) {
            wordNum = this.getRandomInt(this.words.size());
            String b = ((WordEntry)this.words.elementAt((int)wordNum)).flashCard.getBack();
            if (ret.indexOf(b) >= 0) continue;
            ret.addElement(b);
            --count;
        }
        if (ret.indexOf(this.lastWord.flashCard.getBack()) < 0) {
            wordNum = this.getRandomInt(ret.size());
            ret.setElementAt(this.lastWord.flashCard.getBack(), wordNum);
        }
        System.out.println("Answer is offset: " + ret.indexOf(this.lastWord.flashCard.getBack()));
        return ret;
    }

    public int getTotalAsked() {
        return this.totalAsked;
    }

    public int getTotalWrong() {
        return this.totalWrong;
    }

    public int getNotLearnedCount() {
        return this.notLearned.size();
    }

    public int getRandomInt(int upperLimit) {
        int ret = this.rand.nextInt() % upperLimit;
        if (ret < 0) {
            ret *= -1;
        }
        return ret;
    }

    static class WordEntry {
        protected FlashCard flashCard;
        protected int attempts;

        public WordEntry(FlashCard flashCard) {
            this.flashCard = flashCard;
        }

        public void incrementFailures(int failures) {
            this.attempts += failures;
        }

        public int getFailures() {
            return this.attempts;
        }

        public FlashCard getFlashCard() {
            return this.flashCard;
        }
    }
}

