/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.flashcards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;
import org.crosswire.flashcards.EditorFrame_AboutBox;
import org.crosswire.flashcards.EditorFrame_addButton_actionAdapter;
import org.crosswire.flashcards.EditorFrame_answers_actionAdapter;
import org.crosswire.flashcards.EditorFrame_answers_caretAdapter;
import org.crosswire.flashcards.EditorFrame_deleteButton_actionAdapter;
import org.crosswire.flashcards.EditorFrame_fileName_caretAdapter;
import org.crosswire.flashcards.EditorFrame_jButton1_actionAdapter;
import org.crosswire.flashcards.EditorFrame_jButton2_actionAdapter;
import org.crosswire.flashcards.EditorFrame_jButton3_actionAdapter;
import org.crosswire.flashcards.EditorFrame_jButton6_actionAdapter;
import org.crosswire.flashcards.EditorFrame_lessonTitle_caretAdapter;
import org.crosswire.flashcards.EditorFrame_wordList_listSelectionAdapter;
import org.crosswire.flashcards.EditorFrame_wordText_caretAdapter;
import org.crosswire.modedit.UniTextEdit;

public class EditorFrame
extends JFrame {
    String cwdPath = "./";
    Container contentPane;
    JToolBar jToolBar = new JToolBar();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JButton jButton3 = new JButton();
    Properties lesson = new Properties();
    ImageIcon image1;
    ImageIcon image2;
    ImageIcon image3;
    JLabel statusBar = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton deleteButton = new JButton();
    JButton addButton = new JButton();
    JList wordList = new JList();
    JLabel fontPath = new JLabel();
    JButton jButton6 = new JButton();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JLabel jLabel2 = new JLabel();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    GridLayout gridLayout1 = new GridLayout();
    JTextField answers = new JTextField();
    JPanel jPanel7 = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    List words = new ArrayList();
    UniTextEdit wordText = new UniTextEdit();
    private boolean standAlone;
    private static final long serialVersionUID = -1544644199693526132L;
    int lastSelection = -1;
    JPanel jPanel8 = new JPanel();
    JPanel jPanel9 = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    JPanel jPanel10 = new JPanel();
    JLabel jLabel3 = new JLabel();
    JTextField lessonTitle = new JTextField();
    JPanel jPanel11 = new JPanel();
    JTextField fileName = new JTextField();
    JLabel jLabel4 = new JLabel();
    FlowLayout flowLayout2 = new FlowLayout();
    JScrollPane jScrollPane1 = new JScrollPane();

    public EditorFrame(boolean standAlone) {
        this.standAlone = standAlone;
        this.enableEvents(64L);
        this.jbInit();
    }

    private void jbInit() {
        this.image1 = new ImageIcon(EditorFrame.class.getResource("openFile.png"));
        this.image2 = new ImageIcon(EditorFrame.class.getResource("closeFile.png"));
        this.image3 = new ImageIcon(EditorFrame.class.getResource("saveDoc.png"));
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(512, 300));
        this.setTitle("Editor");
        this.statusBar.setText(" ");
        this.jButton1.setIcon(this.image1);
        this.jButton1.addActionListener(new EditorFrame_jButton1_actionAdapter(this));
        this.jButton1.setToolTipText("Open Lesson");
        this.jButton2.setIcon(this.image2);
        this.jButton2.addActionListener(new EditorFrame_jButton2_actionAdapter(this));
        this.jButton2.setToolTipText("New Lesson");
        this.jButton3.setIcon(this.image3);
        this.jButton3.addActionListener(new EditorFrame_jButton3_actionAdapter(this));
        this.jButton3.setToolTipText("Save Lesson");
        this.jPanel1.setLayout(this.borderLayout2);
        this.deleteButton.setToolTipText("");
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new EditorFrame_deleteButton_actionAdapter(this));
        this.addButton.setMnemonic('A');
        this.addButton.setSelected(false);
        this.addButton.setText("Add");
        this.addButton.addActionListener(new EditorFrame_addButton_actionAdapter(this));
        this.fontPath.setText("[default]");
        this.jButton6.setText("...");
        this.jButton6.addActionListener(new EditorFrame_jButton6_actionAdapter(this));
        this.jPanel3.setLayout(this.borderLayout3);
        this.jPanel4.setLayout(this.flowLayout1);
        this.jLabel2.setPreferredSize(new Dimension(31, 15));
        this.jLabel2.setText("Font:");
        this.jPanel5.setLayout(this.borderLayout4);
        this.jLabel1.setText("Answer");
        this.jPanel6.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(2);
        this.gridLayout1.setVgap(0);
        this.answers.setSelectionStart(0);
        this.answers.setText("");
        this.answers.addCaretListener(new EditorFrame_answers_caretAdapter(this));
        this.answers.addActionListener(new EditorFrame_answers_actionAdapter(this));
        this.wordText.setText("");
        this.jPanel7.setLayout(this.borderLayout6);
        this.borderLayout1.setHgap(1);
        this.borderLayout1.setVgap(1);
        this.borderLayout2.setHgap(1);
        this.borderLayout2.setVgap(1);
        this.borderLayout3.setHgap(1);
        this.borderLayout3.setVgap(1);
        this.borderLayout4.setHgap(1);
        this.borderLayout4.setVgap(1);
        this.borderLayout6.setHgap(1);
        this.borderLayout6.setVgap(1);
        this.wordText.setText("");
        this.wordText.addCaretListener(new EditorFrame_wordText_caretAdapter(this));
        this.jPanel8.setLayout(this.borderLayout5);
        this.jLabel3.setText("Lesson Title");
        this.jLabel4.setText("File Name");
        this.jPanel9.setLayout(this.flowLayout2);
        this.flowLayout2.setAlignment(0);
        this.flowLayout2.setHgap(5);
        this.lessonTitle.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.lessonTitle.setMinimumSize(new Dimension(150, 19));
        this.lessonTitle.setPreferredSize(new Dimension(150, 19));
        this.lessonTitle.setText("");
        this.lessonTitle.addCaretListener(new EditorFrame_lessonTitle_caretAdapter(this));
        this.fileName.setMinimumSize(new Dimension(150, 19));
        this.fileName.setPreferredSize(new Dimension(150, 19));
        this.fileName.setText("");
        this.fileName.addCaretListener(new EditorFrame_fileName_caretAdapter(this));
        this.jScrollPane1.setPreferredSize(new Dimension(200, 131));
        this.jToolBar.add(this.jButton2);
        this.jToolBar.add(this.jButton1);
        this.jToolBar.add(this.jButton3);
        this.contentPane.add((Component)this.jPanel8, "North");
        this.jPanel8.add((Component)this.jPanel9, "Center");
        this.jPanel11.add((Component)this.jLabel4, null);
        this.jPanel11.add((Component)this.fileName, null);
        this.jPanel9.add((Component)this.jPanel11, null);
        this.jPanel9.add((Component)this.jPanel10, null);
        this.jPanel10.add((Component)this.jLabel3, null);
        this.jPanel10.add((Component)this.lessonTitle, null);
        this.jPanel8.add((Component)this.jPanel3, "North");
        this.contentPane.add((Component)this.jPanel5, "Center");
        this.jPanel5.add((Component)this.jPanel6, "South");
        this.jPanel6.add((Component)this.jLabel1, null);
        this.jPanel6.add((Component)this.answers, null);
        this.jPanel5.add((Component)this.jPanel7, "Center");
        this.jPanel7.add((Component)this.wordText, "Center");
        this.jPanel4.add((Component)this.jLabel2, null);
        this.jPanel4.add((Component)this.fontPath, null);
        this.jPanel4.add((Component)this.jButton6, null);
        this.jPanel3.add((Component)this.jToolBar, "West");
        this.contentPane.add((Component)this.statusBar, "South");
        this.contentPane.add((Component)this.jPanel1, "West");
        this.jPanel1.add((Component)this.jPanel2, "North");
        this.jPanel2.add((Component)this.addButton, null);
        this.jPanel2.add((Component)this.deleteButton, null);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.wordList, null);
        this.jPanel3.add((Component)this.jPanel4, "East");
        this.newLesson();
        this.wordText.showIMSelect(true);
        this.wordText.setComponentOrientation(ComponentOrientation.UNKNOWN);
        this.wordText.setFontSize(30.0f);
    }

    private void newLesson() {
        this.lesson = new Properties();
        this.lesson.setProperty("fileName", "NewLesson.flash");
        this.lesson.setProperty("lessonTitle", "New Lesson");
        this.lesson.setProperty("wordCount", "0");
        this.words = new ArrayList();
        this.words.add(new WordEntry(" "));
        this.showLesson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLesson(String lessonFileName) {
        this.lesson = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(lessonFileName);
            this.lesson.load(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inStream != null) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.words = new ArrayList();
        int wordCount = Integer.parseInt(this.lesson.getProperty("wordCount"));
        for (int i = 0; i < wordCount; ++i) {
            this.words.add(new WordEntry(this.lesson.getProperty("word" + Integer.toString(i)), this.lesson.getProperty("answers" + Integer.toString(i))));
        }
        this.showLesson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLesson() {
        OutputStream outStream = null;
        try {
            this.lesson.setProperty("wordCount", Integer.toString(this.words.size()));
            for (int i = 0; i < this.words.size(); ++i) {
                WordEntry we = (WordEntry)this.words.get(i);
                this.lesson.setProperty("word" + Integer.toString(i), we.word);
                this.lesson.setProperty("answers" + Integer.toString(i), we.answers);
            }
            outStream = new FileOutputStream(this.cwdPath + "/" + this.lesson.getProperty("fileName"));
            this.lesson.store(outStream, "Flash Lesson");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void showLesson() {
        this.setTitle("FlashCards Editor (c) CrossWire Bible Society http://crosswire.org - " + this.lesson.getProperty("fileName"));
        this.wordList.setListData(this.words.toArray());
        this.wordList.setSelectedIndex(0);
        this.wordList.addListSelectionListener(new EditorFrame_wordList_listSelectionAdapter(this));
        String fName = this.lesson.getProperty("fileName");
        fName = fName.substring(0, fName.indexOf(".flash"));
        this.fileName.setText(fName);
        this.lessonTitle.setText(this.lesson.getProperty("lessonTitle"));
        if (null != this.lesson.getProperty("font")) {
            this.fontPath.setText(this.lesson.getProperty("font"));
            try {
                this.wordText.loadFont(new FileInputStream(this.fontPath.getText()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void jMenuFileExit_actionPerformed(ActionEvent event) {
        if (this.standAlone) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        EditorFrame_AboutBox dlg = new EditorFrame_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.pack();
        dlg.setVisible(true);
    }

    protected void processWindowEvent(WindowEvent event) {
        super.processWindowEvent(event);
        if (event.getID() == 201) {
            if (this.standAlone) {
                System.exit(0);
            } else {
                this.dispose();
            }
        }
    }

    void jButton1_actionPerformed(ActionEvent e) {
        JFileChooser dialog = new JFileChooser();
        dialog.setFileFilter(new FlashFileFilter());
        dialog.setCurrentDirectory(new File(this.cwdPath));
        if (dialog.showOpenDialog(this) == 0) {
            try {
                this.loadLesson(dialog.getSelectedFile().getCanonicalPath());
                this.cwdPath = dialog.getCurrentDirectory().getCanonicalPath();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    void jButton2_actionPerformed(ActionEvent e) {
        this.newLesson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jButton6_actionPerformed(ActionEvent e) {
        JFileChooser dialog = new JFileChooser();
        dialog.setFileFilter(new TTFFileFilter());
        dialog.setCurrentDirectory(new File("./"));
        if (dialog.showOpenDialog(this) == 0) {
            this.lesson.setProperty("font", dialog.getSelectedFile().getName());
            this.fontPath.setText(this.lesson.getProperty("font"));
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(this.fontPath.getText());
                this.wordText.loadFont(inStream);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (inStream != null) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    void addButton_actionPerformed(ActionEvent e) {
        this.words.add(new WordEntry(" "));
        this.wordList.setListData(this.words.toArray());
        this.wordList.setSelectedIndex(this.words.size() - 1);
        this.wordText.requestFocus();
        this.wordText.setText("");
    }

    void updateWordList() {
        int currentWord = this.wordList.getSelectedIndex();
        this.wordList.setListData(this.words.toArray());
        this.wordList.setSelectedIndex(currentWord);
    }

    void wordText_caretUpdate(CaretEvent e) {
        int currentWord = this.wordList.getSelectedIndex();
        ((WordEntry)this.words.get((int)currentWord)).word = this.wordText.getText();
        this.updateWordList();
    }

    void wordList_valueChanged(ListSelectionEvent e) {
        int currentWord = this.wordList.getSelectedIndex();
        if (currentWord > -1 && currentWord != this.lastSelection) {
            this.lastSelection = currentWord;
            WordEntry we = (WordEntry)this.words.get(currentWord);
            this.wordText.setText(we.word);
            this.answers.setText(we.answers);
        }
    }

    void answers_actionPerformed(ActionEvent e) {
    }

    void jButton3_actionPerformed(ActionEvent e) {
        this.saveLesson();
    }

    void answers_caretUpdate(CaretEvent e) {
        int currentWord = this.wordList.getSelectedIndex();
        ((WordEntry)this.words.get((int)currentWord)).answers = this.answers.getText();
    }

    void fileName_caretUpdate(CaretEvent e) {
        this.lesson.setProperty("fileName", this.fileName.getText() + ".flash");
        this.setTitle("FlashCard Editor (c) CrossWire Bible Society http://crosswire.org - " + this.lesson.getProperty("fileName"));
    }

    void lessonTitle_caretUpdate(CaretEvent e) {
        this.lesson.setProperty("lessonTitle", this.lessonTitle.getText());
    }

    void deleteButton_actionPerformed(ActionEvent e) {
        int item = this.wordList.getSelectedIndex();
        if (item > -1) {
            this.words.remove(item);
            this.updateWordList();
        }
    }

    static class TTFFileFilter
    extends FileFilter {
        TTFFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".ttf");
        }

        public String getDescription() {
            return "TrueType Font";
        }
    }

    static class FlashFileFilter
    extends FileFilter {
        FlashFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".flash");
        }

        public String getDescription() {
            return "Flash Card Lessons";
        }
    }

    static class WordEntry {
        public String word = "";
        public String answers = "";

        public WordEntry(String word) {
            this.word = word;
        }

        public WordEntry(String word, String answers) {
            this(word);
            this.answers = answers;
        }

        public String toString() {
            return this.word;
        }
    }
}

