/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.modedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.crosswire.modedit.CGreekIM;
import org.crosswire.modedit.GreekKeymanIM;
import org.crosswire.modedit.Gtk2ClassicalGreekIM;
import org.crosswire.modedit.HebrewDurusauIM;
import org.crosswire.modedit.HebrewMCIM;
import org.crosswire.modedit.Ibycus4IM;
import org.crosswire.modedit.NullIM;
import org.crosswire.modedit.SWInputMethod;

public class UniTextEdit
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel fontContentLoader = new JPanel();
    JPanel fontLoaderSizer = new JPanel();
    JPanel contentLoader = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JTextField jTextField1 = new JTextField();
    JTextField jTextField2 = new JTextField();
    JButton jButton1 = new JButton();
    JButton jButton2 = new JButton();
    JScrollPane textScrollPane = new JScrollPane();
    JPanel imSelect = new JPanel();
    JTextArea jTextArea1 = new JTextArea();
    JLabel statusBar = new JLabel();
    BorderLayout borderLayout4 = new BorderLayout();
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JPanel jPanel5 = new JPanel();
    JSlider fontSizer = new JSlider();
    BorderLayout borderLayout5 = new BorderLayout();
    JLabel jLabel3 = new JLabel();
    JComboBox imComboBox = new JComboBox();
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem jMenuItem2 = new JMenuItem();
    JMenuItem jMenuItem3 = new JMenuItem();
    JMenu jMenu2 = new JMenu();
    JMenuItem jMenuItem4 = new JMenuItem();
    JMenuItem jMenuItem5 = new JMenuItem();
    BorderLayout borderLayout6 = new BorderLayout();
    private static final long serialVersionUID = 8632340739785278662L;

    public UniTextEdit() {
        this.enableEvents(64L);
        this.jbInit();
    }

    private void jbInit() {
        this.setSize(new Dimension(549, 300));
        this.fontContentLoader.setLayout(this.borderLayout5);
        this.fontLoaderSizer.setLayout(this.borderLayout2);
        this.contentLoader.setLayout(this.borderLayout3);
        this.jLabel1.setMinimumSize(new Dimension(90, 13));
        this.jLabel1.setPreferredSize(new Dimension(90, 13));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("FontURL");
        this.jLabel2.setMinimumSize(new Dimension(90, 13));
        this.jLabel2.setPreferredSize(new Dimension(90, 13));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("contentURL");
        this.jTextField1.setToolTipText("");
        this.jTextField1.setText("http://www.crosswire.org/~scribe/ElEdit/1kg1.uni");
        this.jTextField2.setText("http://www.crosswire.org/~scribe/ElEdit/yoyo.ttf");
        this.jButton1.setText("Load");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UniTextEdit.this.jButton1_actionPerformed(e);
            }
        });
        this.jButton2.setText("Load");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UniTextEdit.this.jButton2_actionPerformed(e);
            }
        });
        this.jTextArea1.setText("");
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setFont(new Font("Dialog", 0, 30));
        this.jTextArea1.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                UniTextEdit.this.jTextArea1_keyTyped(e);
            }
        });
        this.statusBar.setText("");
        this.imSelect.setLayout(this.borderLayout4);
        this.fontSizer.setMinimum(1);
        this.fontSizer.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                UniTextEdit.this.fontSizer_stateChanged(e);
            }
        });
        this.jLabel3.setText("Keyboard");
        this.imComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                UniTextEdit.this.imComboBox_itemStateChanged(e);
            }
        });
        this.jMenu1.setText("File");
        this.jMenuItem1.setText("Lookup Url");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UniTextEdit.this.jMenuItem1_actionPerformed(e);
            }
        });
        this.jMenuItem2.setText("Exit");
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UniTextEdit.this.jMenuItem2_actionPerformed(e);
            }
        });
        this.jMenuItem3.setText("Save");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UniTextEdit.this.jMenuItem3_actionPerformed(e);
            }
        });
        this.jMenu2.setText("Edit");
        this.jMenuItem4.setText("Copy");
        this.jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UniTextEdit.this.jMenuItem4_actionPerformed(e);
            }
        });
        this.jMenuItem5.setText("Paste");
        this.jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UniTextEdit.this.jMenuItem5_actionPerformed(e);
            }
        });
        this.setLayout(this.borderLayout6);
        this.fontLoaderSizer.add((Component)this.jLabel1, "West");
        this.fontLoaderSizer.add((Component)this.jTextField2, "Center");
        this.fontLoaderSizer.add((Component)this.jButton2, "East");
        this.fontLoaderSizer.add((Component)this.fontSizer, "South");
        this.fontContentLoader.add((Component)this.contentLoader, "Center");
        this.fontContentLoader.add((Component)this.fontLoaderSizer, "North");
        this.contentLoader.add((Component)this.jLabel2, "West");
        this.contentLoader.add((Component)this.jButton1, "East");
        this.contentLoader.add((Component)this.jTextField1, "Center");
        this.add((Component)this.textScrollPane, "Center");
        this.add((Component)this.imSelect, "South");
        this.textScrollPane.getViewport().add((Component)this.jTextArea1, null);
        this.imSelect.add((Component)this.statusBar, "North");
        this.imSelect.add((Component)this.jPanel5, "East");
        this.jPanel5.add((Component)this.jLabel3, null);
        this.jPanel5.add((Component)this.imComboBox, null);
        this.add((Component)this.fontContentLoader, "North");
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenuItem3);
        this.jMenu1.add(this.jMenuItem2);
        this.jMenu2.add(this.jMenuItem4);
        this.jMenu2.add(this.jMenuItem5);
        this.fontSizer.setValue(this.jTextArea1.getFont().getSize());
        this.imComboBox.addItem(new GreekKeymanIM("Greek - Keyman"));
        this.imComboBox.addItem(new CGreekIM("Greek - CGreek"));
        this.imComboBox.addItem(new Ibycus4IM("Greek - Ibycus4"));
        this.imComboBox.addItem(new Gtk2ClassicalGreekIM("Greek - Gtk2 Classical"));
        this.imComboBox.addItem(new HebrewDurusauIM("Hebrew - Durusau"));
        this.imComboBox.addItem(new HebrewMCIM("Hebrew - Michigan-Claremont"));
        this.imComboBox.addItem(new NullIM("Latin"));
        this.imComboBox.setFocusable(false);
        this.jTextArea1.setFocusTraversalKeysEnabled(true);
        this.showLoaders(false);
        this.showIMSelect(false);
    }

    void jButton2_actionPerformed(ActionEvent e) {
        this.loadFont(this.jTextField2.getText());
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.load(this.jTextField1.getText());
    }

    void jTextArea1_keyTyped(KeyEvent e) {
        char typedChar = e.getKeyChar();
        String pushChar = null;
        this.statusBar.setText("");
        SWInputMethod inputMethod = (SWInputMethod)this.imComboBox.getSelectedItem();
        pushChar = inputMethod.translate(typedChar);
        if (inputMethod.getState() > 1) {
            this.statusBar.setText("Compound '" + typedChar + "'");
            e.consume();
        } else if (pushChar.length() > 1) {
            e.consume();
            this.jTextArea1.insert(pushChar, this.jTextArea1.getCaretPosition());
        } else {
            e.setKeyChar(pushChar.charAt(0));
        }
    }

    public void setFontSize(float size) {
        Font font = this.jTextArea1.getFont();
        Font newFont = font.deriveFont(size);
        this.jTextArea1.setFont(newFont);
    }

    void fontSizer_stateChanged(ChangeEvent e) {
        this.setFontSize(this.fontSizer.getValue());
    }

    void imComboBox_itemStateChanged(ItemEvent e) {
    }

    void jMenuItem1_actionPerformed(ActionEvent e) {
        String currentEntry = this.jTextField1.getText();
        JFileChooser fileChooser = new JFileChooser(currentEntry.startsWith("file://") ? currentEntry.substring(7) : ".");
        if (fileChooser.showOpenDialog(this) == 0) {
            this.jTextField1.setText("file://" + fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    void jMenuItem3_actionPerformed(ActionEvent e) {
        String currentEntry = this.jTextField1.getText();
        JFileChooser fileChooser = new JFileChooser(currentEntry.startsWith("file://") ? currentEntry.substring(7) : ".");
        if (fileChooser.showSaveDialog(this) == 0) {
            this.store(fileChooser.getSelectedFile());
        }
    }

    void jMenuItem4_actionPerformed(ActionEvent e) {
        this.jTextArea1.copy();
    }

    void jMenuItem5_actionPerformed(ActionEvent e) {
        this.jTextArea1.paste();
    }

    void jMenuItem2_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    public void showIMSelect(boolean show) {
        this.imSelect.setVisible(show);
    }

    public void showLoaders(boolean show) {
        this.fontContentLoader.setVisible(show);
    }

    public String getText() {
        StringWriter out = new StringWriter();
        try {
            this.jTextArea1.write(out);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(File outFile) {
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");
            this.jTextArea1.write(writer);
        }
        catch (Exception e1) {
            e1.printStackTrace(System.err);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public void requestFocus() {
        this.jTextArea1.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String url) {
        InputStream bis = null;
        try {
            int len;
            this.statusBar.setText("Loading content...");
            this.statusBar.paintImmediately(this.statusBar.getVisibleRect());
            URLConnection connection = new URL(url).openConnection();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bis = new BufferedInputStream(connection.getInputStream());
            byte[] inBuf = new byte[8192];
            do {
                if ((len = bis.read(inBuf, 0, 8192)) == -1) continue;
                bos.write(inBuf, 0, len);
            } while (len != -1);
            String newText = new String(bos.toByteArray(), "UTF-8");
            this.jTextArea1.setText(newText);
            this.statusBar.setText(Integer.toString(newText.length()) + " characters of content loaded.");
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public void addCaretListener(CaretListener l) {
        this.jTextArea1.addCaretListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void addKeyListener(KeyListener l) {
        this.jTextArea1.addKeyListener(l);
    }

    public void setComponentOrientation(ComponentOrientation o) {
        this.jTextArea1.setComponentOrientation(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFont(String url) {
        if (url.length() < 3) {
            return;
        }
        InputStream is = null;
        try {
            this.statusBar.setText("Loading font...");
            this.statusBar.paintImmediately(this.statusBar.getVisibleRect());
            URLConnection connection = new URL(url).openConnection();
            is = connection.getInputStream();
            this.loadFont(is);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (FontFormatException e) {
            e.printStackTrace(System.err);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public void loadFont(InputStream is) throws FontFormatException, IOException {
        this.statusBar.setText("Loading font...");
        this.statusBar.paintImmediately(this.statusBar.getVisibleRect());
        Font font = Font.createFont(0, is);
        Font newFont = font.deriveFont(18.0f);
        this.fontSizer.setValue(18);
        this.jTextArea1.setFont(newFont);
        this.statusBar.setText("New Font Loaded.");
    }

    public void setText(String text) {
        this.jTextArea1.setText(text);
        this.jTextArea1.repaint();
    }
}

