/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWMsg;
import org.crosswire.common.swing.CWOptionPane;
import org.crosswire.common.swing.CWOtherMsg;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.util.Convert;

public class StringArrayField
extends JPanel
implements Field {
    private static final String SEPARATOR = "#";
    private transient ActionFactory actions = new ActionFactory(this);
    private DefaultComboBoxModel list_model = new DefaultComboBoxModel();
    private JList list = new JList(this.list_model);
    private static final long serialVersionUID = 3256444715753878326L;

    public StringArrayField() {
        JPanel buttons = new JPanel(new FlowLayout());
        this.list.setFont(new Font("Monospaced", 0, 12));
        this.list.setSelectionMode(0);
        CWScrollPane scroll = new CWScrollPane(this.list);
        buttons.add(new JButton(this.actions.addAction("Add", CWMsg.gettext("Add", new Object[0]))));
        buttons.add(new JButton(this.actions.addAction("Remove", CWMsg.gettext("Remove", new Object[0]))));
        buttons.add(new JButton(this.actions.addAction("Update", CWMsg.gettext("Update", new Object[0]))));
        TitledBorder title = BorderFactory.createTitledBorder(CWOtherMsg.lookupText("Component Editor", new Object[0]));
        Border pad = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.setBorder(BorderFactory.createCompoundBorder(title, pad));
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        this.add((Component)buttons, "Last");
        GuiUtil.applyDefaultOrientation(this);
    }

    @Override
    public void setChoice(Choice param) {
    }

    @Override
    public String getValue() {
        return Convert.stringArray2String((String[])this.getArray(), (String)SEPARATOR);
    }

    public String[] getArray() {
        String[] retcode = new String[this.list_model.getSize()];
        for (int i = 0; i < retcode.length; ++i) {
            retcode[i] = (String)this.list_model.getElementAt(i);
        }
        return retcode;
    }

    @Override
    public void setValue(String value) {
        this.setArray(Convert.string2StringArray((String)value, (String)SEPARATOR));
    }

    public void setArray(String[] value) {
        this.list_model = new DefaultComboBoxModel<Object>((Object[])value.clone());
        this.list.setModel(this.list_model);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void doAddEntry() {
        InputPane input = new InputPane();
        if (CWOptionPane.showConfirmDialog(this, input, CWOtherMsg.lookupText("New Class", new Object[0]), 2) == 0) {
            String new_name = input.name_field.getText();
            this.list_model.addElement(new_name);
        }
    }

    public void doUpdateEntry() {
        InputPane input = new InputPane();
        input.name_field.setText(this.currentValue());
        if (CWOptionPane.showConfirmDialog(this, input, CWOtherMsg.lookupText("Edit Class", new Object[0]), 2) == 0) {
            String new_name = input.name_field.getText();
            this.list_model.removeElement(this.currentValue());
            this.list_model.addElement(new_name);
        }
    }

    public void doRemoveEntry() {
        this.list_model.removeElement(this.currentValue());
    }

    private String currentValue() {
        return (String)this.list_model.getElementAt(this.list.getSelectedIndex());
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.actions = new ActionFactory(this);
        is.defaultReadObject();
    }

    public static class InputPane
    extends JPanel {
        protected JTextField name_field = new JTextField();
        private static final long serialVersionUID = 3256444715753878326L;

        public InputPane() {
            super(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 22;
            c.insets = new Insets(0, 5, 0, 5);
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            this.add((Component)new JLabel(CWOtherMsg.lookupText("Name", new Object[0]) + ':'), c);
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            this.add((Component)this.name_field, c);
            this.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        }
    }
}

