/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.util.Translations;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.internationalisation.LocaleProviderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Languages {
    private static Map<Locale, ResourceBundle> localisedCommonLanguages = new HashMap<Locale, ResourceBundle>();
    protected static final Logger log = LoggerFactory.getLogger(Books.class);

    private Languages() {
    }

    public static String getName(String code) {
        String name = code;
        try {
            ResourceBundle langs = Languages.getLocalisedCommonLanguages();
            if (langs != null) {
                name = langs.getString(code);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ResourceBundle getLocalisedCommonLanguages() {
        Locale locale = LocaleProviderManager.getLocale();
        ResourceBundle langs = localisedCommonLanguages.get(locale);
        if (langs != null) return langs;
        Class<Languages> clazz = Languages.class;
        synchronized (Languages.class) {
            langs = localisedCommonLanguages.get(locale);
            if (langs != null || (langs = Languages.initLanguages(locale)) == null) return langs;
            localisedCommonLanguages.put(locale, langs);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return langs;
        }
    }

    private static ResourceBundle initLanguages(Locale locale) {
        try {
            return ResourceBundle.getBundle("iso639", locale, CWClassLoader.instance());
        }
        catch (MissingResourceException e) {
            log.info("Unable to find language in iso639 bundle", (Throwable)e);
            return null;
        }
    }

    public static final class RtoL {
        private static Set rtol = new HashSet();

        private RtoL() {
        }

        public static boolean isRtoL(String script, String lang) {
            if (script != null) {
                return rtol.contains(script);
            }
            if (lang != null) {
                return rtol.contains(lang);
            }
            return false;
        }

        static {
            try {
                URL index = ResourceUtil.getResource(Translations.class, "rtol.txt");
                String[] list = NetUtil.listByIndexFile(NetUtil.toURI(index));
                log.debug("Loading iso639full.properties file");
                for (int i = 0; i < list.length; ++i) {
                    rtol.add(list[i]);
                }
            }
            catch (IOException ex) {
                log.info("Unable to load rtol.txt", (Throwable)ex);
            }
        }
    }

    public static final class AllLanguages {
        private static PropertyMap instance;

        private AllLanguages() {
        }

        public static String getName(String languageCode) {
            String name;
            if (instance != null && (name = instance.get(languageCode)) != null) {
                return name;
            }
            return languageCode;
        }

        static {
            try {
                instance = ResourceUtil.getProperties("iso639full");
                log.debug("Loading iso639full.properties file");
            }
            catch (IOException e) {
                log.info("Unable to load iso639full.properties", (Throwable)e);
            }
        }
    }
}

