/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.LucidRuntimeException;
import org.crosswire.common.util.ReporterEvent;
import org.crosswire.common.util.ReporterListener;
import org.crosswire.common.util.TimeGate;
import org.crosswire.jsword.JSMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Reporter {
    private static final String AWT_HANDLER_PROPERTY = "sun.awt.exception.handler";
    private static final String OUR_NAME = CustomAWTExceptionHandler.class.getName();
    private static final List<ReporterListener> LISTENERS = new CopyOnWriteArrayList<ReporterListener>();
    private static final Logger log = LoggerFactory.getLogger(Reporter.class);

    private Reporter() {
    }

    public static void informUser(Object source, Throwable prob) {
        Class cat = source != null ? source.getClass() : Reporter.class;
        Logger templog = LoggerFactory.getLogger(cat);
        templog.warn(prob.getMessage(), prob);
        Reporter.fireCapture(new ReporterEvent(source, prob));
    }

    public static void informUser(Object source, LucidException prob) {
        Class cat = source != null ? source.getClass() : Reporter.class;
        Logger templog = LoggerFactory.getLogger(cat);
        templog.warn(prob.getMessage(), (Throwable)prob);
        Reporter.fireCapture(new ReporterEvent(source, prob));
    }

    public static void informUser(Object source, LucidRuntimeException prob) {
        Class cat = source != null ? source.getClass() : Reporter.class;
        Logger templog = LoggerFactory.getLogger(cat);
        templog.warn(prob.getMessage(), (Throwable)prob);
        Reporter.fireCapture(new ReporterEvent(source, prob));
    }

    public static void informUser(Object source, String message) {
        log.debug(message);
        Reporter.fireCapture(new ReporterEvent(source, message));
    }

    public static void addReporterListener(ReporterListener li) {
        LISTENERS.add(li);
    }

    public static void removeReporterListener(ReporterListener li) {
        LISTENERS.remove(li);
    }

    protected static void fireCapture(ReporterEvent ev) {
        if (LISTENERS.size() == 0) {
            log.warn("Nothing to listen to report: message={}", (Object)ev.getMessage(), (Object)ev.getException());
        }
        for (ReporterListener listener : LISTENERS) {
            if (ev.getException() != null) {
                listener.reportException(ev);
                continue;
            }
            listener.reportMessage(ev);
        }
    }

    public static void grabAWTExecptions(boolean grab) {
        if (grab) {
            System.setProperty(AWT_HANDLER_PROPERTY, OUR_NAME);
        } else {
            String current = System.getProperty(AWT_HANDLER_PROPERTY);
            if (current != null && current.equals(OUR_NAME)) {
                Properties prop = System.getProperties();
                prop.remove(AWT_HANDLER_PROPERTY);
            }
        }
    }

    public static final class CustomAWTExceptionHandler {
        private static TimeGate gate = new TimeGate(2000);

        public void handle(Throwable ex) {
            if (gate.open()) {
                Reporter.informUser((Object)this, new LucidException(JSMsg.gettext("Unexpected internal problem. You may need to restart.", new Object[0]), ex));
            }
        }
    }
}

