/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.Iterator;
import java.util.List;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.BookList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBook {
    private Book book;
    private final BookList books;
    private final BookFilter filter;
    private static final Logger log = LoggerFactory.getLogger(DefaultBook.class);

    public DefaultBook(BookList bookList, BookFilter bookFilter) {
        this.books = bookList;
        this.filter = bookFilter;
    }

    public void setDefault(Book newBook) {
        if (this.filter.test(newBook)) {
            this.book = newBook;
        }
    }

    public void setDefaultConditionally(Book newBook) {
        if (this.book == null) {
            this.setDefault(newBook);
        }
    }

    protected void unsetDefault() {
        this.book = null;
        this.checkReplacement();
    }

    protected void unsetDefaultConditionally(Book oldBook) {
        if (this.book == oldBook) {
            this.unsetDefault();
        }
    }

    public Book getDefault() {
        return this.book;
    }

    public String getDefaultName() {
        if (this.book == null) {
            return null;
        }
        return this.book.getName();
    }

    public void setDefaultByName(String name) {
        if (name == null || name.length() == 0) {
            log.warn("Attempt to set empty book as default. Ignoring");
            return;
        }
        for (Book aBook : this.books.getBooks(this.filter)) {
            if (!aBook.match(name)) continue;
            this.setDefault(aBook);
            return;
        }
        log.warn("Book not found. Ignoring: {}", (Object)name);
    }

    protected void checkReplacement() {
        List<Book> bookList = this.books.getBooks(this.filter);
        Iterator<Book> it = bookList.iterator();
        if (it.hasNext()) {
            this.book = it.next();
        }
    }
}

