/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword.state;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.state.RawLDBackendState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZLDBackendState
extends RawLDBackendState {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String EXTENSION_Z_INDEX = ".zdx";
    private static final String EXTENSION_Z_DATA = ".zdt";
    private File zdxFile = null;
    private RandomAccessFile zdxRaf = null;
    private File zdtFile = null;
    private RandomAccessFile zdtRaf = null;
    private long lastBlockNum = -1L;
    private byte[] lastUncompressed = EMPTY_BYTES;
    private static final Logger log = LoggerFactory.getLogger(ZLDBackendState.class);

    ZLDBackendState(SwordBookMetaData bookMetaData) throws BookException {
        super(bookMetaData);
        URI path = null;
        try {
            path = SwordUtil.getExpandedDataPath(bookMetaData);
        }
        catch (BookException e) {
            Reporter.informUser((Object)this, e);
            return;
        }
        try {
            this.zdxFile = new File(path.getPath() + EXTENSION_Z_INDEX);
            this.zdtFile = new File(path.getPath() + EXTENSION_Z_DATA);
            if (!this.zdxFile.canRead()) {
                Reporter.informUser((Object)this, new BookException(JSMsg.gettext("Error reading {0}", this.zdtFile.getAbsolutePath())));
                return;
            }
            if (!this.zdtFile.canRead()) {
                Reporter.informUser((Object)this, new BookException(JSMsg.gettext("Error reading {0}", this.zdtFile.getAbsolutePath())));
                return;
            }
            this.zdxRaf = new RandomAccessFile(this.zdxFile, "r");
            this.zdtRaf = new RandomAccessFile(this.zdtFile, "r");
        }
        catch (IOException ex) {
            IOUtil.close(this.zdxRaf);
            IOUtil.close(this.zdtRaf);
            log.error("failed to open files", (Throwable)ex);
            this.zdxRaf = null;
            this.zdtRaf = null;
            return;
        }
    }

    @Override
    public void releaseResources() {
        super.releaseResources();
        this.lastBlockNum = -1L;
        this.lastUncompressed = EMPTY_BYTES;
        IOUtil.close(this.zdxRaf);
        IOUtil.close(this.zdtRaf);
        this.zdxRaf = null;
        this.zdtRaf = null;
    }

    public RandomAccessFile getZdxRaf() {
        return this.zdxRaf;
    }

    public RandomAccessFile getZdtRaf() {
        return this.zdtRaf;
    }

    public long getLastBlockNum() {
        return this.lastBlockNum;
    }

    public byte[] getLastUncompressed() {
        return this.lastUncompressed;
    }

    public void setLastBlockNum(long lastBlockNum) {
        this.lastBlockNum = lastBlockNum;
    }

    public void setLastUncompressed(byte[] lastUncompressed) {
        this.lastUncompressed = lastUncompressed;
    }
}

