/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene;

import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.index.Index;
import org.crosswire.jsword.index.query.Query;
import org.crosswire.jsword.index.query.QueryBuilderFactory;
import org.crosswire.jsword.index.search.DefaultSearchRequest;
import org.crosswire.jsword.index.search.SearchRequest;
import org.crosswire.jsword.index.search.Searcher;
import org.crosswire.jsword.passage.Key;

public class LuceneSearcher
implements Searcher {
    private Index index;

    @Override
    public void init(Index newindex) {
        this.index = newindex;
    }

    public Key search(String request) throws BookException {
        return this.search(new DefaultSearchRequest(request));
    }

    @Override
    public Key search(SearchRequest request) throws BookException {
        this.index.setSearchModifier(request.getSearchModifier());
        Query query = QueryBuilderFactory.getQueryBuilder().parse(request.getRequest());
        Key results = this.search(query);
        this.index.setSearchModifier(null);
        return results;
    }

    @Override
    public Key search(Query query) throws BookException {
        return query.find(this.index);
    }

    protected Index getIndex() {
        return this.index;
    }
}

