/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.passage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import org.crosswire.common.icu.NumberShaper;
import org.crosswire.common.util.ItemIterator;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.JSOtherMsg;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchVerseException;
import org.crosswire.jsword.passage.PassageUtil;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.VerseKey;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.BibleBook;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;

public final class Verse
implements VerseKey {
    public static final String VERSE_OSIS_DELIM = ".";
    public static final String VERSE_PREF_DELIM1 = " ";
    public static final String VERSE_PREF_DELIM2 = ":";
    public static final Verse DEFAULT = new Verse(Versifications.instance().getVersification("KJV"), BibleBook.GEN, 1, 1);
    private static NumberShaper shaper = new NumberShaper();
    private transient Versification v11n;
    private int ordinal;
    private transient BibleBook book;
    private transient int chapter;
    private transient int verse;
    private transient String originalName;
    private static final long serialVersionUID = -4033921076023185171L;

    @Deprecated
    public Verse() {
        this.originalName = null;
        this.book = Verse.DEFAULT.book;
        this.chapter = Verse.DEFAULT.chapter;
        this.verse = Verse.DEFAULT.verse;
        this.v11n = Verse.DEFAULT.v11n;
    }

    @Deprecated
    Verse(String original, BibleBook book, int chapter, int verse) {
        this(original, Versifications.instance().getDefaultVersification(), book, chapter, verse);
    }

    Verse(String original, Versification v11n, BibleBook book, int chapter, int verse) {
        this.originalName = original;
        this.v11n = v11n;
        this.book = book;
        this.chapter = chapter;
        this.verse = verse;
        this.ordinal = v11n.getOrdinal(this);
    }

    @Deprecated
    public Verse(BibleBook book, int chapter, int verse) {
        this(null, Versifications.instance().getDefaultVersification(), book, chapter, verse);
    }

    public Verse(Versification v11n, BibleBook book, int chapter, int verse) {
        this(null, v11n, book, chapter, verse);
    }

    @Deprecated
    public Verse(BibleBook book, int chapter, int verse, boolean patch_up) {
        this(Versifications.instance().getDefaultVersification(), book, chapter, verse, patch_up);
    }

    public Verse(Versification v11n, BibleBook book, int chapter, int verse, boolean patch_up) {
        if (!patch_up) {
            throw new IllegalArgumentException(JSOtherMsg.lookupText("Use patch=true.", new Object[0]));
        }
        this.v11n = v11n;
        Verse patched = this.v11n.patch(book, chapter, verse);
        this.originalName = null;
        this.book = patched.book;
        this.chapter = patched.chapter;
        this.verse = patched.verse;
        this.ordinal = patched.ordinal;
    }

    @Deprecated
    public Verse(int ordinal) {
        this(Versifications.instance().getDefaultVersification(), ordinal);
    }

    public Verse(Versification v11n, int ordinal) {
        Verse decoded = v11n.decodeOrdinal(ordinal);
        this.originalName = null;
        this.book = decoded.book;
        this.chapter = decoded.chapter;
        this.verse = decoded.verse;
        this.ordinal = decoded.ordinal;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.getName(null);
    }

    @Override
    public String getName(Key base) {
        if (base != null && !(base instanceof Verse)) {
            return this.getName();
        }
        if (PassageUtil.isPersistentNaming() && this.originalName != null) {
            return this.originalName;
        }
        String verseName = this.doGetName((Verse)base);
        if (shaper.canUnshape()) {
            return shaper.shape(verseName);
        }
        return verseName;
    }

    @Override
    public String getRootName() {
        return this.v11n.getShortName(this.book);
    }

    @Override
    public String getOsisRef() {
        return this.book.getOSIS() + VERSE_OSIS_DELIM + this.chapter + VERSE_OSIS_DELIM + this.verse;
    }

    @Override
    public String getOsisID() {
        return this.getOsisRef();
    }

    @Override
    public Verse clone() {
        Verse copy;
        block2: {
            copy = null;
            try {
                copy = (Verse)super.clone();
                copy.originalName = this.originalName;
                copy.v11n = this.v11n;
                copy.book = this.book;
                copy.chapter = this.chapter;
                copy.verse = this.verse;
                copy.ordinal = this.ordinal;
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return copy;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        Verse that = (Verse)obj;
        return this.ordinal == that.ordinal && this.v11n.equals(that.v11n);
    }

    @Override
    public int hashCode() {
        return this.ordinal;
    }

    @Override
    public int compareTo(Key obj) {
        Verse that = null;
        that = obj instanceof Verse ? (Verse)obj : ((VerseRange)obj).getStart();
        int thatStart = that.ordinal;
        int thisStart = this.ordinal;
        if (thatStart > thisStart) {
            return -1;
        }
        if (thatStart < thisStart) {
            return 1;
        }
        return 0;
    }

    @Deprecated
    public boolean adjacentTo(Verse that) {
        return this.v11n.isAdjacentVerse(this, that);
    }

    @Deprecated
    public int subtract(Verse start) {
        return this.v11n.distance(this, start);
    }

    @Deprecated
    public Verse subtract(int n) {
        return this.v11n.subtract(this, n);
    }

    @Deprecated
    public Verse add(int n) {
        return this.v11n.add(this, n);
    }

    @Override
    public Versification getVersification() {
        return this.v11n;
    }

    public BibleBook getBook() {
        return this.book;
    }

    public int getChapter() {
        return this.chapter;
    }

    public int getVerse() {
        return this.verse;
    }

    @Deprecated
    public boolean isStartOfChapter() {
        return this.v11n.isStartOfChapter(this);
    }

    @Deprecated
    public boolean isEndOfChapter() {
        return this.v11n.isEndOfChapter(this);
    }

    @Deprecated
    public boolean isStartOfBook() {
        return this.v11n.isStartOfBook(this);
    }

    @Deprecated
    public boolean isEndOfBook() {
        return this.v11n.isEndOfBook(this);
    }

    @Deprecated
    public boolean isSameChapter(Verse that) {
        return this.book == that.book && this.chapter == that.chapter;
    }

    @Deprecated
    public boolean isSameBook(Verse that) {
        return this.book == that.book;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Deprecated
    public static Verse max(Verse a, Verse b) {
        if (a.compareTo(b) == -1) {
            return b;
        }
        return a;
    }

    @Deprecated
    public static Verse min(Verse a, Verse b) {
        if (a.compareTo(b) == 1) {
            return b;
        }
        return a;
    }

    public Verse[] toVerseArray() {
        return new Verse[]{this};
    }

    @Override
    public Key getParent() {
        return null;
    }

    private String doGetName(Verse verseBase) {
        StringBuilder buf = new StringBuilder();
        if (this.v11n.getLastChapter(this.book) == 1) {
            if (verseBase == null || verseBase.book != this.book) {
                buf.append(this.v11n.getPreferredName(this.book));
                buf.append(VERSE_PREF_DELIM1);
                buf.append(this.verse);
                return buf.toString();
            }
            return Integer.toString(this.verse);
        }
        if (verseBase == null || verseBase.book != this.book) {
            buf.append(this.v11n.getPreferredName(this.book));
            buf.append(VERSE_PREF_DELIM1);
            buf.append(this.chapter);
            buf.append(VERSE_PREF_DELIM2);
            buf.append(this.verse);
            return buf.toString();
        }
        if (verseBase.chapter != this.chapter) {
            buf.append(this.chapter);
            buf.append(VERSE_PREF_DELIM2);
            buf.append(this.verse);
            return buf.toString();
        }
        return Integer.toString(this.verse);
    }

    protected static int parseInt(String text) throws NoSuchVerseException {
        try {
            return Integer.parseInt(shaper.unshape(text));
        }
        catch (NumberFormatException ex) {
            throw new NoSuchVerseException(JSMsg.gettext("Cannot understand {0} as a chapter or verse.", text));
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.v11n.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String v11nName = in.readUTF();
        this.v11n = Versifications.instance().getVersification(v11nName);
        Verse decoded = this.v11n.decodeOrdinal(this.ordinal);
        this.book = decoded.book;
        this.chapter = decoded.chapter;
        this.verse = decoded.verse;
    }

    @Override
    public boolean canHaveChildren() {
        return false;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public int getCardinality() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Key key) {
        return this.equals(key);
    }

    @Override
    public Iterator<Key> iterator() {
        return new ItemIterator<Key>(this);
    }

    @Override
    public void addAll(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAll(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void retainAll(Key key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
    }

    @Override
    public Key get(int index) {
        if (index == 0) {
            return this;
        }
        return null;
    }

    @Override
    public int indexOf(Key that) {
        if (this.equals(that)) {
            return 0;
        }
        return -1;
    }

    @Override
    public void blur(int by, RestrictionType restrict) {
        throw new UnsupportedOperationException();
    }
}

