/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import org.apache.lucene.LucenePackage;

public final class Constants {
    public static final String JAVA_VERSION;
    public static final boolean JAVA_1_1;
    public static final boolean JAVA_1_2;
    public static final boolean JAVA_1_3;
    public static final String OS_NAME;
    public static final boolean LINUX;
    public static final boolean WINDOWS;
    public static final boolean SUN_OS;
    public static final String OS_ARCH;
    public static final String OS_VERSION;
    public static final String JAVA_VENDOR;
    public static final boolean JRE_IS_64BIT;
    public static final String LUCENE_MAIN_VERSION;
    public static final String LUCENE_VERSION;

    private Constants() {
    }

    private static String ident(String s) {
        return s.toString();
    }

    static {
        String v;
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_1_1 = JAVA_VERSION.startsWith("1.1.");
        JAVA_1_2 = JAVA_VERSION.startsWith("1.2.");
        JAVA_1_3 = JAVA_VERSION.startsWith("1.3.");
        OS_NAME = System.getProperty("os.name");
        LINUX = OS_NAME.startsWith("Linux");
        WINDOWS = OS_NAME.startsWith("Windows");
        SUN_OS = OS_NAME.startsWith("SunOS");
        OS_ARCH = System.getProperty("os.arch");
        OS_VERSION = System.getProperty("os.version");
        JAVA_VENDOR = System.getProperty("java.vendor");
        String x = System.getProperty("sun.arch.data.model");
        JRE_IS_64BIT = x != null ? x.indexOf("64") != -1 : OS_ARCH != null && OS_ARCH.indexOf("64") != -1;
        LUCENE_MAIN_VERSION = Constants.ident("3.0.3");
        Package pkg = LucenePackage.get();
        String string = v = pkg == null ? null : pkg.getImplementationVersion();
        if (v == null) {
            v = LUCENE_MAIN_VERSION + "-dev";
        } else if (!v.startsWith(LUCENE_MAIN_VERSION)) {
            v = LUCENE_MAIN_VERSION + "-dev " + v;
        }
        LUCENE_VERSION = Constants.ident(v);
    }
}

