/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing.desktop;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.desktop.AbstractViewLayout;
import org.crosswire.common.swing.desktop.Clearable;

public class MDIViewLayout
extends AbstractViewLayout {
    protected JDesktopPane desk = new JDesktopPane();

    public MDIViewLayout() {
        this.getPanel().add((Component)this.desk, this.getConstraint());
    }

    @Override
    public void addView(Component view) {
        super.addView(view);
        String name = this.getTitle(view);
        JInternalFrame iframe = new JInternalFrame(name, true, true, true, true);
        iframe.setPreferredSize(new Dimension(640, 480));
        iframe.getContentPane().add(view);
        this.desk.add(iframe);
        iframe.addInternalFrameListener(new CustomInternalFrameAdapter());
        iframe.addVetoableChangeListener(new CloseListener());
        GuiUtil.applyDefaultOrientation(iframe);
        iframe.setVisible(true);
        iframe.pack();
    }

    @Override
    public void removeView(Component view) {
        Container comp = SwingUtilities.getAncestorOfClass(JInternalFrame.class, view);
        if (comp instanceof JInternalFrame) {
            JInternalFrame iframe = (JInternalFrame)comp;
            if (this.getViewCount() > 1) {
                this.removeInternalFrameListener(iframe);
                iframe.dispose();
                super.removeView(view);
            } else {
                if (view instanceof Clearable) {
                    ((Clearable)((Object)view)).clear();
                }
                iframe.setVisible(true);
            }
        }
    }

    @Override
    protected void forceRemoveView(Component component) {
        Container comp = SwingUtilities.getAncestorOfClass(JInternalFrame.class, component);
        if (comp instanceof JInternalFrame) {
            JInternalFrame iframe = (JInternalFrame)comp;
            this.removeInternalFrameListener(iframe);
            iframe.dispose();
        }
        super.forceRemoveView(component);
    }

    @Override
    public void updateTitle(Component view) {
        Container comp = SwingUtilities.getAncestorOfClass(JInternalFrame.class, view);
        if (comp instanceof JInternalFrame) {
            JInternalFrame iframe = (JInternalFrame)comp;
            iframe.setTitle(this.getTitle(view));
        }
    }

    @Override
    public Component getSelected() {
        JInternalFrame frame = this.desk.getSelectedFrame();
        if (frame == null) {
            Component[] comps = this.desk.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof JInternalFrame)) continue;
                frame = (JInternalFrame)comps[i];
                break;
            }
        }
        if (frame == null) {
            return null;
        }
        Container contentPane = frame.getContentPane();
        if (contentPane.getComponentCount() > 0) {
            return contentPane.getComponent(0);
        }
        return null;
    }

    @Override
    public void select(Component component) {
        JInternalFrame frame = this.desk.getSelectedFrame();
        if (frame != null && frame.getContentPane().getComponent(0) == component) {
            return;
        }
        Component[] comps = this.desk.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof JInternalFrame) || (frame = (JInternalFrame)comps[i]).getContentPane().getComponent(0) != component) continue;
            this.desk.setSelectedFrame(frame);
            return;
        }
    }

    private void removeInternalFrameListener(JInternalFrame iframe) {
        InternalFrameListener[] listeners = iframe.getInternalFrameListeners();
        for (int i = 0; i < listeners.length; ++i) {
            InternalFrameListener listener = listeners[i];
            if (!(listener instanceof CustomInternalFrameAdapter)) continue;
            iframe.removeInternalFrameListener(listener);
        }
    }

    class CloseListener
    implements VetoableChangeListener {
        CloseListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            String name = evt.getPropertyName();
            if (name.equals("closed") && MDIViewLayout.this.desk.getComponentCount() == 1) {
                throw new PropertyVetoException("Cannot close the last window", evt);
            }
        }
    }

    class CustomInternalFrameAdapter
    extends InternalFrameAdapter {
        CustomInternalFrameAdapter() {
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent ev) {
            JInternalFrame iframe = ev.getInternalFrame();
            Component view = iframe.getContentPane().getComponent(0);
            MDIViewLayout.this.removeView(view);
        }
    }
}

