/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class FileUtil {
    public static final String EXTENSION_JAVA = ".java";
    public static final String EXTENSION_PROPERTIES = ".properties";
    public static final String EXTENSION_PLUGIN = ".plugin";
    public static final String EXTENSION_XSLT = ".xsl";
    public static final String EXTENSION_XML = ".xml";
    public static final String MODE_READ = "r";
    public static final String MODE_WRITE = "rw";

    private FileUtil() {
    }

    public static List<File> delete(File file) {
        ArrayList<File> failures = new ArrayList<File>();
        if (file.isDirectory()) {
            FileUtil.deleteContents(file, failures);
        }
        if (!file.delete()) {
            failures.add(file);
        }
        return failures;
    }

    private static void deleteContents(File dirPath, List<File> failures) {
        String[] ls = dirPath.list();
        for (int idx = 0; idx < ls.length; ++idx) {
            File file = new File(dirPath, ls[idx]);
            if (file.isDirectory()) {
                FileUtil.deleteContents(file, failures);
            }
            if (file.delete()) continue;
            failures.add(file);
        }
    }
}

