/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.ArrayList;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookFilter;
import org.crosswire.jsword.book.FeatureType;

public final class BookFilters {
    private static boolean commentariesWithBibles;

    private BookFilters() {
    }

    public static BookFilter getAll() {
        return new AllBookFilter();
    }

    public static BookFilter getBibles() {
        if (commentariesWithBibles) {
            return BookFilters.either(new BookCategoryFilter(BookCategory.BIBLE), new BookCategoryFilter(BookCategory.COMMENTARY));
        }
        return new BookCategoryFilter(BookCategory.BIBLE);
    }

    public static BookFilter getOnlyBibles() {
        return new BookCategoryFilter(BookCategory.BIBLE);
    }

    public static BookFilter getNonBibles() {
        if (commentariesWithBibles) {
            return BookFilters.both(new NotBookCategoryFilter(BookCategory.BIBLE), new NotBookCategoryFilter(BookCategory.COMMENTARY));
        }
        return new NotBookCategoryFilter(BookCategory.BIBLE);
    }

    public static BookFilter getDictionaries() {
        return new BookCategoryFilter(BookCategory.DICTIONARY);
    }

    public static BookFilter getGlossaries() {
        return new BookCategoryFilter(BookCategory.GLOSSARY);
    }

    public static BookFilter getDailyDevotionals() {
        return new BookCategoryFilter(BookCategory.DAILY_DEVOTIONS);
    }

    public static BookFilter getCommentaries() {
        return new BookCategoryFilter(BookCategory.COMMENTARY);
    }

    public static BookFilter getGeneralBooks() {
        return new BookCategoryFilter(BookCategory.GENERAL_BOOK);
    }

    public static BookFilter getMaps() {
        return new BookCategoryFilter(BookCategory.MAPS);
    }

    public static BookFilter getGreekDefinitions() {
        return new BookFeatureFilter(FeatureType.GREEK_DEFINITIONS);
    }

    public static BookFilter getGreekParse() {
        return new BookFeatureFilter(FeatureType.GREEK_PARSE);
    }

    public static BookFilter getHebrewDefinitions() {
        return new BookFeatureFilter(FeatureType.HEBREW_DEFINITIONS);
    }

    public static BookFilter getHebrewParse() {
        return new BookFeatureFilter(FeatureType.HEBREW_PARSE);
    }

    public static boolean isCommentariesWithBibles() {
        return commentariesWithBibles;
    }

    public static void setCommentariesWithBibles(boolean current) {
        commentariesWithBibles = current;
    }

    public static BookFilter both(final BookFilter b1, final BookFilter b2) {
        return new BookFilter(){

            @Override
            public boolean test(Book book) {
                return b1.test(book) && b2.test(book);
            }
        };
    }

    public static BookFilter either(final BookFilter b1, final BookFilter b2) {
        return new BookFilter(){

            @Override
            public boolean test(Book book) {
                return b1.test(book) || b2.test(book);
            }
        };
    }

    public static BookFilter getBooksByDriver(final BookDriver driver) {
        return new BookFilter(){

            @Override
            public boolean test(Book book) {
                return book.getDriver() == driver;
            }
        };
    }

    public static BookFilter getCustom(String match) {
        return new CustomBookFilter(match);
    }

    static class CustomBookFilter
    implements BookFilter {
        private Test[] tests;

        public CustomBookFilter(String match) {
            ArrayList<Test> cache = new ArrayList<Test>();
            String[] filters = match.split(";");
            for (int i = 0; i < filters.length; ++i) {
                cache.add(new Test(filters[i]));
            }
            this.tests = cache.toArray(new Test[cache.size()]);
        }

        @Override
        public boolean test(Book book) {
            for (int i = 0; i < this.tests.length; ++i) {
                Test test = this.tests[i];
                Object result = book.getProperty(test.property);
                if (result != null && test.result.equals(result.toString())) continue;
                return false;
            }
            return true;
        }

        static class Test {
            protected String property;
            protected String result;

            protected Test(String filter) {
                String[] parts = filter.split("=");
                if (parts.length != 2 || parts[0].length() == 0 || parts[1].length() == 0) {
                    throw new IllegalArgumentException("Filter format is 'property=value', given: " + filter);
                }
                this.property = parts[0];
                this.result = parts[1];
            }

            protected Test(String property, String result) {
                this.property = property;
                this.result = result;
            }
        }
    }

    public static class BookFeatureFilter
    implements BookFilter {
        private FeatureType feature;

        public BookFeatureFilter(FeatureType feature) {
            this.feature = feature;
        }

        @Override
        public boolean test(Book book) {
            return book.hasFeature(this.feature) && !book.isLocked();
        }
    }

    static class NotBookCategoryFilter
    implements BookFilter {
        private BookCategory category;

        NotBookCategoryFilter(BookCategory category) {
            this.category = category;
        }

        @Override
        public boolean test(Book book) {
            return !book.getBookCategory().equals((Object)this.category) && !book.isLocked();
        }
    }

    static class BookCategoryFilter
    implements BookFilter {
        private BookCategory category;

        BookCategoryFilter(BookCategory category) {
            this.category = category;
        }

        @Override
        public boolean test(Book book) {
            return book.getBookCategory().equals((Object)this.category) && !book.isLocked();
        }
    }

    static class AllBookFilter
    implements BookFilter {
        AllBookFilter() {
        }

        @Override
        public boolean test(Book book) {
            return true;
        }
    }
}

