/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.io.IOException;
import org.crosswire.common.util.PluginUtil;
import org.crosswire.jsword.book.Bookmark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BookmarkFactory {
    private static Bookmark instance;
    private static final Logger log;

    private BookmarkFactory() {
    }

    public static Bookmark getBookmark() {
        return instance.clone();
    }

    static {
        log = LoggerFactory.getLogger(BookmarkFactory.class);
        try {
            instance = PluginUtil.getImplementation(Bookmark.class);
        }
        catch (IOException e) {
            log.error("createBookmark failed", (Throwable)e);
        }
        catch (ClassCastException e) {
            log.error("createBookmark failed", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("createBookmark failed", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("createBookmark failed", (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error("createBookmark failed", (Throwable)e);
        }
    }
}

