/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.util.Map;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.StringUtil;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBookMetaData;
import org.crosswire.jsword.index.IndexManager;
import org.crosswire.jsword.index.IndexManagerFactory;
import org.crosswire.jsword.index.IndexStatus;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class DefaultBookMetaData
extends AbstractBookMetaData {
    private BookCategory type;
    private String name;
    private String initials;

    public DefaultBookMetaData(BookDriver driver, Book book, Map<String, Object> prop) {
        this.setDriver(driver);
        this.setProperties(prop);
        this.setName((String)prop.get("Description"));
        this.setType((String)prop.get("Category"));
        String lang = (String)prop.get("Lang");
        this.setLanguage(new Language(lang));
        IndexManager imanager = IndexManagerFactory.getIndexManager();
        if (imanager.isIndexed(book)) {
            this.setIndexStatus(IndexStatus.DONE);
        } else {
            this.setIndexStatus(IndexStatus.UNDONE);
        }
    }

    public DefaultBookMetaData(BookDriver driver, String name, BookCategory type) {
        this.setDriver(driver);
        this.setName(name);
        this.setBookCategory(type);
        this.setLanguage(Language.DEFAULT_LANG);
    }

    @Override
    public BookCategory getBookCategory() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInitials() {
        return this.initials;
    }

    @Override
    public boolean isLeftToRight() {
        return this.getLanguage().isLeftToRight();
    }

    public void setInitials(String initials) {
        this.initials = initials == null ? (this.name == null ? "" : StringUtil.getInitials(this.name)) : initials;
        this.putProperty("Initials", this.initials);
    }

    public void setName(String name) {
        this.name = name;
        this.putProperty("Description", this.name);
        this.setInitials(StringUtil.getInitials(name));
    }

    public void setBookCategory(BookCategory aType) {
        BookCategory t = aType;
        if (t == null) {
            t = BookCategory.BIBLE;
        }
        this.type = t;
        this.putProperty("Category", (Object)this.type);
    }

    public void setType(String typestr) {
        BookCategory newType = null;
        if (typestr != null) {
            newType = BookCategory.fromString(typestr);
        }
        this.setBookCategory(newType);
    }

    @Override
    public Document toOSIS() {
        OSISUtil.OSISFactory factory = OSISUtil.factory();
        Element ele = factory.createTable();
        this.addRow(ele, "Initials", this.getInitials());
        this.addRow(ele, "Description", this.getName());
        this.addRow(ele, "Key", this.getBookCategory().toString());
        this.addRow(ele, "Language", this.getLanguage().getName());
        return new Document(ele);
    }

    private void addRow(Element table, String key, String value) {
        if (value == null) {
            return;
        }
        OSISUtil.OSISFactory factory = OSISUtil.factory();
        Element rowEle = factory.createRow();
        Element nameEle = factory.createCell();
        Element hiEle = factory.createHI();
        hiEle.setAttribute("type", "bold");
        nameEle.addContent((Content)hiEle);
        Element valueElement = factory.createCell();
        rowEle.addContent((Content)nameEle);
        rowEle.addContent((Content)valueElement);
        hiEle.addContent(key);
        String expandedValue = XMLUtil.escape(value);
        valueElement.addContent(expandedValue);
        table.addContent((Content)rowEle);
    }
}

