/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.sword;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.crosswire.common.crypt.Sapphire;
import org.crosswire.common.util.IOUtil;
import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.sword.ConfigEntryType;
import org.crosswire.jsword.book.sword.StatefulFileBackedBackend;
import org.crosswire.jsword.book.sword.SwordBookMetaData;
import org.crosswire.jsword.book.sword.SwordUtil;
import org.crosswire.jsword.book.sword.processing.RawTextToXmlProcessor;
import org.crosswire.jsword.book.sword.state.OpenFileState;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;
import org.jdom2.Content;

public abstract class AbstractBackend<T extends OpenFileState>
implements StatefulFileBackedBackend<T> {
    private SwordBookMetaData bmd;
    private Versification versificationSystem;

    public AbstractBackend() {
    }

    public AbstractBackend(SwordBookMetaData sbmd) {
        this.bmd = sbmd;
    }

    public SwordBookMetaData getBookMetaData() {
        return this.bmd;
    }

    public void decipher(byte[] data) {
        String cipherKeyString = (String)this.getBookMetaData().getProperty(ConfigEntryType.CIPHER_KEY);
        if (cipherKeyString != null) {
            Sapphire cipherEngine = new Sapphire(cipherKeyString.getBytes());
            for (int i = 0; i < data.length; ++i) {
                data[i] = cipherEngine.cipher(data[i]);
            }
            cipherEngine.burn();
        }
    }

    public void encipher(byte[] data) {
        this.decipher(data);
    }

    public Key readIndex() {
        return null;
    }

    public abstract boolean contains(Key var1);

    public Key getGlobalKeyList() throws BookException {
        throw new UnsupportedOperationException("Fast global key list unsupported in this backend");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Content> readToOsis(Key key, RawTextToXmlProcessor processor) throws BookException {
        ArrayList<Content> content = new ArrayList<Content>();
        Closeable openFileState = null;
        try {
            openFileState = (Closeable)this.initState();
            switch (this.bmd.getKeyType()) {
                case LIST: 
                case TREE: {
                    this.readNormalOsis(key, processor, content, openFileState);
                    break;
                }
                case VERSE: {
                    this.readPassageOsis(key, processor, content, openFileState);
                    break;
                }
                default: {
                    throw new BookException("Book has unsupported type of key");
                }
            }
            ArrayList<Content> arrayList = content;
            return arrayList;
        }
        finally {
            IOUtil.close(openFileState);
        }
    }

    private void readNormalOsis(Key key, RawTextToXmlProcessor processor, List<Content> content, T openFileState) throws BookException {
        for (Key next : key) {
            try {
                String rawText = this.readRawContent(openFileState, next);
                processor.postVerse(next, content, rawText);
            }
            catch (IOException e) {
                this.throwFailedKeyException(key, next, e);
            }
        }
    }

    private Verse readPassageOsis(Key key, RawTextToXmlProcessor processor, List<Content> content, T openFileState) throws BookException {
        Verse currentVerse = null;
        try {
            Passage ref = KeyUtil.getPassage(key);
            Iterator<Key> rit = ref.rangeIterator(RestrictionType.CHAPTER);
            while (rit.hasNext()) {
                VerseRange range = (VerseRange)rit.next();
                processor.preRange(range, content);
                for (Key verseInRange : range) {
                    currentVerse = KeyUtil.getVerse(verseInRange);
                    String rawText = this.readRawContent(openFileState, currentVerse);
                    processor.postVerse(verseInRange, content, rawText);
                }
            }
        }
        catch (IOException e) {
            this.throwFailedKeyException(key, currentVerse, e);
        }
        return currentVerse;
    }

    private void throwFailedKeyException(Key masterKey, Key currentKey, IOException e) throws BookException {
        if (currentKey == null) {
            throw new BookException(JSMsg.gettext("Error reading {0}", masterKey.getName()), e);
        }
        throw new BookException(JSMsg.gettext("Error reading {0}", currentKey.getName()), e);
    }

    public void create() throws IOException, BookException {
        File dataPath = new File(SwordUtil.getExpandedDataPath(this.getBookMetaData()));
        if (!dataPath.exists() && !dataPath.mkdirs()) {
            throw new IOException("Unable to create module data path!");
        }
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isWritable() {
        return false;
    }

    public Versification getVersification() {
        if (this.versificationSystem == null) {
            this.versificationSystem = Versifications.instance().getVersification((String)this.getBookMetaData().getProperty("Versification"));
        }
        return this.versificationSystem;
    }
}

