/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ar.ArabicLetterTokenizer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fa.PersianNormalizationFilter;
import org.apache.lucene.util.Version;
import org.crosswire.jsword.index.lucene.analysis.AbstractBookAnalyzer;
import org.crosswire.jsword.index.lucene.analysis.SavedStreams;

public class PersianLuceneAnalyzer
extends AbstractBookAnalyzer {
    private final Version matchVersion = Version.LUCENE_29;

    public PersianLuceneAnalyzer() {
        this.stopSet = PersianAnalyzer.getDefaultStopSet();
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        ArabicLetterTokenizer result = new ArabicLetterTokenizer(reader);
        result = new LowerCaseFilter((TokenStream)result);
        result = new ArabicNormalizationFilter((TokenStream)result);
        result = new PersianNormalizationFilter((TokenStream)result);
        if (this.doStopWords && this.stopSet != null) {
            result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), (TokenStream)result, this.stopSet);
        }
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams((Tokenizer)new ArabicLetterTokenizer(reader));
            streams.setResult((TokenStream)new LowerCaseFilter(streams.getResult()));
            streams.setResult((TokenStream)new ArabicNormalizationFilter(streams.getResult()));
            streams.setResult((TokenStream)new PersianNormalizationFilter(streams.getResult()));
            if (this.doStopWords && this.stopSet != null) {
                streams.setResult((TokenStream)new StopFilter(false, streams.getResult(), this.stopSet));
            }
            this.setPreviousTokenStream(streams);
        } else {
            streams.getSource().reset(reader);
        }
        return streams.getResult();
    }
}

