/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.crosswire.common.diff.Diff;
import org.crosswire.common.diff.DiffCleanup;
import org.crosswire.common.diff.Difference;
import org.crosswire.common.util.Language;
import org.crosswire.common.xml.JDOMSAXEventProvider;
import org.crosswire.common.xml.SAXEventProvider;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookException;
import org.crosswire.jsword.book.BookProvider;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.UnAccenter;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.KeyUtil;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseKey;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.VersificationsMapper;
import org.crosswire.jsword.versification.system.Versifications;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;

public class BookData
implements BookProvider {
    private Key key;
    private Book[] books;
    private boolean comparingBooks;
    private Element osis;
    private Element fragment;
    private UnAccenter unaccenter;

    public BookData(Book book, Key key) {
        assert (book != null);
        assert (key != null);
        this.key = key;
        this.books = new Book[1];
        this.books[0] = book;
    }

    public BookData(Book[] books, Key key, boolean compare) {
        assert (books != null && books.length > 0);
        assert (key != null);
        this.books = (Book[])books.clone();
        this.key = key;
        this.comparingBooks = compare;
    }

    public Element getOsis() throws BookException {
        if (this.osis == null) {
            this.osis = OSISUtil.createOsisFramework(this.getFirstBook().getBookMetaData());
            Element text = this.osis.getChild("osisText");
            Element div = this.getOsisFragment();
            text.addContent((Content)div);
        }
        return this.osis;
    }

    public Element getOsisFragment() throws BookException {
        if (this.fragment == null) {
            this.fragment = this.getOsisContent(true);
        }
        return this.fragment;
    }

    public Element getOsisFragment(boolean allowGenTitles) throws BookException {
        if (this.fragment == null) {
            this.fragment = this.getOsisContent(allowGenTitles);
        }
        return this.fragment;
    }

    public SAXEventProvider getSAXEventProvider() throws BookException {
        Element frag = this.getOsisFragment();
        Document doc = frag.getDocument();
        if (doc == null) {
            doc = new Document(frag);
        }
        return new JDOMSAXEventProvider(doc);
    }

    @Override
    public Book[] getBooks() {
        return this.books == null ? null : (Book[])this.books.clone();
    }

    @Override
    public Book getFirstBook() {
        return this.books != null && this.books.length > 0 ? this.books[0] : null;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean isComparingBooks() {
        return this.comparingBooks;
    }

    private Element getOsisContent(boolean allowGenTitles) throws BookException {
        Element div = OSISUtil.factory().createDiv();
        if (this.books.length == 1) {
            Iterator<Content> iter = this.books[0].getOsisIterator(this.key, false, allowGenTitles);
            while (iter.hasNext()) {
                Content content = iter.next();
                div.addContent(content);
            }
        } else {
            Element table = OSISUtil.factory().createTable();
            Element row = OSISUtil.factory().createRow();
            Element cell = OSISUtil.factory().createCell();
            table.addContent((Content)row);
            Iterator[] iters = new Iterator[this.books.length];
            Passage[] passages = new Passage[this.books.length];
            boolean[] showDiffs = new boolean[this.books.length - 1];
            boolean doDiffs = false;
            boolean[] ommittedVerses = new boolean[this.books.length];
            int numRangesInMasterPassage = 0;
            for (int i = 0; i < this.books.length; ++i) {
                passages[i] = VersificationsMapper.instance().map(KeyUtil.getPassage(this.key), this.getVersification(i));
                iters[i] = this.books[i].getOsisIterator(passages[i], true, true);
                if (i == 0) {
                    ommittedVerses[i] = false;
                    numRangesInMasterPassage = passages[i].countRanges(RestrictionType.NONE);
                    continue;
                }
                ommittedVerses[i] = passages[i].countRanges(RestrictionType.NONE) > numRangesInMasterPassage;
            }
            BookVerseContent[] booksContents = new BookVerseContent[this.books.length];
            for (int i = 0; i < this.books.length; ++i) {
                doDiffs |= this.addHeaderAndSetShowDiffsState(row, showDiffs, i, ommittedVerses[i]);
                booksContents[i] = this.keyIteratorContentByVerse(this.getVersification(i), iters[i]);
            }
            int cellCount = 0;
            int rowCount = 0;
            for (Map.Entry verseContent : booksContents[0].entrySet()) {
                cellCount = 0;
                row = OSISUtil.factory().createRow();
                String firstText = "";
                for (int i = 0; i < this.books.length; ++i) {
                    Book book = this.books[i];
                    cell = OSISUtil.factory().createCell();
                    Language lang = book.getLanguage();
                    if (lang != null) {
                        cell.setAttribute("lang", lang.getCode(), Namespace.XML_NAMESPACE);
                    }
                    row.addContent((Content)cell);
                    StringBuilder newText = new StringBuilder(doDiffs ? 32 : 0);
                    VerseKey verseInRelavantBookContents = VersificationsMapper.instance().mapVerse((Verse)verseContent.getKey(), this.getVersification(i));
                    Passage passageOfInterest = KeyUtil.getPassage(verseInRelavantBookContents);
                    for (Key singleKey : passageOfInterest) {
                        if (!(singleKey instanceof Verse)) {
                            throw new UnsupportedOperationException("Iterating through a passage gives non-verses");
                        }
                        ArrayList<Content> xmlContent = (ArrayList<Content>)booksContents[i].get(singleKey);
                        if (xmlContent == null) {
                            xmlContent = new ArrayList<Content>(0);
                        }
                        this.addText(doDiffs, newText, xmlContent);
                        if (doDiffs) {
                            String thisText = newText.toString();
                            if (this.unaccenter != null) {
                                thisText = this.unaccenter.unaccent(thisText);
                            }
                            if (i > 0 && showDiffs[i - 1]) {
                                List<Difference> diffs = new Diff(firstText, thisText, false).compare();
                                DiffCleanup.cleanupSemantic(diffs);
                                cell.addContent(OSISUtil.diffToOsis(diffs));
                                cell = OSISUtil.factory().createCell();
                                lang = book.getLanguage();
                                cell.setAttribute("lang", lang.getCode(), Namespace.XML_NAMESPACE);
                                row.addContent((Content)cell);
                            }
                            if (i == 0) {
                                firstText = thisText;
                            }
                        }
                        this.addContentSafely(cell, xmlContent);
                        ++cellCount;
                    }
                }
                if (cellCount == 0) break;
                table.addContent((Content)row);
                ++rowCount;
            }
            if (rowCount > 0) {
                div.addContent((Content)table);
            }
        }
        return div;
    }

    private void addContentSafely(Element cell, List<Content> xmlContent) {
        Element note = null;
        for (Content c : xmlContent) {
            if (c.getParent() == null) {
                cell.addContent(c);
                continue;
            }
            if (note != null) {
                note.addContent(c.clone());
                continue;
            }
            note = this.appendVersificationNotice(cell, "duplicate");
            note.addContent(c.clone());
        }
    }

    private Element appendVersificationNotice(Element parent, String notice) {
        Element note = OSISUtil.factory().createDiv();
        note.setAttribute("type", "x-gen");
        note.setAttribute("subType", "x-" + notice);
        parent.addContent((Content)note);
        return note;
    }

    private Versification getVersification(int i) {
        return Versifications.instance().getVersification(this.books[i].getBookMetaData().getProperty("Versification"));
    }

    private BookVerseContent keyIteratorContentByVerse(Versification v11n, Iterator<Content> iter) throws BookException {
        BookVerseContent contentsByOsisID = new BookVerseContent();
        Verse currentVerse = null;
        ArrayList<Content> contents = new ArrayList<Content>();
        while (iter.hasNext()) {
            Content content = iter.next();
            if (content instanceof Element && "verse".equals(((Element)content).getName())) {
                if (currentVerse != null) {
                    contentsByOsisID.put(currentVerse, contents);
                    contents = new ArrayList();
                }
                currentVerse = OSISUtil.getVerse(v11n, (Element)content);
                if (contents.size() > 0) {
                    Verse previousVerse = new Verse(currentVerse.getVersification(), currentVerse.getOrdinal() - 1);
                    contentsByOsisID.put(previousVerse, contents);
                    contents = new ArrayList();
                }
            }
            contents.add(content);
        }
        if (currentVerse != null) {
            contentsByOsisID.put(currentVerse, contents);
        }
        return contentsByOsisID;
    }

    private boolean addHeaderAndSetShowDiffsState(Element row, boolean[] showDiffs, int i, boolean ommittedVerse) {
        boolean doDiffs = false;
        Book book = this.books[i];
        Element cell = OSISUtil.factory().createHeaderCell();
        if (i > 0) {
            Book firstBook = this.books[0];
            BookCategory category = book.getBookCategory();
            BookCategory prevCategory = firstBook.getBookCategory();
            String prevName = firstBook.getInitials();
            boolean bl = showDiffs[i - 1] = this.comparingBooks && BookCategory.BIBLE.equals((Object)category) && category.equals((Object)prevCategory) && book.getLanguage().equals(firstBook.getLanguage()) && !book.getInitials().equals(prevName);
            if (showDiffs[i - 1]) {
                doDiffs = true;
                StringBuilder buf = new StringBuilder(firstBook.getInitials());
                buf.append(" ==> ");
                buf.append(book.getInitials());
                cell.addContent((Content)OSISUtil.factory().createText(buf.toString()));
                row.addContent((Content)cell);
                cell = OSISUtil.factory().createHeaderCell();
            }
        }
        Text text = OSISUtil.factory().createText(book.getInitials());
        if (ommittedVerse) {
            Element notice = this.appendVersificationNotice(cell, "omitted-verses");
            notice.addContent((Content)text);
        } else {
            cell.addContent((Content)text);
        }
        row.addContent((Content)cell);
        return doDiffs;
    }

    private void addText(boolean doDiffs, StringBuilder newText, List<Content> contents) {
        for (Content c : contents) {
            this.addText(doDiffs, newText, c);
        }
    }

    private void addText(boolean doDiffs, StringBuilder newText, Content content) {
        if (doDiffs) {
            if (newText.length() != 0) {
                newText.append(' ');
            }
            if (content instanceof Element) {
                newText.append(OSISUtil.getCanonicalText((Element)content));
            } else if (content instanceof Text) {
                newText.append(((Text)content).getText());
            }
        }
    }

    public void setUnaccenter(UnAccenter unaccenter) {
        this.unaccenter = unaccenter;
    }

    class BookVerseContent
    extends TreeMap<Verse, List<Content>> {
        private static final long serialVersionUID = -6508118172314227362L;

        BookVerseContent() {
        }
    }
}

