/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.index.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseTokenizer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.util.Version;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.index.lucene.analysis.AbstractBookAnalyzer;
import org.crosswire.jsword.index.lucene.analysis.SavedStreams;

public class ConfigurableSnowballAnalyzer
extends AbstractBookAnalyzer {
    private String stemmerName;
    private static Map<String, String> languageCodeToStemmerLanguageNameMap = new HashMap<String, String>();
    private static HashMap<String, Set<?>> defaultStopWordMap;
    private final Version matchVersion = Version.LUCENE_29;

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        LowerCaseTokenizer result = new LowerCaseTokenizer(reader);
        if (this.doStopWords && this.stopSet != null) {
            result = new StopFilter(false, (TokenStream)result, this.stopSet);
        }
        if (this.doStemming) {
            result = new SnowballFilter((TokenStream)result, this.stemmerName);
        }
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams((Tokenizer)new LowerCaseTokenizer(reader));
            if (this.doStopWords && this.stopSet != null) {
                streams.setResult((TokenStream)new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.getResult(), this.stopSet));
            }
            if (this.doStemming) {
                streams.setResult((TokenStream)new SnowballFilter(streams.getResult(), this.stemmerName));
            }
            this.setPreviousTokenStream(streams);
        } else {
            streams.getSource().reset(reader);
        }
        return streams.getResult();
    }

    @Override
    public void setBook(Book newBook) {
        this.book = newBook;
        this.stemmerName = null;
        if (this.book != null) {
            this.pickStemmer(this.book.getLanguage().getCode());
        }
    }

    public void pickStemmer(String languageCode) {
        if (languageCode != null) {
            if (!languageCodeToStemmerLanguageNameMap.containsKey(languageCode)) {
                throw new IllegalArgumentException("SnowballAnalyzer configured for unavailable stemmer " + this.stemmerName);
            }
            this.stemmerName = languageCodeToStemmerLanguageNameMap.get(languageCode);
            if (defaultStopWordMap.containsKey(languageCode)) {
                this.stopSet = defaultStopWordMap.get(languageCode);
            }
        }
    }

    static {
        languageCodeToStemmerLanguageNameMap.put("da", "Danish");
        languageCodeToStemmerLanguageNameMap.put("nl", "Dutch");
        languageCodeToStemmerLanguageNameMap.put("en", "English");
        languageCodeToStemmerLanguageNameMap.put("fi", "Finnish");
        languageCodeToStemmerLanguageNameMap.put("fr", "French");
        languageCodeToStemmerLanguageNameMap.put("de", "German");
        languageCodeToStemmerLanguageNameMap.put("it", "Italian");
        languageCodeToStemmerLanguageNameMap.put("no", "Norwegian");
        languageCodeToStemmerLanguageNameMap.put("pt", "Portuguese");
        languageCodeToStemmerLanguageNameMap.put("ru", "Russian");
        languageCodeToStemmerLanguageNameMap.put("es", "Spanish");
        languageCodeToStemmerLanguageNameMap.put("sv", "Swedish");
        defaultStopWordMap = new HashMap();
        defaultStopWordMap.put("fr", FrenchAnalyzer.getDefaultStopSet());
        defaultStopWordMap.put("de", GermanAnalyzer.getDefaultStopSet());
        defaultStopWordMap.put("nl", DutchAnalyzer.getDefaultStopSet());
        defaultStopWordMap.put("en", StopAnalyzer.ENGLISH_STOP_WORDS_SET);
    }
}

