/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.compress;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.crosswire.common.compress.AbstractCompressor;

public class XZ
extends AbstractCompressor {
    public XZ(InputStream input) {
        super(input);
    }

    @Override
    public ByteArrayOutputStream compress() throws IOException {
        BufferedInputStream in = new BufferedInputStream(this.input);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XZCompressorOutputStream out = new XZCompressorOutputStream((OutputStream)bos);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        out.flush();
        out.close();
        return bos;
    }

    @Override
    public ByteArrayOutputStream uncompress() throws IOException {
        return this.uncompress(2048);
    }

    @Override
    public ByteArrayOutputStream uncompress(int expectedLength) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(expectedLength);
        XZCompressorInputStream in = new XZCompressorInputStream(this.input);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        out.flush();
        out.close();
        return out;
    }
}

