/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.crosswire.common.history.HistoryEvent;
import org.crosswire.common.history.HistoryListener;

public class History {
    private List<Object> nav = new ArrayList<Object>();
    private Map<Object, Long> history = new HashMap<Object, Long>();
    private int backCount;
    private List<HistoryListener> listeners = new CopyOnWriteArrayList<HistoryListener>();

    public Object select(int index) {
        int i = index;
        int size = this.nav.size();
        if (i > size) {
            i = size;
        } else if (i < 1) {
            i = 1;
        }
        if (i != this.backCount) {
            this.backCount = i;
            this.fireHistoryChanged();
        }
        return this.getCurrent();
    }

    public void add(Object obj) {
        Object current = this.getCurrent();
        if (obj == null || obj.equals(current)) {
            return;
        }
        int size = this.nav.size();
        if (size > this.backCount) {
            int pos;
            for (pos = this.backCount; pos < size && !obj.equals(this.nav.get(pos)); ++pos) {
            }
            this.nav.subList(this.backCount, Math.min(pos, size)).clear();
        }
        if (!obj.equals(this.peek(1))) {
            this.nav.add(this.backCount, obj);
        }
        ++this.backCount;
        this.visit(obj);
        this.fireHistoryChanged();
    }

    public List<Object> getPreviousList() {
        if (this.backCount > 0) {
            return Collections.unmodifiableList(this.nav.subList(0, this.backCount));
        }
        return Collections.emptyList();
    }

    public List<Object> getNextList() {
        if (this.backCount < this.nav.size()) {
            return Collections.unmodifiableList(this.nav.subList(this.backCount, this.nav.size()));
        }
        return Collections.emptyList();
    }

    public Object go(int i) {
        return this.select(this.backCount + i);
    }

    public Object getCurrent() {
        if (!this.nav.isEmpty() && this.backCount > 0) {
            return this.nav.get(this.backCount - 1);
        }
        return null;
    }

    private Object peek(int i) {
        int size = this.nav.size();
        if (size > 0 && this.backCount > 0 && this.backCount + i <= size) {
            return this.nav.get(this.backCount + i - 1);
        }
        return null;
    }

    public void addHistoryListener(HistoryListener li) {
        this.listeners.add(li);
    }

    public void removeHistoryListener(HistoryListener li) {
        this.listeners.remove(li);
    }

    private void visit(Object obj) {
        this.history.put(obj, System.currentTimeMillis());
    }

    private void fireHistoryChanged() {
        HistoryEvent ev = new HistoryEvent(this);
        for (HistoryListener listener : this.listeners) {
            listener.historyChanged(ev);
        }
    }
}

