/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ListSet<E>
extends AbstractCollection<E>
implements Set<E> {
    protected List<E> list = new ArrayList();
    protected Set<E> set;

    public ListSet() {
        this(null);
    }

    public ListSet(Comparator<? super E> comparator) {
        this.set = new TreeSet<E>(comparator);
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean add(E e) {
        boolean added = this.set.add(e);
        if (added) {
            this.list.add(e);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.set.remove(o);
        if (removed) {
            this.list.remove(o);
        }
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean removed = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            E next = it.next();
            if (c.contains(next)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public void clear() {
        this.set.clear();
        this.list.clear();
    }

    public E get(int index) {
        return this.list.get(index);
    }

    public E get(int index, E defaultValue) {
        E value = this.list.get(index);
        return value != null ? value : defaultValue;
    }

    public E remove(int index) {
        E t = this.list.get(index);
        this.remove(t);
        return t;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private Iterator<E> itr;
            private E current;
            {
                this.itr = ListSet.this.list.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public E next() {
                Object next = this.itr.next();
                this.current = next;
                return next;
            }

            @Override
            public void remove() {
                this.itr.remove();
                ListSet.this.set.remove(this.current);
                this.current = null;
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }
}

