/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Writer;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.book.DisplaySelectEvent;
import org.crosswire.bibledesktop.book.DisplaySelectListener;
import org.crosswire.bibledesktop.book.DisplaySelectPane;
import org.crosswire.bibledesktop.display.basic.SplitBookDataDisplay;
import org.crosswire.bibledesktop.display.basic.TabbedBookDataDisplay;
import org.crosswire.bibledesktop.passage.KeySidebar;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.desktop.Clearable;
import org.crosswire.common.swing.desktop.TabbedPanePanel;
import org.crosswire.common.swing.desktop.Titleable;
import org.crosswire.common.swing.desktop.event.TitleChangedEvent;
import org.crosswire.common.swing.desktop.event.TitleChangedListener;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BibleViewPane
extends TabbedPanePanel
implements Titleable,
Clearable,
TitleChangedListener {
    protected File saved;
    private transient EventListenerList listeners = new EventListenerList();
    private DisplaySelectPane pnlSelect = new DisplaySelectPane();
    protected SplitBookDataDisplay pnlPassg;
    private JFileChooser chooser;
    private static final String BOOKMARK_DIR = "bookmarks";
    private static final String EXTENSION = ".lst";
    protected static final Logger log = LoggerFactory.getLogger(BibleViewPane.class);
    private static final long serialVersionUID = 3258415036346282038L;

    public BibleViewPane(boolean showSidebar) {
        KeySidebar sidebar = new KeySidebar(this.pnlSelect.getBooks());
        TabbedBookDataDisplay display = new TabbedBookDataDisplay();
        this.pnlPassg = new SplitBookDataDisplay(sidebar, display);
        this.pnlPassg.showSidebar(showSidebar);
        sidebar.addKeyChangeListener(this.pnlSelect);
        this.pnlSelect.addCommandListener(sidebar);
        this.pnlSelect.addTitleChangedListener(this);
        this.pnlPassg.addKeyChangeListener(sidebar);
        this.init();
        this.pnlSelect.doInitialTextDisplay();
    }

    private void init() {
        try {
            this.chooser = new JFileChooser(CWProject.instance().getWritableProjectSubdir(BOOKMARK_DIR, true).getPath());
        }
        catch (IOException ex) {
            this.chooser = new JFileChooser(CWProject.instance().getWritableProjectDir().getPath());
        }
        this.chooser.setFileSelectionMode(0);
        this.chooser.addChoosableFileFilter(new CustomFileFilter());
        this.chooser.setMultiSelectionEnabled(false);
        this.pnlSelect.addCommandListener(new DisplaySelectListener(){

            @Override
            public void passageSelected(DisplaySelectEvent ev) {
                BibleViewPane.this.pnlPassg.setBookData(ev.getBookProvider().getBooks(), ev.getKey());
            }

            @Override
            public void bookChosen(DisplaySelectEvent ev) {
                BibleViewPane.this.pnlPassg.setBookData(ev.getBookProvider().getBooks(), ev.getKey());
            }
        });
        this.pnlSelect.setBorder(UIManager.getBorder("SelectPanel.border"));
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(0, 0));
        this.add((Component)this.pnlSelect, "North");
        this.add((Component)this.pnlPassg, "Center");
        GuiUtil.applyDefaultOrientation(this);
    }

    @Override
    public void clear() {
        this.saved = null;
        if (!this.pnlSelect.isClear()) {
            this.pnlSelect.clear();
        }
    }

    @Override
    public boolean isClear() {
        this.saved = null;
        return this.pnlSelect.isClear();
    }

    @Override
    public String getTitle() {
        if (this.saved == null) {
            return this.pnlSelect.getTitle();
        }
        return this.saved.getName();
    }

    public void save() throws IOException {
        Key key = this.getKey();
        if (key == null) {
            return;
        }
        if (this.saved == null && !this.querySaveFile()) {
            return;
        }
        this.saveKey(key);
    }

    public void saveAs() throws IOException {
        Key key = this.getKey();
        if (key == null) {
            return;
        }
        this.querySaveFile();
        this.saveKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveKey(Key key) throws IOException {
        assert (this.saved != null);
        FileWriter out = null;
        try {
            out = new FileWriter(this.saved);
            if (key instanceof Passage) {
                Passage ref = (Passage)key;
                ref.writeDescription((Writer)out);
            } else {
                out.write(key.getName());
                out.write("\n");
            }
        }
        finally {
            if (out != null) {
                ((Writer)out).close();
            }
        }
    }

    public boolean maySave() {
        return this.getKey() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws NoSuchKeyException, IOException {
        int reply = this.chooser.showOpenDialog(this.getRootPane());
        if (reply == 0) {
            this.saved = this.chooser.getSelectedFile();
            if (this.saved.length() == 0L) {
                Reporter.informUser((Object)this.getRootPane(), (String)BDMsg.gettext("File {0} is empty", this.saved.getName()));
                return;
            }
            FileReader in = null;
            try {
                in = new FileReader(this.saved);
                Passage ref = PassageKeyFactory.readPassage((Reader)in);
                this.setKey((Key)ref);
            }
            finally {
                if (in != null) {
                    ((Reader)in).close();
                }
            }
        }
    }

    private boolean querySaveFile() {
        if (this.saved == null) {
            File guess = new File(this.getTitle() + EXTENSION);
            this.chooser.setSelectedFile(guess);
        } else {
            this.chooser.setSelectedFile(this.saved);
        }
        int reply = this.chooser.showSaveDialog(this.getRootPane());
        if (reply == 0) {
            this.saved = this.chooser.getSelectedFile();
            return true;
        }
        return false;
    }

    public Key getKey() {
        return this.pnlPassg.getKey();
    }

    public final void setKey(Key key) {
        this.pnlSelect.setKey(key);
    }

    public SplitBookDataDisplay getPassagePane() {
        return this.pnlPassg;
    }

    public DisplaySelectPane getSelectPane() {
        return this.pnlSelect;
    }

    @Override
    public synchronized void addTitleChangedListener(TitleChangedListener li) {
        this.listeners.add(TitleChangedListener.class, li);
    }

    @Override
    public synchronized void removeTitleChangedListener(TitleChangedListener li) {
        this.listeners.remove(TitleChangedListener.class, li);
    }

    protected void fireTitleChanged(TitleChangedEvent ev) {
        Object[] contents = this.listeners.getListenerList();
        for (int i = contents.length - 2; i >= 0; i -= 2) {
            if (contents[i] != TitleChangedListener.class) continue;
            ((TitleChangedListener)contents[i + 1]).titleChanged(ev);
        }
    }

    @Override
    public void titleChanged(TitleChangedEvent ev) {
        if (this.saved == null) {
            this.fireTitleChanged(new TitleChangedEvent(this, this.getTitle()));
        }
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.listeners = new EventListenerList();
        is.defaultReadObject();
    }

    static final class CustomFileFilter
    extends FileFilter {
        CustomFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(BibleViewPane.EXTENSION);
        }

        @Override
        public String getDescription() {
            return BDMsg.gettext("Verse Lists ({0})", BibleViewPane.EXTENSION);
        }
    }
}

