/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.util.Map;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.MultipleChoice;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.config.swing.OptionsField;
import org.crosswire.common.config.swing.TextField;
import org.crosswire.common.util.PluginUtil;
import org.crosswire.common.util.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FieldMap {
    private static Map<String, Class<Field>> map = PluginUtil.getImplementorsMap(Field.class);
    private static final Logger log = LoggerFactory.getLogger(FieldMap.class);

    private FieldMap() {
    }

    public static Field getField(Choice type) {
        Field field = null;
        ReflectiveOperationException ex = null;
        try {
            if (type instanceof MultipleChoice) {
                field = new OptionsField();
            } else {
                Class<Field> clazz = map.get(type.getType());
                if (clazz != null) {
                    field = clazz.newInstance();
                } else {
                    log.warn("field type ({}) unregistered.", (Object)type);
                    field = new TextField();
                }
            }
            field.setChoice(type);
        }
        catch (InstantiationException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        if (ex != null) {
            log.warn("field type ({}) initialization failed:", (Object)type, (Object)ex);
            Reporter.informUser((Object)type, (Throwable)ex);
            log.warn("field type ({}) unregistered.", (Object)type);
            field = new TextField();
            field.setChoice(type);
        }
        return field;
    }
}

