/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.util.IOUtil;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.JSMsg;

public class WebResource {
    private static int timeout = 750;
    private URI uri;
    private CloseableHttpClient client;

    public WebResource(URI theURI) {
        this(theURI, null, null, timeout);
    }

    public WebResource(URI theURI, int theTimeout) {
        this(theURI, null, null, theTimeout);
    }

    public WebResource(URI theURI, String theProxyHost) {
        this(theURI, theProxyHost, null, timeout);
    }

    public WebResource(URI theURI, String theProxyHost, int theTimeout) {
        this(theURI, theProxyHost, null, theTimeout);
    }

    public WebResource(URI theURI, String theProxyHost, Integer theProxyPort) {
        this(theURI, theProxyHost, theProxyPort, timeout);
    }

    public WebResource(URI theURI, String theProxyHost, Integer theProxyPort, int theTimeout) {
        this.uri = theURI;
        HttpHost proxy = null;
        if (theProxyHost != null && theProxyHost.length() > 0) {
            proxy = new HttpHost(theProxyHost, theProxyPort == null ? -1 : theProxyPort);
        }
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(theTimeout).setConnectionRequestTimeout(theTimeout).setSocketTimeout(theTimeout).setProxy(proxy);
        this.client = HttpClientBuilder.create().setDefaultRequestConfig(builder.build()).build();
    }

    public void shutdown() {
        IOUtil.close((Closeable)this.client);
    }

    public static int getTimeout() {
        return timeout;
    }

    public static void setTimeout(int timeout) {
        WebResource.timeout = timeout;
    }

    public int getSize() {
        HttpHead method = new HttpHead(this.uri);
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)method);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                return this.getHeaderAsInt((HttpResponse)response, "Content-Length");
            }
            String reason = response.getStatusLine().getReasonPhrase();
            Reporter.informUser((Object)this, JSMsg.gettext("Unable to find: {0}", reason + ':' + this.uri.getPath()));
        }
        catch (IOException e) {
            return 0;
        }
        return 0;
    }

    public long getLastModified() {
        HttpHead method = new HttpHead(this.uri);
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)method);
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() == 200) {
                return this.getHeaderAsDate((HttpResponse)response, "Last-Modified");
            }
            String reason = response.getStatusLine().getReasonPhrase();
            Reporter.informUser((Object)this, JSMsg.gettext("Unable to find: {0}", reason + ':' + this.uri.getPath()));
        }
        catch (IOException e) {
            return new Date().getTime();
        }
        return new Date().getTime();
    }

    public void copy(URI dest, Progress meter) throws LucidException {
        OutputStream out;
        InputStream in;
        block9: {
            in = null;
            out = null;
            HttpGet method = new HttpGet(this.uri);
            CloseableHttpResponse response = null;
            HttpEntity entity = null;
            try {
                response = this.client.execute((HttpUriRequest)method);
                if (meter != null) {
                    int size = this.getHeaderAsInt((HttpResponse)response, "Content-Length");
                    if (size == 0) {
                        size = this.getSize();
                    }
                    meter.setTotalWork(size);
                }
                if ((entity = response.getEntity()) != null) {
                    in = entity.getContent();
                    out = NetUtil.getOutputStream(dest);
                    byte[] buf = new byte[4096];
                    int count = in.read(buf);
                    while (-1 != count) {
                        if (meter != null) {
                            meter.incrementWorkDone(count);
                        }
                        out.write(buf, 0, count);
                        count = in.read(buf);
                    }
                    break block9;
                }
                String reason = response.getStatusLine().getReasonPhrase();
                Reporter.informUser((Object)this, JSMsg.gettext("Unable to find: {0}", reason + ':' + this.uri.getPath()));
            }
            catch (IOException e) {
                try {
                    throw new LucidException(JSMsg.gettext("Unable to find: {0}", this.uri.toString()), e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    IOUtil.close(out);
                    throw throwable;
                }
            }
        }
        IOUtil.close(in);
        IOUtil.close(out);
    }

    public void copy(URI dest) throws LucidException {
        this.copy(dest, null);
    }

    private int getHeaderAsInt(HttpResponse response, String field) {
        Header header = response.getFirstHeader(field);
        if (header == null) {
            return 0;
        }
        String value = header.getValue();
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    private long getHeaderAsDate(HttpResponse response, String field) {
        Header header = response.getFirstHeader(field);
        String value = header.getValue();
        return DateUtils.parseDate((String)value).getTime();
    }
}

