/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.passage.RangeListModel;
import org.crosswire.bibledesktop.passage.WholeBibleTreeModel;
import org.crosswire.bibledesktop.passage.WholeBibleTreeNode;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWAction;
import org.crosswire.common.swing.CWLabel;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.passage.Passage;
import org.crosswire.jsword.passage.PassageEvent;
import org.crosswire.jsword.passage.PassageKeyFactory;
import org.crosswire.jsword.passage.PassageListener;
import org.crosswire.jsword.passage.RestrictionType;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;

public class PassageSelectionPane
extends JPanel {
    private static final String GOOD_ICON = "toolbarButtonGraphics/general/About24.gif";
    private static final String BAD_ICON = "toolbarButtonGraphics/general/Stop24.gif";
    protected transient PassageKeyFactory keyf = PassageKeyFactory.instance();
    protected boolean bailout;
    private boolean changing;
    private Passage ref;
    private transient ActionFactory actions;
    private transient Icon icoGood = GuiUtil.getIcon("toolbarButtonGraphics/general/About24.gif");
    private transient Icon icoBad = GuiUtil.getIcon("toolbarButtonGraphics/general/Stop24.gif");
    private JTree treAll;
    private JList lstSel;
    private RangeListModel model;
    private JTextField txtDisplay;
    private JLabel lblMessage;
    protected JDialog dlgMain;
    private static final long serialVersionUID = 3546920298944673072L;

    public PassageSelectionPane() {
        this.init();
    }

    private void init() {
        this.actions = new ActionFactory(this);
        JLabel lblAll = CWLabel.createJLabel(BDMsg.gettext("All Verses", new Object[0]));
        JLabel lblSel = CWLabel.createJLabel(BDMsg.gettext("Selected Verses", new Object[0]));
        CWAction action = this.actions.addAction("DeleteVerse", BDMsg.gettext("Remove <", new Object[0]));
        action.setTooltip(BDMsg.gettext("Delete verses from the list selected.", new Object[0]));
        JButton deleteButton = new JButton(action);
        action = this.actions.addAction("AddVerse", BDMsg.gettext("Add >", new Object[0]));
        action.setTooltip(BDMsg.gettext("Add verses to list selected.", new Object[0]));
        JButton addButton = new JButton(action);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        this.add((Component)lblAll, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.add(this.createScrolledTree(lblAll), new GridBagConstraints(0, 1, 1, 4, 0.5, 0.0, 10, 1, new Insets(0, 10, 10, 2), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)deleteButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)addButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)lblSel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 5, 5, 10), 0, 0));
        this.add(this.createScrolledList(lblSel), new GridBagConstraints(2, 1, 1, 4, 0.5, 0.0, 10, 1, new Insets(0, 2, 10, 10), 0, 0));
        this.add(this.createMessageLabel(), new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 5, 10), 0, 0));
        this.add(this.createDisplayPanel(), new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        GuiUtil.applyDefaultOrientation(this);
    }

    private Component createScrolledTree(JLabel label) {
        this.treAll = new JTree();
        this.treAll.setModel(new WholeBibleTreeModel());
        this.treAll.setShowsRootHandles(true);
        this.treAll.setRootVisible(false);
        this.treAll.putClientProperty("JTree.lineStyle", "Angled");
        this.treAll.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent ev) {
                PassageSelectionPane.this.treeSelected();
            }
        });
        label.setLabelFor(this.treAll);
        return new CWScrollPane(this.treAll);
    }

    private Component createScrolledList(JLabel label) {
        this.model = new RangeListModel(RestrictionType.CHAPTER);
        this.lstSel = new JList(this.model);
        this.lstSel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                PassageSelectionPane.this.listSelected();
            }
        });
        label.setLabelFor(this.lstSel);
        return new CWScrollPane(this.lstSel);
    }

    private Component createDisplayPanel() {
        this.txtDisplay = new JTextField();
        this.txtDisplay.getDocument().addDocumentListener(new CustomDocumentEvent());
        JLabel lblDisplay = CWLabel.createJLabel(BDMsg.gettext("Verses", new Object[0]));
        lblDisplay.setLabelFor(this.txtDisplay);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.txtDisplay, "Center");
        panel.add((Component)lblDisplay, "Before");
        return panel;
    }

    private Component createMessageLabel() {
        this.lblMessage = new JLabel();
        return this.lblMessage;
    }

    protected void copyListToText() {
        if (this.changing) {
            return;
        }
        this.changing = true;
        this.txtDisplay.setText(this.ref.getName());
        this.updateMessageSummary();
        this.changing = false;
    }

    protected void copyTextToList() {
        if (this.changing) {
            return;
        }
        this.changing = true;
        String refstr = this.txtDisplay.getText();
        try {
            Versification v11n = Versifications.instance().getVersification("KJV");
            Passage temp = this.keyf.getKey(v11n, refstr);
            this.ref.clear();
            this.ref.addAll((Key)temp);
            this.model.setPassage(this.ref);
            this.setValidPassage(true);
            this.updateMessageSummary();
        }
        catch (NoSuchKeyException ex) {
            this.setValidPassage(false);
            this.updateMessage(ex);
        }
        this.changing = false;
    }

    private void setValidPassage(boolean valid) {
        this.lstSel.setEnabled(valid);
        this.treAll.setEnabled(valid);
        this.actions.findAction("AddVerse").setEnabled(valid);
        this.actions.findAction("DeleteVerse").setEnabled(valid);
    }

    private void updateMessage(NoSuchKeyException ex) {
        this.lblMessage.setText(BDMsg.gettext("Error: {0}", ex.getMessage()));
        this.lblMessage.setIcon(this.icoBad);
    }

    private void updateMessageSummary() {
        this.lblMessage.setText(BDMsg.gettext("Summary: {0}", this.ref.getOverview()));
        this.lblMessage.setIcon(this.icoGood);
    }

    public String showInDialog(Component parent, String title, boolean modal, String refstr) {
        try {
            Versification v11n = Versifications.instance().getVersification("KJV");
            this.ref = this.keyf.getKey(v11n, refstr);
            this.txtDisplay.setText(refstr);
            this.ref.addPassageListener((PassageListener)new CustomPassageListener());
            this.updateMessageSummary();
        }
        catch (NoSuchKeyException ex) {
            this.setValidPassage(false);
            this.updateMessage(ex);
        }
        this.treeSelected();
        this.listSelected();
        Frame root = JOptionPane.getFrameForComponent(parent);
        this.dlgMain = new JDialog(root);
        JPanel pnlAction = new JPanel();
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        this.bailout = true;
        CWAction action = this.actions.addAction("Done", BDMsg.gettext("OK", new Object[0]));
        action.setTooltip(BDMsg.gettext("Close this window.", new Object[0]));
        JButton btnGo = new JButton(action);
        pnlAction.setLayout(new BorderLayout());
        pnlAction.setBorder(BorderFactory.createEmptyBorder(5, 5, 15, 20));
        pnlAction.add((Component)btnGo, "After");
        ActionListener closer = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PassageSelectionPane.this.dlgMain.dispose();
            }
        };
        this.dlgMain.getContentPane().setLayout(new BorderLayout());
        this.dlgMain.getContentPane().add((Component)this, "Center");
        this.dlgMain.getContentPane().add((Component)pnlAction, "South");
        this.dlgMain.getRootPane().setDefaultButton(btnGo);
        this.dlgMain.getRootPane().registerKeyboardAction(closer, esc, 2);
        this.dlgMain.setDefaultCloseOperation(2);
        this.dlgMain.setTitle(title);
        this.dlgMain.setModal(modal);
        GuiUtil.applyDefaultOrientation(this.dlgMain);
        GuiUtil.restrainedPack(this.dlgMain, 0.5f, 0.75f);
        GuiUtil.centerOnScreen(this.dlgMain);
        this.dlgMain.setVisible(true);
        if (this.bailout) {
            return null;
        }
        return this.txtDisplay.getText();
    }

    public void doAddVerse() {
        TreePath[] selected = this.treAll.getSelectionPaths();
        if (selected != null) {
            for (int i = 0; i < selected.length; ++i) {
                WholeBibleTreeNode node = (WholeBibleTreeNode)selected[i].getLastPathComponent();
                VerseRange range = node.getVerseRange();
                this.ref.add((Key)range);
            }
            this.model.setPassage(this.ref);
        }
    }

    public void doDeleteVerse() {
        Object[] selected = this.lstSel.getSelectedValues();
        if (selected != null) {
            for (int i = 0; i < selected.length; ++i) {
                VerseRange range = (VerseRange)selected[i];
                this.ref.remove((Key)range);
            }
            this.model.setPassage(this.ref);
        }
    }

    public void doDone() {
        this.bailout = false;
        this.dlgMain.dispose();
    }

    final void treeSelected() {
        TreePath[] selected = this.treAll.getSelectionPaths();
        this.actions.findAction("AddVerse").setEnabled(selected != null && selected.length > 0);
    }

    final void listSelected() {
        Object[] selected = this.lstSel.getSelectedValues();
        this.actions.findAction("DeleteVerse").setEnabled(selected != null && selected.length > 0);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.icoGood = GuiUtil.getIcon(GOOD_ICON);
        this.icoBad = GuiUtil.getIcon(BAD_ICON);
        this.keyf = PassageKeyFactory.instance();
        this.actions = new ActionFactory(this);
        is.defaultReadObject();
    }

    class CustomPassageListener
    implements PassageListener {
        CustomPassageListener() {
        }

        public void versesAdded(PassageEvent ev) {
            PassageSelectionPane.this.copyListToText();
        }

        public void versesRemoved(PassageEvent ev) {
            PassageSelectionPane.this.copyListToText();
        }

        public void versesChanged(PassageEvent ev) {
            PassageSelectionPane.this.copyListToText();
        }
    }

    class CustomDocumentEvent
    implements DocumentListener {
        CustomDocumentEvent() {
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            PassageSelectionPane.this.copyTextToList();
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            PassageSelectionPane.this.copyTextToList();
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
            PassageSelectionPane.this.copyTextToList();
        }
    }
}

