/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.swing.ButtonPane;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.config.swing.FieldMap;
import org.crosswire.common.config.swing.TreeConfigEditor;
import org.crosswire.common.swing.CWScrollPane;

public class AdvancedConfigEditor
extends TreeConfigEditor {
    protected Map<String, Component> comps;
    private static final long serialVersionUID = 3616451198199345203L;

    protected AdvancedConfigEditor() {
        this.ctm = new AdvancedConfigureTreeModel();
        this.tree = new JTree();
        CWScrollPane scroll = new CWScrollPane(this.tree);
        scroll.setPreferredSize(new Dimension(150, 150));
        CustomTreeCellRenderer render = new CustomTreeCellRenderer();
        this.comps = new HashMap<String, Component>();
        Color orig = UIManager.getColor("control");
        Color bg = new Color(orig.getRed(), orig.getGreen(), orig.getBlue());
        render.setLeafIcon(TASK_ICON_SMALL);
        render.setBackgroundNonSelectionColor(bg);
        this.tree.setBackground(bg);
        this.tree.setModel(this.ctm);
        this.tree.setCellRenderer(render);
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(false);
        this.tree.putClientProperty("JTree.lineStyle", "None");
        this.tree.setSelectionRow(0);
        this.tree.setEditable(true);
        this.setLayout(new BorderLayout(5, 10));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add("Center", scroll);
        this.add("South", new ButtonPane(this));
    }

    @Override
    protected void updateTree() {
        this.ctm.fireTreeStructureChanged(this);
    }

    @Override
    protected void addChoice(Choice model) {
        String key = model.getKey();
        Field field = FieldMap.getField(model);
        this.fields.put(key, field);
        JComponent comp = field.getComponent();
        comp.setToolTipText(model.getHelpText());
        this.comps.put(key, comp);
        String value = this.config.getLocal(key);
        field.setValue(value);
    }

    @Override
    protected void removeChoice(Choice choice) {
        Component comp;
        String key = choice.getKey();
        Field field = (Field)this.fields.get(key);
        if (field != null) {
            this.fields.remove(key);
        }
        if ((comp = this.comps.get(key)) != null) {
            this.comps.remove(key);
        }
    }

    @Override
    public void selectCard() {
        Object obj = this.tree.getLastSelectedPathComponent();
        if (obj == null) {
            return;
        }
        this.title.setText(BDMsg.gettext("{0} Preferences", obj));
        Object[] list = this.tree.getSelectionPath().getPath();
        StringBuilder path = new StringBuilder();
        for (int i = 1; i < list.length; ++i) {
            if (i > 1) {
                path.append('.');
            }
            path.append(list[i].toString());
        }
        String key = path.toString();
        if (this.decks.containsKey(key)) {
            this.layout.show(this.deck, key);
        } else {
            this.layout.show(this.deck, "$$BLANK$$");
        }
        this.deck.repaint();
    }

    class CustomTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3256720688860576049L;

        CustomTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jtree, Object value, boolean isselected, boolean expanded, boolean leaf, int row, boolean focus) {
            if (!(value instanceof CompNode)) {
                return super.getTreeCellRendererComponent(jtree, value, isselected, expanded, leaf, row, focus);
            }
            JComponent comp = (JComponent)AdvancedConfigEditor.this.comps.get(value.toString());
            if (comp == null) {
                return super.getTreeCellRendererComponent(jtree, value, isselected, expanded, leaf, row, focus);
            }
            if (isselected) {
                comp.setBorder(BorderFactory.createLineBorder(Color.black));
            } else {
                comp.setBorder(BorderFactory.createEmptyBorder());
            }
            return comp;
        }
    }

    static class CompNode {
        private String path;

        public CompNode(String path) {
            this.path = path;
        }

        public String toString() {
            return this.path;
        }

        public String getFullName() {
            return this.path;
        }
    }

    class AdvancedConfigureTreeModel
    extends TreeConfigEditor.ConfigureTreeModel {
        AdvancedConfigureTreeModel() {
            super(AdvancedConfigEditor.this);
        }

        @Override
        protected List<String> getChildren(String path) {
            ArrayList<String> retcode = new ArrayList<String>();
            for (Choice choice : AdvancedConfigEditor.this.config) {
                int dotPos;
                String temp;
                if (choice.isHidden() || !(temp = choice.getKey()).startsWith(path) || temp.equals(path)) continue;
                if ((temp = temp.substring(path.length())).charAt(0) == '.') {
                    temp = temp.substring(1);
                }
                if ((dotPos = temp.indexOf(46)) != -1) {
                    temp = temp.substring(0, dotPos);
                }
                if (temp.length() <= 0 || retcode.contains(temp)) continue;
                retcode.add(temp);
            }
            return retcode;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof CompNode) {
                return null;
            }
            String path = ((TreeConfigEditor.Node)parent).getFullName();
            List<String> children = this.getChildren(path);
            if (children.isEmpty()) {
                return new CompNode(path);
            }
            String name = children.get(index);
            return new TreeConfigEditor.Node(path, name);
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof CompNode) {
                return 0;
            }
            String path = ((TreeConfigEditor.Node)parent).getFullName();
            int children = this.getChildren(path).size();
            if (children == 0) {
                children = 1;
            }
            return children;
        }

        @Override
        public boolean isLeaf(Object node) {
            return node instanceof CompNode;
        }
    }
}

