/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.Config;
import org.crosswire.common.config.swing.AbstractConfigEditor;
import org.crosswire.common.config.swing.ButtonPane;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.common.swing.FormPane;
import org.crosswire.common.swing.GuiUtil;

public class TreeConfigEditor
extends AbstractConfigEditor {
    protected static final String BLANK = "$$BLANK$$";
    protected JTree tree;
    protected transient ConfigureTreeModel ctm;
    protected JLabel title;
    protected JPanel deck;
    protected CardLayout layout;
    private static final long serialVersionUID = 3256720688860576049L;

    protected void initializeGUI() {
        JPanel panel = new JPanel();
        JPanel blank = new JPanel();
        DefaultTreeCellRenderer dtcr = new DefaultTreeCellRenderer();
        dtcr.setPreferredSize(new Dimension(1200, 100));
        this.ctm = new ConfigureTreeModel();
        this.tree = new JTree();
        this.title = new JLabel();
        this.deck = new JPanel();
        this.layout = new CardLayout();
        blank.add(new JLabel(BDMsg.gettext("Select a preference category", new Object[0])));
        this.deck.setLayout(this.layout);
        this.deck.add((Component)blank, BLANK);
        dtcr.setLeafIcon(TASK_ICON_SMALL);
        this.tree.setModel(this.ctm);
        this.tree.setCellRenderer(dtcr);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.tree.putClientProperty("JTree.lineStyle", "None");
        this.tree.setSelectionRow(0);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent ev) {
                TreeConfigEditor.this.selectCard();
            }
        });
        this.title.setIcon(TASK_ICON_LARGE);
        this.title.setFont(this.getFont().deriveFont(0, 16.0f));
        this.title.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.title.setBackground(Color.gray);
        this.title.setForeground(Color.white);
        this.title.setOpaque(true);
        this.title.setText(BDMsg.gettext("Preferences", new Object[0]));
        this.title.setAlignmentX(10.0f);
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.add("North", this.title);
        panel.add("Center", this.deck);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        FixedSplitPane sptMain = new FixedSplitPane();
        sptMain.setOrientation(1);
        ((JSplitPane)sptMain).setDividerLocation(0.25);
        sptMain.setResizeWeight(0.25);
        ((JSplitPane)sptMain).setLeftComponent(new CWScrollPane(this.tree));
        ((JSplitPane)sptMain).setRightComponent(panel);
        this.add("Center", sptMain);
        this.add("South", new ButtonPane(this));
        GuiUtil.applyDefaultOrientation(this);
    }

    protected void updateTree() {
        int row = 0;
        while (row < this.tree.getRowCount()) {
            this.tree.expandRow(row++);
        }
        this.ctm.fireTreeStructureChanged(this);
    }

    protected void addChoice(Choice model) {
        if (model.isHidden()) {
            return;
        }
        super.addChoice(model);
        String path = Config.getPath((String)model.getFullPath());
        FormPane card = (FormPane)this.decks.get(path);
        if (card != null && card.getParent() == null) {
            CWScrollPane scroll = new CWScrollPane(card);
            scroll.setBorder(BorderFactory.createEmptyBorder());
            this.deck.add((Component)scroll, path);
        }
    }

    protected void removeChoice(Choice model) {
        super.removeChoice(model);
        String path = Config.getPath((String)model.getFullPath());
        FormPane card = (FormPane)this.decks.get(path);
        if (card != null && card.isEmpty()) {
            this.deck.remove(card.getParent());
        }
    }

    public void selectCard() {
        Object obj = this.tree.getLastSelectedPathComponent();
        if (obj == null) {
            return;
        }
        this.title.setText(BDMsg.gettext("{0} Preferences", obj));
        Object[] list = this.tree.getSelectionPath().getPath();
        StringBuilder path = new StringBuilder();
        for (int i = 1; i < list.length; ++i) {
            if (i > 1) {
                path.append('.');
            }
            path.append(list[i].toString());
        }
        String key = path.toString();
        GuiUtil.applyDefaultOrientation(this.deck);
        if (this.decks.containsKey(key)) {
            this.layout.show(this.deck, key);
        } else {
            this.layout.show(this.deck, BLANK);
        }
        this.deck.repaint();
    }

    protected static class Node {
        private String name;
        private String path;

        protected Node(String path, String name) {
            this.path = path;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getFullName() {
            if (this.path.length() == 0 || this.name.length() == 0) {
                return this.path + this.name;
            }
            return this.path + "." + this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConfigureTreeModel
    implements TreeModel {
        protected EventListenerList listeners = new EventListenerList();
        private Node root = new Node("", "");

        protected ConfigureTreeModel() {
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        protected List<String> getChildren(String path) {
            ArrayList<String> retcode = new ArrayList<String>();
            for (Choice choice : TreeConfigEditor.this.config) {
                int dotPos;
                String temp;
                if (choice.isHidden() || !(temp = choice.getFullPath()).startsWith(path) || temp.equals(path)) continue;
                if ((temp = temp.substring(path.length())).charAt(0) == '.') {
                    temp = temp.substring(1);
                }
                if ((dotPos = temp.indexOf(46)) == -1 || (temp = temp.substring(0, dotPos)).length() <= 0 || retcode.contains(temp)) continue;
                retcode.add(temp);
            }
            return retcode;
        }

        @Override
        public Object getChild(Object parent, int index) {
            String path = ((Node)parent).getFullName();
            String name = this.getChildren(path).get(index);
            return new Node(path, name);
        }

        @Override
        public int getChildCount(Object parent) {
            String path = ((Node)parent).getFullName();
            return this.getChildren(path).size();
        }

        @Override
        public boolean isLeaf(Object node) {
            String path = ((Node)node).getFullName();
            return this.getChildren(path).size() == 0;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object value) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            String path = ((Node)parent).getFullName();
            List<String> children = this.getChildren(path);
            return children.indexOf(child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener li) {
            this.listeners.add(TreeModelListener.class, li);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener li) {
            this.listeners.remove(TreeModelListener.class, li);
        }

        protected void fireTreeStructureChanged(Object source) {
            this.fireTreeStructureChanged(source, this.root);
        }

        protected void fireTreeStructureChanged(Object source, Object ... path) {
            Object[] array = this.listeners.getListenerList();
            TreeModelEvent ev = null;
            for (int i = array.length - 2; i >= 0; i -= 2) {
                if (array[i] != TreeModelListener.class) continue;
                if (ev == null) {
                    ev = new TreeModelEvent(source, path);
                }
                ((TreeModelListener)array[i + 1]).treeStructureChanged(ev);
            }
        }
    }
}

