/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.Font;
import java.io.IOException;
import java.net.URI;
import org.crosswire.common.swing.GuiConvert;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.PropertyMap;
import org.crosswire.common.util.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontStore {
    protected static final String DEFAULT_FONT = "Dialog-PLAIN-12";
    protected static final String LANG_KEY_PREFIX = "lang.";
    protected static final String DEFAULT_KEY = "default";
    private String storeName;
    private String defaultFont;
    private URI fontStore;
    private boolean loaded;
    private PropertyMap fontMap;
    private static final Logger log = LoggerFactory.getLogger(FontStore.class);

    public FontStore(String storeName, URI fontDir) {
        if (fontDir == null) {
            throw new IllegalArgumentException("fontStore cannot be null");
        }
        this.storeName = storeName;
        this.fontStore = NetUtil.lengthenURI((URI)fontDir, (String)(this.storeName + ".properties"));
        this.fontMap = new PropertyMap();
    }

    public String getDefaultFont() {
        this.load();
        this.defaultFont = this.fontMap.get(DEFAULT_KEY, DEFAULT_FONT);
        return this.defaultFont;
    }

    public void setDefaultFont(String defaultFont) {
        this.load();
        this.defaultFont = defaultFont;
        this.fontMap.put((Object)DEFAULT_KEY, (Object)defaultFont);
        this.store();
    }

    public void setFont(String resource, Font font) {
        if (resource == null || font == null) {
            return;
        }
        this.load();
        this.fontMap.put((Object)resource, (Object)GuiConvert.font2String(font));
        this.store();
    }

    public void setFont(Language lang, Font font) {
        if (lang == null || font == null) {
            return;
        }
        this.load();
        this.fontMap.put((Object)(LANG_KEY_PREFIX + lang.getCode()), (Object)GuiConvert.font2String(font));
        this.store();
    }

    public void resetFont(String key) {
        this.load();
        this.fontMap.remove((Object)key);
        this.store();
    }

    public Font getFont(String resource, Language lang, String fallback) {
        Font obtainedFont;
        this.load();
        String fontSpec = null;
        if (resource != null) {
            fontSpec = this.fontMap.get(resource);
        }
        if (fontSpec != null) {
            obtainedFont = this.obtainFont(fontSpec);
            if (obtainedFont != null) {
                return obtainedFont;
            }
            fontSpec = null;
        }
        if (lang != null) {
            fontSpec = this.fontMap.get(LANG_KEY_PREFIX + lang.getCode());
        }
        if (fontSpec != null && (obtainedFont = this.obtainFont(fontSpec)) != null) {
            return obtainedFont;
        }
        fontSpec = fallback;
        if (fontSpec != null && (obtainedFont = this.obtainFont(fontSpec)) != null) {
            return obtainedFont;
        }
        return GuiConvert.string2Font(this.defaultFont);
    }

    protected String getStoreName() {
        return this.storeName;
    }

    protected void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    protected URI getFontStore() {
        return this.fontStore;
    }

    protected void setFontStore(URI fontStore) {
        this.fontStore = fontStore;
    }

    protected boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    protected PropertyMap getFontMap() {
        return this.fontMap;
    }

    protected void setFontMap(PropertyMap fontMap) {
        this.fontMap = fontMap;
    }

    protected void load() {
        if (this.loaded) {
            return;
        }
        try {
            this.fontMap = ResourceUtil.getProperties((String)this.storeName);
            this.loaded = true;
        }
        catch (IOException e) {
            log.error("Unable to load the font store: {}", (Object)this.fontStore);
            this.fontMap = new PropertyMap();
        }
    }

    protected void store() {
        this.load();
        try {
            NetUtil.storeProperties((PropertyMap)this.fontMap, (URI)this.fontStore, (String)this.storeName);
        }
        catch (IOException ex) {
            log.error("Failed to save BibleDesktop UI Translation", (Throwable)ex);
        }
    }

    protected Font obtainFont(String fontSpec) {
        Font obtainedFont;
        String obtainedFontSpec;
        if (fontSpec != null && (obtainedFontSpec = GuiConvert.font2String(obtainedFont = GuiConvert.string2Font(fontSpec))) != null && obtainedFontSpec.equalsIgnoreCase(fontSpec)) {
            return obtainedFont;
        }
        return null;
    }
}

