/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.crosswire.common.util.Filter;
import org.crosswire.jsword.book.Book;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookSet
extends ArrayList<Book>
implements Set<Book> {
    private static final long serialVersionUID = 3258688806185154867L;

    public BookSet() {
    }

    public BookSet(Collection<Book> books) {
        this();
        this.addAll((Collection<? extends Book>)books);
    }

    public Set<String> getGroups() {
        TreeSet<String> results = new TreeSet<String>();
        for (Book book : this) {
            results.addAll(book.getPropertyKeys());
        }
        return results;
    }

    public Set<Object> getGroup(String key) {
        TreeSet<Object> results = new TreeSet<Object>();
        for (Book book : this) {
            String property = book.getProperty(key);
            if (property == null) continue;
            results.add(property);
        }
        return results;
    }

    public BookSet filter(String key, Object value) {
        return this.filter(new GroupFilter(key, value));
    }

    public BookSet filter(Filter<Book> filter) {
        BookSet listSet = (BookSet)this.clone();
        Iterator iter = listSet.iterator();
        while (iter.hasNext()) {
            Book obj = (Book)iter.next();
            if (filter.test(obj)) continue;
            iter.remove();
        }
        return listSet;
    }

    @Override
    public void add(int index, Book element) {
        this.add(element);
    }

    @Override
    public final boolean add(Book book) {
        int pos = Collections.binarySearch(this, book);
        if (pos < 0) {
            super.add(-pos - 1, book);
            return true;
        }
        return false;
    }

    @Override
    public final boolean addAll(Collection<? extends Book> c) {
        boolean added = false;
        for (Book book : c) {
            if (!this.add(book)) continue;
            added = true;
        }
        return added;
    }

    @Override
    public final boolean addAll(int index, Collection<? extends Book> c) {
        return this.addAll(c);
    }

    @Override
    public Book set(int index, Book element) {
        Book item = (Book)this.remove(index);
        this.add(element);
        return item;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GroupFilter
    implements Filter<Book> {
        private String key;
        private Object value;

        GroupFilter(String aKey, Object aValue) {
            this.key = aKey;
            this.value = aValue;
        }

        @Override
        public boolean test(Book book) {
            String property = book.getProperty(this.key);
            return property != null && property.equals(this.value);
        }
    }
}

