/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.crosswire.common.util.Language;
import org.crosswire.common.util.StringUtil;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.BookCategory;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.basic.AbstractBookMetaData;
import org.crosswire.jsword.passage.VerseKey;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBookMetaData
extends AbstractBookMetaData {
    private BookCategory type;
    private String name;
    private String initials;
    private Map<String, String> props = new HashMap<String, String>();
    private static final String DEFAULT_CHARSET = "UTF-8";

    public DefaultBookMetaData(BookDriver driver, String name, BookCategory type) {
        this.setDriver(driver);
        this.setName(name);
        this.setBookCategory(type);
        this.setLanguage(Language.DEFAULT_LANG);
    }

    @Override
    public String getBookCharset() {
        return DEFAULT_CHARSET;
    }

    @Override
    public Set<String> getPropertyKeys() {
        return Collections.unmodifiableSet(this.props.keySet());
    }

    @Override
    public String getProperty(String key) {
        if ("Language".equals(key)) {
            return this.getLanguage().getName();
        }
        return this.props.get(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.props.put(key, value);
    }

    @Override
    public void putProperty(String key, String value) {
        this.setProperty(key, value);
    }

    @Override
    public void putProperty(String key, String value, boolean forFrontend) {
        this.setProperty(key, value);
    }

    @Override
    public BookCategory getBookCategory() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAbbreviation() {
        return this.initials;
    }

    @Override
    public String getInitials() {
        return this.initials;
    }

    @Override
    public boolean isLeftToRight() {
        return this.getLanguage().isLeftToRight();
    }

    public void setInitials(String initials) {
        this.initials = initials == null ? (this.name == null ? "" : StringUtil.getInitials(this.name)) : initials;
    }

    public void setName(String name) {
        this.name = name;
        this.putProperty("Description", this.name);
        this.setInitials(StringUtil.getInitials(name));
    }

    public void setBookCategory(BookCategory aType) {
        BookCategory t = aType;
        if (t == null) {
            t = BookCategory.BIBLE;
        }
        this.type = t;
        this.putProperty("Category", this.type.toString());
    }

    public void setType(String typestr) {
        BookCategory newType = null;
        if (typestr != null) {
            newType = BookCategory.fromString(typestr);
        }
        this.setBookCategory(newType);
    }

    @Override
    public Document toOSIS() {
        OSISUtil.OSISFactory factory = OSISUtil.factory();
        Element ele = factory.createTable();
        this.addRow(factory, ele, "Initials", this.getInitials());
        this.addRow(factory, ele, "Description", this.getName());
        this.addRow(factory, ele, "Key", this.getBookCategory().toString());
        this.addRow(factory, ele, "Language", this.getLanguage().getName());
        return new Document(ele);
    }

    public VerseKey getScope() {
        throw new UnsupportedOperationException();
    }

    private void addRow(OSISUtil.OSISFactory factory, Element table, String key, String value) {
        if (value == null) {
            return;
        }
        Element rowEle = factory.createRow();
        Element nameEle = factory.createCell();
        Element hiEle = factory.createHI();
        hiEle.setAttribute("type", "bold");
        nameEle.addContent((Content)hiEle);
        Element valueElement = factory.createCell();
        rowEle.addContent((Content)nameEle);
        rowEle.addContent((Content)valueElement);
        hiEle.addContent(key);
        String expandedValue = XMLUtil.escape(value);
        valueElement.addContent(expandedValue);
        table.addContent((Content)rowEle);
    }
}

