/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import org.crosswire.common.swing.Actionable;
import org.crosswire.common.swing.CWAction;
import org.crosswire.common.swing.CWLabel;
import org.crosswire.common.util.OSType;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionFactory
implements ActionListener,
Actionable {
    private static final String MISSING_RESOURCE = "Missing Resource";
    private static final String METHOD_PREFIX = "do";
    private Object bean;
    private Map<String, CWAction> actions = new HashMap<String, CWAction>();
    private static final Logger log = LoggerFactory.getLogger(ActionFactory.class);

    public ActionFactory() {
    }

    public ActionFactory(Object bean) {
        this();
        this.bean = bean;
    }

    @Override
    public void actionPerformed(String action) {
        Action act = this.findAction(action);
        act.actionPerformed(new ActionEvent(this, 0, action));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String action = ev.getActionCommand();
        if (action == null || action.length() == 0) {
            log.error("No action available for: {}", (Object)this.bean.getClass().getName());
            return;
        }
        String methodName = METHOD_PREFIX + action;
        Throwable ex = null;
        try {
            try {
                Method doMethod = this.bean.getClass().getDeclaredMethod(methodName, ActionEvent.class);
                doMethod.invoke(this.bean, ev);
            }
            catch (NoSuchMethodException e) {
                Method doMethod = this.bean.getClass().getDeclaredMethod(methodName, new Class[0]);
                doMethod.invoke(this.bean, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e.getCause();
        }
        if (ex != null) {
            log.error("Could not execute method {}.{}()", new Object[]{this.bean.getClass().getName(), methodName, ex});
            Reporter.informUser(this.bean.getClass(), (Throwable)ex);
        }
    }

    public Action findAction(String key) {
        CWAction action = this.actions.get(key);
        if (action == null) {
            log.info("Missing key: '{}'. Known keys are: {}", (Object)key, (Object)StringUtil.join((Object[])this.actions.keySet().toArray(), (String)", "));
            action = new CWAction();
            action.putValue("Name", key);
            action.putValue("ShortDescription", MISSING_RESOURCE);
            action.setEnabled(true);
            action.addActionListener(this);
        }
        return action;
    }

    @Deprecated
    public Action getAction(String key) {
        return this.findAction(key);
    }

    public JButton createJButton(CWAction action, ActionListener listener) {
        CWAction act = action.clone();
        act.addActionListener(listener);
        return new JButton(act);
    }

    public CWAction addAction(String key, String name) {
        CWAction cwAction = this.actions.get(key);
        if (cwAction == null) {
            cwAction = this.buildAction(key, name);
            cwAction.addActionListener(this);
            this.actions.put(key, cwAction);
        }
        return cwAction;
    }

    public CWAction addAction(String key) {
        return this.addAction(key, null);
    }

    private CWAction buildAction(String key, String name) {
        CWAction cwAction;
        if (key == null || key.length() == 0) {
            log.warn("Key is missing for CWAction");
        }
        if ((cwAction = this.actions.get(key)) != null) {
            return cwAction;
        }
        cwAction = new CWAction();
        cwAction.putValue("ActionCommandKey", key);
        if (name != null) {
            JLabel cwLabel = CWLabel.createJLabel(name);
            cwAction.putValue("Name", cwLabel.getText());
            if (!OSType.MAC.equals((Object)OSType.getOSType())) {
                cwAction.putValue("MnemonicKey", cwLabel.getDisplayedMnemonic());
            }
        }
        return cwAction;
    }
}

