/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.basic;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.crosswire.common.util.Language;
import org.crosswire.jsword.book.BookDriver;
import org.crosswire.jsword.book.BookMetaData;
import org.crosswire.jsword.book.FeatureType;
import org.crosswire.jsword.book.KeyType;
import org.crosswire.jsword.book.sword.MissingDataFilesException;
import org.crosswire.jsword.index.IndexStatus;
import org.jdom2.Document;

public abstract class AbstractBookMetaData
implements BookMetaData {
    private Map<String, Object> prop = new LinkedHashMap<String, Object>();
    private BookDriver driver;
    private IndexStatus indexStatus = IndexStatus.UNDONE;

    @Override
    public KeyType getKeyType() {
        return KeyType.LIST;
    }

    @Override
    public BookDriver getDriver() {
        return this.driver;
    }

    @Override
    public String getDriverName() {
        if (this.getDriver() == null) {
            return null;
        }
        return this.getDriver().getDriverName();
    }

    @Override
    public boolean hasFeature(FeatureType feature) {
        return false;
    }

    @Override
    public String getOsisID() {
        return this.getBookCategory().getName() + '.' + this.getInitials();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public boolean isEnciphered() {
        return false;
    }

    @Override
    public boolean isLocked() {
        return false;
    }

    @Override
    public boolean unlock(String unlockKey) {
        return false;
    }

    @Override
    public String getUnlockKey() {
        return null;
    }

    @Override
    public boolean isQuestionable() {
        return false;
    }

    @Override
    public Language getLanguage() {
        return (Language)this.getProperty("Lang");
    }

    public void setLanguage(Language language) {
        this.putProperty("Lang", language);
    }

    @Override
    public URI getLibrary() {
        URI uri = null;
        try {
            String loc = (String)this.getProperty("LibraryURI");
            if (loc != null) {
                uri = new URI(loc);
            }
            return uri;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public void setLibrary(URI library) throws MissingDataFilesException {
        this.putProperty("LibraryURI", library.toString());
    }

    @Override
    public void setLocation(URI location) {
        this.putProperty("LocationURI", location.toString());
    }

    @Override
    public URI getLocation() {
        URI uri = null;
        try {
            String loc = (String)this.getProperty("LocationURI");
            if (loc != null) {
                uri = new URI(loc);
            }
            return uri;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.prop);
    }

    public void setProperties(Map<String, Object> newProperties) {
        this.prop = newProperties;
    }

    @Override
    public Object getProperty(String key) {
        return this.prop.get(key);
    }

    @Override
    public void putProperty(String key, Object value) {
        this.prop.put(key, value);
    }

    @Override
    public IndexStatus getIndexStatus() {
        return this.indexStatus;
    }

    @Override
    public void setIndexStatus(IndexStatus newValue) {
        this.indexStatus = newValue;
        this.prop.put("IndexStatus", newValue.toString());
    }

    @Override
    public Document toOSIS() {
        throw new UnsupportedOperationException("If you want to use this, implement it.");
    }

    public void setDriver(BookDriver driver) {
        this.driver = driver;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        BookMetaData that = (BookMetaData)obj;
        return this.getBookCategory().equals((Object)that.getBookCategory()) && this.getName().equals(that.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public int compareTo(BookMetaData obj) {
        int result = this.getBookCategory().compareTo(obj.getBookCategory());
        if (result == 0) {
            result = this.getName().compareTo(obj.getName());
        }
        return result;
    }

    public String toString() {
        return this.getInitials();
    }
}

