/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book.filter.osis;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.DataPolice;
import org.crosswire.jsword.book.OSISUtil;
import org.crosswire.jsword.book.filter.Filter;
import org.crosswire.jsword.passage.Key;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class OSISFilter
implements Filter {
    private BlockingQueue<SAXBuilder> saxBuilders = new ArrayBlockingQueue<SAXBuilder>(32);
    private static final Logger log = LoggerFactory.getLogger(OSISFilter.class);

    @Override
    public List<Content> toOSIS(Book book, Key key, String plain) {
        Element ele = null;
        Throwable ex = null;
        String clean = plain;
        if (book.getInitials().startsWith("NET") && plain.endsWith("</div>")) {
            clean = clean.substring(0, plain.length() - 6);
        }
        try {
            ele = this.parse(clean);
        }
        catch (JDOMException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        if (ele == null) {
            clean = XMLUtil.cleanAllEntities(clean);
            try {
                ele = this.parse(clean);
            }
            catch (JDOMException e) {
                ex = e;
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            DataPolice.report(book, key, "Parse " + book.getInitials() + "(" + key.getName() + ") failed: " + ex.getMessage() + "\non: " + plain);
            ele = this.cleanTags(book, key, clean);
        }
        if (ele == null) {
            ele = OSISUtil.factory().createP();
        }
        return ele.removeContent();
    }

    @Override
    public OSISFilter clone() {
        OSISFilter clone;
        block2: {
            clone = null;
            try {
                clone = (OSISFilter)super.clone();
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e);
            }
        }
        return clone;
    }

    private Element cleanTags(Book book, Key key, String plain) {
        String shawn = XMLUtil.cleanAllTags(plain);
        Throwable ex = null;
        try {
            return this.parse(shawn);
        }
        catch (JDOMException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        log.warn("Could not fix {}({}) by cleaning tags: {}", new Object[]{book.getInitials(), key.getName(), ex.getMessage()});
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element parse(String plain) throws JDOMException, IOException {
        Element div;
        SAXBuilder builder = (SAXBuilder)this.saxBuilders.poll();
        if (builder == null) {
            builder = new SAXBuilder();
        }
        StringReader in = null;
        try {
            in = new StringReader("<div>" + plain + "</div>");
            InputSource is = new InputSource(in);
            Document doc = builder.build(is);
            div = doc.getRootElement();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        this.saxBuilders.offer(builder);
        return div;
    }
}

