/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.ConfigException;
import org.crosswire.common.config.StartupException;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.JSOtherMsg;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReflectedChoice
implements Choice {
    private String key;
    private Class<? extends Object> clazz;
    private String propertyname;
    private String type;
    private Method getter;
    private Method setter;
    private String helptext;
    private String fullPath;
    private boolean hidden;
    private boolean ignored;
    private boolean external;
    private boolean restart;
    private static final Logger log = LoggerFactory.getLogger(AbstractReflectedChoice.class);

    public void init(Element option, ResourceBundle configResources) throws StartupException {
        assert (configResources != null);
        this.key = option.getAttributeValue("key");
        try {
            String hiddenState = configResources.getString(this.key + ".hidden");
            this.hidden = Boolean.valueOf(hiddenState);
        }
        catch (MissingResourceException e) {
            this.hidden = false;
        }
        try {
            String ignoreState = configResources.getString(this.key + ".ignore");
            this.ignored = Boolean.valueOf(ignoreState);
            if (this.ignored) {
                this.hidden = true;
                return;
            }
        }
        catch (MissingResourceException e) {
            this.ignored = false;
        }
        String helpText = configResources.getString(this.key + ".help");
        assert (helpText != null);
        this.setHelpText(helpText);
        String[] pathParts = StringUtil.split(this.key, '.');
        StringBuilder parentKey = new StringBuilder();
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < pathParts.length; ++i) {
            if (i > 0) {
                parentKey.append('.');
                path.append('.');
            }
            parentKey.append(pathParts[i]);
            String parent = configResources.getString(parentKey + ".name");
            assert (parent != null);
            path.append(parent);
        }
        this.setFullPath(path.toString());
        this.external = Boolean.valueOf(option.getAttributeValue("external"));
        this.restart = Boolean.valueOf(option.getAttributeValue("restart"));
        this.type = option.getAttributeValue("type");
        Element introspector = option.getChild("introspect");
        if (introspector == null) {
            throw new StartupException(JSOtherMsg.lookupText("Missing {0} element in config.xml", "introspect"));
        }
        String clazzname = introspector.getAttributeValue("class");
        if (clazzname == null) {
            throw new StartupException(JSOtherMsg.lookupText("Missing {0} element in config.xml", "class"));
        }
        this.propertyname = introspector.getAttributeValue("property");
        if (this.propertyname == null) {
            throw new StartupException(JSOtherMsg.lookupText("Missing {0} element in config.xml", "property"));
        }
        try {
            this.clazz = ClassUtil.forName(clazzname);
        }
        catch (ClassNotFoundException ex) {
            throw new StartupException(JSOtherMsg.lookupText("Specified class not found: {0}", clazzname), ex);
        }
        try {
            this.setter = this.clazz.getMethod("set" + this.propertyname, this.getConversionClass());
        }
        catch (NoSuchMethodException ex) {
            throw new StartupException(JSOtherMsg.lookupText("Specified method not found {0}.set{1}({2} arg0)", this.clazz.getName(), this.propertyname, this.getConversionClass().getName()), ex);
        }
        try {
            try {
                this.getter = this.clazz.getMethod("is" + this.propertyname, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                this.getter = this.clazz.getMethod("get" + this.propertyname, new Class[0]);
            }
        }
        catch (NoSuchMethodException ex) {
            throw new StartupException(JSOtherMsg.lookupText("Specified method not found {0}.get{1}()", this.clazz.getName(), this.propertyname), ex);
        }
        if (this.getter.getReturnType() != this.getConversionClass()) {
            log.debug("Not using {} from {} because the return type of the getter is not {}", new Object[]{this.propertyname, this.clazz.getName(), this.getConversionClass().getName()});
            throw new StartupException(JSOtherMsg.lookupText("Mismatch of return types, found: {0} required: {1}", this.getter.getReturnType(), this.getConversionClass()));
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getType() {
        return this.type;
    }

    public abstract String convertToString(Object var1);

    public abstract Object convertToObject(String var1);

    public String getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(String newFullPath) {
        this.fullPath = newFullPath;
    }

    public String getHelpText() {
        return this.helptext;
    }

    public void setHelpText(String helptext) {
        this.helptext = helptext;
    }

    public boolean isSaveable() {
        return !this.external;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public boolean requiresRestart() {
        return this.restart;
    }

    public String getString() {
        try {
            Object retval = this.getter.invoke(null, new Object[0]);
            return this.convertToString(retval);
        }
        catch (IllegalAccessException ex) {
            log.error("Illegal access getting value from {}.{}", new Object[]{this.clazz.getName(), this.getter.getName(), ex});
            return "";
        }
        catch (InvocationTargetException ex) {
            log.error("Failed to get value from {}.{}", new Object[]{this.clazz.getName(), this.getter.getName(), ex});
            return "";
        }
    }

    public void setString(String value) throws ConfigException {
        Exception ex = null;
        try {
            Object object = this.convertToObject(value);
            if (object != null) {
                this.setter.invoke(null, object);
            }
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (NullPointerException e) {
            ex = e;
        }
        if (ex != null) {
            log.info("Exception while attempting to execute: {}", (Object)this.setter.toString());
            throw new ConfigException(JSOtherMsg.lookupText("Failed to set option: {0}", this.setter), ex);
        }
    }
}

