/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Enumeration;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.crosswire.common.util.NetUtil;
import org.crosswire.common.util.StringUtil;
import org.crosswire.jsword.JSMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtil {
    private static final Logger log = LoggerFactory.getLogger(IOUtil.class);

    private IOUtil() {
    }

    public static void unpackZip(File file, File destdir) throws IOException {
        IOUtil.unpackZip(file, destdir, true, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpackZip(File file, File destdir, boolean include, String ... includeExcludes) throws IOException {
        byte[] dbuf = new byte[4096];
        ZipFile zf = null;
        try {
            zf = new ZipFile(file);
            Enumeration entries = zf.getEntries();
            while (entries.hasMoreElements()) {
                int count;
                File entryFile;
                File parentDir;
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String entrypath = entry.getName();
                if (includeExcludes != null && includeExcludes.length > 0) {
                    boolean skip = include;
                    for (String filter : includeExcludes) {
                        boolean matchesPath = entrypath.toLowerCase().startsWith(filter);
                        if (include && matchesPath) {
                            skip = false;
                        }
                        if (include || !matchesPath) continue;
                        skip = true;
                    }
                    if (skip) continue;
                }
                if (!(parentDir = (entryFile = new File(destdir, entrypath)).getParentFile()).isDirectory() && !parentDir.mkdirs()) {
                    throw new MalformedURLException(JSMsg.gettext("The URL {0} could not be created as a directory.", parentDir.toString()));
                }
                if (entry.isDirectory()) continue;
                URI child = NetUtil.getURI(entryFile);
                OutputStream dataOut = NetUtil.getOutputStream(child);
                InputStream dataIn = zf.getInputStream(entry);
                while ((count = dataIn.read(dbuf)) != -1) {
                    dataOut.write(dbuf, 0, count);
                }
                dataOut.close();
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(zf);
            throw throwable;
        }
        IOUtil.close((Closeable)zf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getZipEntry(String entrySpec) throws IOException {
        byte[] buffer = new byte[]{};
        String[] parts = StringUtil.split(entrySpec, '!');
        ZipFile zipFile = null;
        InputStream zin = null;
        try {
            int offset;
            zipFile = new ZipFile(parts[0]);
            ZipArchiveEntry entry = zipFile.getEntry(parts[1]);
            zin = zipFile.getInputStream(entry);
            int size = (int)entry.getSize();
            buffer = new byte[size];
            for (offset = 0; offset < size; offset += zin.read(buffer, offset, size - offset)) {
            }
            if (offset != size) {
                log.error("Error: Could not read {} bytes, instead {}, for {} from {}", new Object[]{Integer.toString(size), Integer.toString(offset), parts[1], parts[0]});
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(zin);
            IOUtil.close(zipFile);
            throw throwable;
        }
        IOUtil.close(zin);
        IOUtil.close((Closeable)zipFile);
        return buffer;
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                log.error("close", (Throwable)ex);
            }
        }
    }
}

