/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.book;

import java.io.File;
import java.net.URI;
import org.crosswire.common.util.CWProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MetaDataLocator {
    TRANSIENT{

        public File getReadLocation() {
            return null;
        }

        public File getWriteLocation() {
            return null;
        }
    }
    ,
    JSWORD{

        public File getReadLocation() {
            URI[] dirs = CWProject.instance().getProjectResourceDirs();
            if (dirs.length > 1) {
                return 2.getFile(dirs[1]);
            }
            return null;
        }

        public File getWriteLocation() {
            URI[] dirs = CWProject.instance().getProjectResourceDirs();
            if (dirs.length > 0) {
                return 2.getFile(dirs[0]);
            }
            return null;
        }
    }
    ,
    FRONTEND{

        public File getReadLocation() {
            return 3.getFile(CWProject.instance().getReadableFrontendProjectDir());
        }

        public File getWriteLocation() {
            return 3.getFile(CWProject.instance().getWritableFrontendProjectDir());
        }
    };

    private static final String DIR_CONF_OVERRIDE = "jsword-mods.d";

    protected static File getFile(URI u) {
        if (u == null) {
            return null;
        }
        File parent = new File(u);
        File override = new File(parent, DIR_CONF_OVERRIDE);
        override.mkdirs();
        return override;
    }

    public abstract File getReadLocation();

    public abstract File getWriteLocation();
}

