/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.jsword.versification;

import org.crosswire.jsword.JSMsg;
import org.crosswire.jsword.versification.BibleBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DivisionName {
    BIBLE{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.GEN.ordinal() && bookNum <= BibleBook.REV.ordinal();
        }

        public int getSize() {
            return 66;
        }

        public String getName() {
            return JSMsg.gettext("The Whole Bible", new Object[0]);
        }

        public String getRange() {
            return "Gen-Rev";
        }
    }
    ,
    OLD_TESTAMENT{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.GEN.ordinal() && bookNum <= BibleBook.MAL.ordinal();
        }

        public int getSize() {
            return 39;
        }

        public String getName() {
            return JSMsg.gettext("Old Testament", new Object[0]);
        }

        public String getRange() {
            return "Gen-Mal";
        }
    }
    ,
    PENTATEUCH{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.GEN.ordinal() && bookNum <= BibleBook.DEUT.ordinal();
        }

        public int getSize() {
            return 5;
        }

        public String getName() {
            return JSMsg.gettext("Pentateuch", new Object[0]);
        }

        public String getRange() {
            return "Gen-Deu";
        }
    }
    ,
    HISTORY{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.JOSH.ordinal() && bookNum <= BibleBook.ESTH.ordinal();
        }

        public int getSize() {
            return 12;
        }

        public String getName() {
            return JSMsg.gettext("History", new Object[0]);
        }

        public String getRange() {
            return "Jos-Est";
        }
    }
    ,
    POETRY{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.JOB.ordinal() && bookNum <= BibleBook.SONG.ordinal();
        }

        public int getSize() {
            return 5;
        }

        public String getName() {
            return JSMsg.gettext("Poetry", new Object[0]);
        }

        public String getRange() {
            return "Job-Song";
        }
    }
    ,
    PROPHECY{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum == BibleBook.REV.ordinal() || bookNum >= BibleBook.ISA.ordinal() && bookNum <= BibleBook.MAL.ordinal();
        }

        public int getSize() {
            return 18;
        }

        public String getName() {
            return JSMsg.gettext("All Prophecy", new Object[0]);
        }

        public String getRange() {
            return "Deu 28,Isa-Mal,Rev";
        }
    }
    ,
    MAJOR_PROPHETS{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.ISA.ordinal() && bookNum <= BibleBook.DAN.ordinal();
        }

        public int getSize() {
            return 5;
        }

        public String getName() {
            return JSMsg.gettext("Major Prophets", new Object[0]);
        }

        public String getRange() {
            return "Isa-Dan";
        }
    }
    ,
    MINOR_PROPHETS{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.HOS.ordinal() && bookNum <= BibleBook.MAL.ordinal();
        }

        public int getSize() {
            return 12;
        }

        public String getName() {
            return JSMsg.gettext("Minor Prophets", new Object[0]);
        }

        public String getRange() {
            return "Hos-Mal";
        }
    }
    ,
    NEW_TESTAMENT{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.MATT.ordinal() && bookNum <= BibleBook.REV.ordinal();
        }

        public int getSize() {
            return 27;
        }

        public String getName() {
            return JSMsg.gettext("New Testament", new Object[0]);
        }

        public String getRange() {
            return "Mat-Rev";
        }
    }
    ,
    GOSPELS_AND_ACTS{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.MATT.ordinal() && bookNum <= BibleBook.ACTS.ordinal();
        }

        public int getSize() {
            return 5;
        }

        public String getName() {
            return JSMsg.gettext("Gospels and Acts", new Object[0]);
        }

        public String getRange() {
            return "Mat-Acts";
        }
    }
    ,
    LETTERS{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.ROM.ordinal() && bookNum <= BibleBook.JUDE.ordinal();
        }

        public int getSize() {
            return 21;
        }

        public String getName() {
            return JSMsg.gettext("Letters", new Object[0]);
        }

        public String getRange() {
            return "Rom-Jud";
        }
    }
    ,
    PAULINE_LETTERS{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.ROM.ordinal() && bookNum <= BibleBook.JUDE.ordinal();
        }

        public int getSize() {
            return 14;
        }

        public String getName() {
            return JSMsg.gettext("Letters to People", new Object[0]);
        }

        public String getRange() {
            return "Rom-Heb";
        }
    }
    ,
    GENERAL_LETTERS{

        public boolean contains(BibleBook book) {
            int bookNum = book.ordinal();
            return bookNum >= BibleBook.JAS.ordinal() && bookNum <= BibleBook.JUDE.ordinal();
        }

        public int getSize() {
            return 7;
        }

        public String getName() {
            return JSMsg.gettext("Letters from People", new Object[0]);
        }

        public String getRange() {
            return "Jas-Jud";
        }
    }
    ,
    REVELATION{

        public boolean contains(BibleBook book) {
            return book == BibleBook.REV;
        }

        public int getSize() {
            return 1;
        }

        public String getName() {
            return JSMsg.gettext("Revelation", new Object[0]);
        }

        public String getRange() {
            return "Rev";
        }
    };


    public abstract boolean contains(BibleBook var1);

    public abstract int getSize();

    public abstract String getName();

    public abstract String getRange();

    public String toString() {
        return this.getName();
    }

    public static DivisionName getSection(BibleBook book) {
        if (LETTERS.contains(book)) {
            return LETTERS;
        }
        if (HISTORY.contains(book)) {
            return HISTORY;
        }
        if (MINOR_PROPHETS.contains(book)) {
            return MINOR_PROPHETS;
        }
        if (GOSPELS_AND_ACTS.contains(book)) {
            return GOSPELS_AND_ACTS;
        }
        if (PENTATEUCH.contains(book)) {
            return PENTATEUCH;
        }
        if (POETRY.contains(book)) {
            return POETRY;
        }
        if (MAJOR_PROPHETS.contains(book)) {
            return MAJOR_PROPHETS;
        }
        return REVELATION;
    }
}

