/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.book.install;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.book.install.InstallManagerComboBoxModel;
import org.crosswire.bibledesktop.book.install.InstallerFactoryComboBoxModel;
import org.crosswire.bibledesktop.book.install.SiteEditor;
import org.crosswire.bibledesktop.book.install.SiteEditorFactory;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWAction;
import org.crosswire.common.swing.CWLabel;
import org.crosswire.common.swing.CWOptionPane;
import org.crosswire.common.swing.CWScrollPane;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.jsword.book.install.InstallManager;
import org.crosswire.jsword.book.install.Installer;
import org.crosswire.jsword.book.install.InstallerFactory;

public class EditSitePane
extends JPanel {
    private transient InstallManager imanager;
    private String editName;
    private transient Installer editInstaller;
    private boolean userInitiated;
    private transient ActionFactory actions;
    private JList lstSite;
    private JLabel lblMesg;
    private JTextField txtName;
    private JComboBox cboType;
    private JPanel siteEditorPane;
    private SiteEditor siteEditor;
    protected JDialog dlgMain;
    private JButton btnClose;
    private JPanel pnlAction;
    private static final long serialVersionUID = 3256446910616057650L;

    public EditSitePane(InstallManager imanager) {
        this.imanager = imanager;
        this.userInitiated = true;
        this.init();
        this.setState(EditState.DISPLAY, null);
        this.select();
    }

    private void init() {
        this.actions = new ActionFactory(this);
        this.lstSite = new JList(new InstallManagerComboBoxModel(this.imanager));
        CWScrollPane scrSite = new CWScrollPane(this.lstSite);
        this.lstSite.setSelectionMode(0);
        this.lstSite.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                if (ev.getValueIsAdjusting()) {
                    return;
                }
                EditSitePane.this.select();
            }
        });
        CWAction action = this.actions.addAction("Add", BDMsg.gettext("Add", new Object[0]));
        action.setTooltip(BDMsg.gettext("Add a new installation site.", new Object[0]));
        JButton btnAdd = new JButton(action);
        action = this.actions.addAction("Edit", BDMsg.gettext("Edit", new Object[0]));
        action.setTooltip(BDMsg.gettext("Edit the current installation site.", new Object[0]));
        JButton btnEdit = new JButton(action);
        action = this.actions.addAction("Delete", BDMsg.gettext("Delete", new Object[0]));
        action.setTooltip(BDMsg.gettext("Delete Site?", new Object[0]));
        JButton btnDelete = new JButton(action);
        JPanel pnlBtn1 = new JPanel();
        pnlBtn1.add((Component)btnAdd, null);
        pnlBtn1.add((Component)btnEdit, null);
        pnlBtn1.add((Component)btnDelete, null);
        JPanel pnlSite = new JPanel();
        pnlSite.setLayout(new BorderLayout());
        pnlSite.add((Component)scrSite, "Center");
        pnlSite.add((Component)pnlBtn1, "South");
        this.txtName = new JTextField();
        this.txtName.setColumns(10);
        this.txtName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent ev) {
                EditSitePane.this.siteUpdate();
            }

            public void insertUpdate(DocumentEvent ev) {
                EditSitePane.this.siteUpdate();
            }

            public void removeUpdate(DocumentEvent ev) {
                EditSitePane.this.siteUpdate();
            }
        });
        JLabel lblName = CWLabel.createJLabel(BDMsg.gettext("Site Name:", new Object[0]));
        lblName.setLabelFor(this.txtName);
        this.cboType = new JComboBox(new InstallerFactoryComboBoxModel(this.imanager));
        this.cboType.setEditable(false);
        this.cboType.setSelectedIndex(0);
        this.cboType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                EditSitePane.this.newType();
            }
        });
        JLabel lblType = CWLabel.createJLabel(BDMsg.gettext("Site Type", new Object[0]));
        lblType.setLabelFor(this.cboType);
        this.lblMesg = new JLabel();
        this.lblMesg.setText(" ");
        action = this.actions.addAction("Reset", BDMsg.gettext("Reset", new Object[0]));
        action.setTooltip(BDMsg.gettext("Reset the details.", new Object[0]));
        JButton btnReset = new JButton(action);
        action = this.actions.addAction("Save", BDMsg.gettext("Save", new Object[0]));
        action.setTooltip(BDMsg.gettext("Save the current changes.", new Object[0]));
        JButton btnSave = new JButton(action);
        JPanel pnlBtn2 = new JPanel();
        pnlBtn2.add((Component)btnSave, null);
        pnlBtn2.add((Component)btnReset, null);
        this.siteEditorPane = new JPanel();
        this.siteEditorPane.setLayout(new GridBagLayout());
        JPanel pnlMain = new JPanel();
        pnlMain.setPreferredSize(new Dimension(300, 300));
        pnlMain.setLayout(new GridBagLayout());
        pnlMain.add((Component)this.lblMesg, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        pnlMain.add((Component)lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 22, 0, new Insets(2, 10, 2, 2), 0, 0));
        pnlMain.add((Component)this.txtName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 10), 0, 0));
        if (this.imanager.getInstallerFactoryNames().size() > 1) {
            pnlMain.add((Component)lblType, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 22, 0, new Insets(2, 10, 2, 2), 0, 0));
            pnlMain.add((Component)this.cboType, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 10), 0, 0));
        }
        pnlMain.add((Component)new JSeparator(), new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        pnlMain.add((Component)this.siteEditorPane, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        pnlMain.add((Component)pnlBtn2, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        FixedSplitPane sptMain = new FixedSplitPane();
        sptMain.setOrientation(1);
        sptMain.setResizeWeight(0.0);
        ((JSplitPane)sptMain).setLeftComponent(pnlSite);
        ((JSplitPane)sptMain).setRightComponent(pnlMain);
        this.setLayout(new BorderLayout());
        this.add((Component)sptMain, "Center");
        this.btnClose = new JButton(this.actions.addAction("Close", BDMsg.gettext("Close", new Object[0])));
        this.pnlAction = new JPanel();
        this.pnlAction.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnlAction.setLayout(new FlowLayout(4));
        this.pnlAction.add((Component)this.btnClose, null);
        GuiUtil.applyDefaultOrientation(this);
    }

    public void showInDialog(Component parent) {
        Frame root = JOptionPane.getFrameForComponent(parent);
        this.dlgMain = new JDialog(root);
        ActionListener closer = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                EditSitePane.this.doClose();
            }
        };
        KeyStroke esc = KeyStroke.getKeyStroke(27, 0);
        this.dlgMain.getContentPane().setLayout(new BorderLayout());
        this.dlgMain.getContentPane().add((Component)new JPanel(), "North");
        this.dlgMain.getContentPane().add((Component)this.pnlAction, "South");
        this.dlgMain.getContentPane().add((Component)this, "Center");
        this.dlgMain.getContentPane().add((Component)new JPanel(), "After");
        this.dlgMain.getContentPane().add((Component)new JPanel(), "Before");
        this.dlgMain.getRootPane().setDefaultButton(this.btnClose);
        this.dlgMain.getRootPane().registerKeyboardAction(closer, esc, 2);
        this.dlgMain.setDefaultCloseOperation(2);
        this.dlgMain.setTitle(BDMsg.gettext("Edit Update Sites", new Object[0]));
        this.dlgMain.setResizable(true);
        this.dlgMain.setModal(true);
        GuiUtil.setSize((Window)this.dlgMain, new Dimension(750, 400));
        GuiUtil.centerOnScreen(this.dlgMain);
        GuiUtil.applyDefaultOrientation(this.dlgMain);
        this.dlgMain.setVisible(true);
        this.dlgMain.toFront();
    }

    public void doClose() {
        this.imanager.save();
        this.dlgMain.dispose();
    }

    public final void siteUpdate() {
        if (this.txtName.isEditable()) {
            String name = this.txtName.getText().trim();
            if (name.length() == 0) {
                this.setState(EditState.EDIT_ERROR, BDMsg.gettext("Missing site name", new Object[0]));
                return;
            }
            if (this.imanager.getInstaller(name) != null) {
                this.setState(EditState.EDIT_ERROR, BDMsg.gettext("Duplicate site name", new Object[0]));
                return;
            }
            this.setState(EditState.EDIT_OK, "");
        }
    }

    final void newType() {
        if (this.userInitiated) {
            String type = (String)this.cboType.getSelectedItem();
            InstallerFactory ifactory = this.imanager.getInstallerFactory(type);
            Installer installer = ifactory.createInstaller();
            this.setInstaller(installer);
        }
    }

    protected final void select() {
        String name = (String)this.lstSite.getSelectedValue();
        if (name == null) {
            this.actions.findAction("Edit").setEnabled(false);
            this.clear();
        } else {
            this.actions.findAction("Edit").setEnabled(true);
            Installer installer = this.imanager.getInstaller(name);
            this.display(name, installer);
        }
        if (this.siteEditor != null) {
            this.siteEditor.setEditable(false);
        }
    }

    public void doAdd() {
        this.newType();
        this.editName = null;
        this.editInstaller = null;
        this.setState(EditState.EDIT_OK, null);
        this.siteUpdate();
        GuiUtil.refresh(this);
    }

    public void doEdit() {
        String name = (String)this.lstSite.getSelectedValue();
        if (name == null) {
            String title = BDMsg.gettext("No Site", new Object[0]);
            String msg = BDMsg.gettext("No selected site to edit", new Object[0]);
            CWOptionPane.showMessageDialog(this, msg, title, 1);
            return;
        }
        this.editName = name;
        this.editInstaller = this.imanager.getInstaller(name);
        this.imanager.removeInstaller(name);
        this.setState(EditState.EDIT_OK, null);
        this.siteUpdate();
        this.txtName.grabFocus();
    }

    public void doDelete() {
        String name = (String)this.lstSite.getSelectedValue();
        if (name == null) {
            return;
        }
        String title = BDMsg.gettext("Delete Site?", new Object[0]);
        String msg = BDMsg.gettext("Are you sure you want to delete {0}?", name);
        if (CWOptionPane.showConfirmDialog(this, msg, title, 0) == 0) {
            this.imanager.removeInstaller(name);
        }
        this.clear();
        this.setState(EditState.DISPLAY, null);
    }

    public void doReset() {
        if (this.editName != null) {
            this.imanager.addInstaller(this.editName, this.editInstaller);
        }
        this.clear();
        this.editName = null;
        this.editInstaller = null;
        this.setState(EditState.DISPLAY, "");
        this.select();
    }

    public void doSave() {
        String name = this.txtName.getText();
        this.siteEditor.save();
        Installer installer = this.siteEditor.getInstaller();
        this.imanager.addInstaller(name, installer);
        this.clear();
        this.editName = null;
        this.editInstaller = null;
        this.setState(EditState.DISPLAY, "");
        this.select();
    }

    private void setState(EditState stateEditError, String message) {
        switch (stateEditError) {
            case DISPLAY: {
                this.actions.findAction("Add").setEnabled(true);
                this.actions.findAction("Delete").setEnabled(true);
                this.actions.findAction("Edit").setEnabled(true);
                this.lstSite.setEnabled(true);
                this.actions.findAction("Reset").setEnabled(false);
                this.actions.findAction("Save").setEnabled(false);
                this.actions.findAction("Close").setEnabled(true);
                this.txtName.setEditable(false);
                this.cboType.setEnabled(false);
                if (this.siteEditor == null) break;
                this.siteEditor.setEditable(false);
                break;
            }
            case EDIT_OK: 
            case EDIT_ERROR: {
                this.actions.findAction("Add").setEnabled(false);
                this.actions.findAction("Delete").setEnabled(false);
                this.actions.findAction("Edit").setEnabled(false);
                this.lstSite.setEnabled(false);
                this.actions.findAction("Reset").setEnabled(true);
                this.actions.findAction("Save").setEnabled(stateEditError == EditState.EDIT_OK);
                this.actions.findAction("Close").setEnabled(false);
                this.txtName.setEditable(true);
                this.cboType.setEnabled(true);
                if (this.siteEditor == null) break;
                this.siteEditor.setEditable(true);
                break;
            }
            default: {
                assert (false) : stateEditError;
                break;
            }
        }
        if (message == null || message.trim().length() == 0) {
            this.lblMesg.setText(" ");
        } else {
            this.lblMesg.setText(message);
        }
    }

    private void display(String name, Installer installer) {
        this.txtName.setText(name);
        String type = this.imanager.getFactoryNameForInstaller(installer);
        this.userInitiated = false;
        this.cboType.setSelectedItem(type);
        this.userInitiated = true;
        this.setInstaller(installer);
    }

    private void clear() {
        this.txtName.setText("");
        this.setInstaller(null);
    }

    private void setInstaller(Installer installer) {
        this.siteEditorPane.removeAll();
        this.siteEditor = null;
        if (installer != null) {
            this.siteEditor = SiteEditorFactory.createSiteEditor(installer);
            this.siteEditorPane.add((Component)((Object)this.siteEditor), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            GuiUtil.applyDefaultOrientation(this.siteEditorPane);
        }
        GuiUtil.refresh(this);
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.imanager = null;
        this.editInstaller = null;
        this.actions = new ActionFactory(this);
        is.defaultReadObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EditState {
        DISPLAY,
        EDIT_OK,
        EDIT_ERROR;

    }
}

