/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.config.swing;

import java.awt.Dimension;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.crosswire.common.config.Choice;
import org.crosswire.common.config.MultipleChoice;
import org.crosswire.common.config.swing.Field;
import org.crosswire.common.diff.Distance;
import org.crosswire.common.swing.CWOtherMsg;
import org.crosswire.common.swing.GuiUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionsField
implements Field {
    private JComboBox combo = new JComboBox<String>(new String[]{CWOtherMsg.lookupText("No Options Set", new Object[0])});
    private String[] list;
    private static final Logger log = LoggerFactory.getLogger(OptionsField.class);

    public OptionsField() {
        this.combo.setPreferredSize(new Dimension(100, this.combo.getPreferredSize().height));
        GuiUtil.applyDefaultOrientation(this.combo);
    }

    public void setChoice(Choice param) {
        if (param instanceof MultipleChoice) {
            MultipleChoice mc = (MultipleChoice)param;
            this.list = mc.getOptions();
            if (this.list == null) {
                throw new IllegalArgumentException("getOptions() returns null for option with help text " + mc.getHelpText());
            }
            this.combo.setModel(new DefaultComboBoxModel<String>(this.list));
        } else {
            this.list = new String[]{CWOtherMsg.lookupText("Error", new Object[0])};
        }
    }

    public String getValue() {
        Object reply = this.combo.getSelectedItem();
        if (reply instanceof Map.Entry) {
            return ((Map.Entry)reply).getKey().toString();
        }
        return reply == null ? "" : reply.toString();
    }

    public void setValue(String value) {
        if (this.list != null && this.list.length > 0) {
            int distance = value.length();
            for (int i = 0; i < this.list.length; ++i) {
                if (value.equals(this.list[i])) {
                    this.combo.setSelectedItem(this.list[i]);
                    return;
                }
                distance = Math.max(distance, this.list[i].length());
            }
            ++distance;
            int bestMatch = 0;
            for (int i = 0; i < this.list.length; ++i) {
                int newDistance = Distance.getLevenshteinDistance((String)value, (String)this.list[i]);
                if (distance <= newDistance) continue;
                bestMatch = i;
                distance = newDistance;
            }
            this.combo.setSelectedItem(this.list[bestMatch]);
            if (bestMatch > 0) {
                log.warn("Checked for options without finding exact match: '{}'. Best match is: {}", (Object)value, this.combo.getSelectedItem());
                return;
            }
        }
        Object selected = this.combo.getSelectedItem();
        if (value.length() > 0 && selected != null) {
            log.warn("Checked for options without finding: '{}'. Defaulting to first option: ", (Object)value, selected);
        }
    }

    public JComponent getComponent() {
        return this.combo;
    }
}

