/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.common.swing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.crosswire.common.swing.CWOtherMsg;
import org.crosswire.common.util.Convert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapTableModel
extends AbstractTableModel {
    private transient List<StringPair> list;
    private Map<Object, Object> map;
    private String[] colNames = new String[]{CWOtherMsg.lookupText("Keys", new Object[0]), CWOtherMsg.lookupText("Values", new Object[0])};
    private static final long serialVersionUID = 3546365041277352241L;

    public MapTableModel() {
        this(null);
    }

    public MapTableModel(Map map) {
        this.list = new ArrayList<StringPair>();
        this.setMap(map);
    }

    public final void setMap(Map<Object, Object> map) {
        this.map = map;
        this.list.clear();
        if (map != null) {
            for (Map.Entry<Object, Object> me : map.entrySet()) {
                Object k = me.getKey();
                Object v = me.getValue();
                if (k == null || v == null) continue;
                String key = k.toString().trim();
                String value = v.toString().trim();
                if (key.length() == 0) continue;
                this.list.add(new StringPair(key, value));
            }
        }
        this.fireTableDataChanged();
    }

    public void add(String key, String aValue) {
        String value = aValue;
        if (value == null) {
            value = "";
        }
        if (key == null || key.length() == 0) {
            return;
        }
        if (this.map.containsKey(key) && value.equals(this.map.get(key))) {
            return;
        }
        this.map.put(key, value);
        this.setMap(this.map);
    }

    public void remove(String key) {
        if (this.map != null) {
            this.map.remove(key);
            this.setMap(this.map);
        }
    }

    public void update(String oldkey, String newkey, String newvalue) {
        if (this.map != null) {
            if (!oldkey.equals(newkey)) {
                this.map.remove(oldkey);
            }
            this.add(newkey, newvalue);
        }
    }

    public String getValue() {
        return Convert.map2String(this.map);
    }

    @Override
    public int getColumnCount() {
        if (this.list == null) {
            return 0;
        }
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.list == null) {
            return null;
        }
        StringPair entry = this.list.get(row);
        if (col == 0) {
            return entry.getKey();
        }
        return entry.getValue();
    }

    public Class<String> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.colNames[col];
    }

    public void setColumnName(int col, String name) {
        this.colNames[col] = name;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.list = new ArrayList<StringPair>();
        is.defaultReadObject();
    }

    private static final class StringPair
    implements Serializable {
        private String key;
        private String value;
        private static final long serialVersionUID = 1730905297956834949L;

        StringPair(String k, String v) {
            this.key = k;
            this.value = v;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

