/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.SwingPropertyChangeSupport;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.book.BibleViewPane;
import org.crosswire.bibledesktop.book.DisplaySelectEvent;
import org.crosswire.bibledesktop.book.DisplaySelectListener;
import org.crosswire.bibledesktop.book.DisplaySelectPane;
import org.crosswire.bibledesktop.book.MultiBookPane;
import org.crosswire.bibledesktop.desktop.DesktopActions;
import org.crosswire.bibledesktop.desktop.Splash;
import org.crosswire.bibledesktop.desktop.StatusBar;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.URIEvent;
import org.crosswire.bibledesktop.display.URIEventListener;
import org.crosswire.bibledesktop.display.basic.SplitBookDataDisplay;
import org.crosswire.bibledesktop.util.ConfigurableSwingConverter;
import org.crosswire.common.config.ChoiceFactory;
import org.crosswire.common.config.Config;
import org.crosswire.common.history.History;
import org.crosswire.common.progress.JobManager;
import org.crosswire.common.progress.Progress;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWAction;
import org.crosswire.common.swing.CWOptionPane;
import org.crosswire.common.swing.CatchingThreadGroup;
import org.crosswire.common.swing.ExceptionPane;
import org.crosswire.common.swing.FixedSplitPane;
import org.crosswire.common.swing.GuiUtil;
import org.crosswire.common.swing.LookAndFeelUtil;
import org.crosswire.common.swing.desktop.LayoutPersistence;
import org.crosswire.common.swing.desktop.LayoutType;
import org.crosswire.common.swing.desktop.TDIViewLayout;
import org.crosswire.common.swing.desktop.ToolBar;
import org.crosswire.common.swing.desktop.ViewGenerator;
import org.crosswire.common.swing.desktop.ViewManager;
import org.crosswire.common.swing.desktop.event.ViewEvent;
import org.crosswire.common.swing.desktop.event.ViewEventListener;
import org.crosswire.common.util.CWClassLoader;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.OSType;
import org.crosswire.common.util.Reporter;
import org.crosswire.common.util.ResourceUtil;
import org.crosswire.common.util.Translations;
import org.crosswire.common.xml.XMLUtil;
import org.crosswire.jsword.book.Book;
import org.crosswire.jsword.book.BookFilters;
import org.crosswire.jsword.book.Books;
import org.crosswire.jsword.book.BooksEvent;
import org.crosswire.jsword.book.BooksListener;
import org.crosswire.jsword.book.Defaults;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.util.ConverterFactory;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Desktop
extends JFrame
implements URIEventListener,
ViewEventListener,
DisplaySelectListener,
ViewGenerator {
    private static final CWProject PROJECT = CWProject.instance();
    private boolean hasRefBooks;
    private static final String SPLASH_PROPS = "splash";
    public static final String BIBLE_PROTOCOL = "bible";
    public static final String DICTIONARY_PROTOCOL = "dict";
    public static final String GREEK_DEF_PROTOCOL = "gdef";
    public static final String HEBREW_DEF_PROTOCOL = "hdef";
    public static final String GREEK_MORPH_PROTOCOL = "gmorph";
    public static final String HEBREW_MORPH_PROTOCOL = "hmorph";
    public static final String COMMENTARY_PROTOCOL = "comment";
    private static final String EMPTY_STRING = "";
    private static final String CONFIG_KEY = "config";
    private static final String DESKTOP_KEY = "desktop";
    private static final String CONV_KEY = "converters";
    private static final String CSWING_KEY = "cswing-styles";
    private transient Config config;
    private static boolean sidebarShowing;
    private static boolean viewSourceShowing;
    private boolean compareShowing;
    private static boolean reuseBibleView;
    protected volatile transient ActionFactory actions;
    protected transient DesktopActions desktopActions;
    private static final ImageIcon ICON_APP;
    private transient ViewManager views;
    private JPanel corePanel;
    private JCheckBoxMenuItem sidebarToggle;
    private StatusBar barStatus;
    protected MultiBookPane reference;
    private JSplitPane sptBooks;
    private JPanel mainPanel;
    private transient History history;
    private PropertyChangeSupport changeSupport;
    protected static final Logger log;
    private static final long serialVersionUID = 3977014029116191800L;

    public static void main(String[] args) {
        try {
            CatchingThreadGroup group = new CatchingThreadGroup("BibleDesktopUIGroup");
            DesktopThread t = new DesktopThread(group);
            t.start();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            ExceptionPane.showExceptionDialog(null, ex);
        }
    }

    public Desktop() {
        this.setName("Desktop");
        Translations.instance().setLocale();
        URI predictURI = PROJECT.getWritableURI(SPLASH_PROPS, ".properties");
        Progress startJob = JobManager.createJob((String)"Startup");
        startJob.beginJob(BDMsg.gettext("Startup", new Object[0]), predictURI);
        this.generateConfig();
        JOptionPane.setRootFrame(this);
        Reporter.grabAWTExecptions((boolean)true);
        this.desktopActions = new DesktopActions(this);
        this.actions = this.desktopActions.getActions();
        startJob.setSectionName(BDMsg.gettext("Generating Components", new Object[0]));
        this.buildActionMap();
        this.createComponents();
        this.debug();
        startJob.setSectionName(BDMsg.gettext("General configuration", new Object[0]));
        this.createLayout();
        BooksListener cbl = new BooksListener(){

            public void bookAdded(BooksEvent ev) {
                Desktop.this.generateConfig();
            }

            public void bookRemoved(BooksEvent ev) {
                Desktop.this.generateConfig();
            }
        };
        Books.installed().addBooksListener(cbl);
        GuiUtil.applyDefaultOrientation(this);
        startJob.done();
    }

    private void debug() {
    }

    private void createComponents() {
        this.barStatus = new StatusBar();
        this.reference = new MultiBookPane();
        this.sptBooks = new FixedSplitPane(false);
        this.changeSupport = new SwingPropertyChangeSupport(this);
        this.views = new ViewManager(this);
        this.views.setActionFactory(this.getViewActions(this.views));
        this.views.addViewEventListener(this);
        this.history = new History();
    }

    private ActionFactory getViewActions(ViewManager viewMgr) {
        ActionFactory viewActions = new ActionFactory(viewMgr);
        CWAction cwAction = viewActions.addAction("TabMode", BDMsg.gettext("Tabbed Mode", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("View passages using tabs", new Object[0]));
        cwAction = viewActions.addAction("WindowMode", BDMsg.gettext("Sub-Window Mode", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("View passages using sub-windows", new Object[0]));
        cwAction = viewActions.addAction("NewTab", BDMsg.gettext("New Bible View", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Open a new Bible View", new Object[0]));
        cwAction.setSmallIcon("toolbarButtonGraphics/general/New16.gif");
        cwAction.setLargeIcon("toolbarButtonGraphics/general/New24.gif");
        cwAction.setAccelerator("N,ctrl");
        cwAction = viewActions.addAction("CloseView", BDMsg.gettext("Close the Current View", new Object[0]));
        cwAction.setAccelerator("0x73,ctrl");
        cwAction = viewActions.addAction("ClearView", BDMsg.gettext("Clear the Current View", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Clear the current view's passages", new Object[0]));
        cwAction = viewActions.addAction("CloseAllViews", BDMsg.gettext("Close All Views", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Close all passages", new Object[0]));
        cwAction = viewActions.addAction("CloseOtherViews", BDMsg.gettext("Close Other Views", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Close all the other passages.", new Object[0]));
        return viewActions;
    }

    private void createLayout() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent ev) {
                Desktop.this.actions.findAction("Exit").actionPerformed(new ActionEvent(this, 0, Desktop.EMPTY_STRING));
            }
        });
        this.setDefaultCloseOperation(2);
        TDIViewLayout tdi = (TDIViewLayout)LayoutType.TDI.getLayout();
        tdi.addPopup(this.createPopupMenu());
        this.reference.addURIEventListener(this);
        this.sptBooks.setOrientation(1);
        this.sptBooks.setRightComponent(this.reference);
        this.sptBooks.setLeftComponent(this.views.getDesktop());
        this.sptBooks.setResizeWeight(0.8);
        this.sptBooks.setOpaque(true);
        this.sptBooks.setBorder(null);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        ToolBar toolbar = this.createToolBar();
        contentPane.add((Component)toolbar, "North");
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 5));
        this.mainPanel.add((Component)this.sptBooks, "Center");
        this.corePanel = new JPanel(new BorderLayout());
        this.corePanel.add((Component)this.mainPanel, "Center");
        this.corePanel.add((Component)this.barStatus, "South");
        contentPane.add((Component)this.corePanel, "Center");
        this.setJMenuBar(this.createMenuBar(toolbar));
        this.setIconImage(ICON_APP.getImage());
        this.setEnabled(true);
        this.setTitle(BDMsg.getApplicationTitle());
    }

    private JMenuBar createMenuBar(ToolBar toolbar) {
        JMenuBar barMenu = new JMenuBar();
        barMenu.add(this.createFileMenu());
        barMenu.add(this.createEditMenu());
        barMenu.add(this.createViewMenu(toolbar));
        barMenu.add(this.createNavigateMenu());
        barMenu.add(this.createToolsMenu());
        barMenu.add(this.createHelpMenu());
        return barMenu;
    }

    private void buildActionMap() {
        CWAction cwAction = this.actions.addAction("File", BDMsg.gettext("File", new Object[0]));
        cwAction = this.actions.addAction("Open", BDMsg.gettext("Open", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Open a saved passage.", new Object[0]));
        cwAction.setSmallIcon("toolbarButtonGraphics/general/Open16.gif");
        cwAction.setLargeIcon("toolbarButtonGraphics/general/Open24.gif");
        cwAction.setAccelerator("O,ctrl");
        cwAction = this.actions.addAction("Save", BDMsg.gettext("Save", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Save the current passage.", new Object[0]));
        cwAction.setSmallIcon("toolbarButtonGraphics/general/Save16.gif");
        cwAction.setLargeIcon("toolbarButtonGraphics/general/Save24.gif");
        cwAction.setAccelerator("S,ctrl");
        cwAction = this.actions.addAction("SaveAs", BDMsg.gettext("Save As", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Save the current passage under a different name.", new Object[0]));
        cwAction.setSmallIcon("toolbarButtonGraphics/general/SaveAs16.gif");
        cwAction.setLargeIcon("toolbarButtonGraphics/general/SaveAs24.gif");
        cwAction.setAccelerator("A,ctrl,shift");
        cwAction = this.actions.addAction("SaveAll", BDMsg.gettext("Save All", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Save all passages.", new Object[0]));
        cwAction.setSmallIcon("toolbarButtonGraphics/general/SaveAll16.gif");
        cwAction.setLargeIcon("toolbarButtonGraphics/general/SaveAll24.gif");
        cwAction.setAccelerator("S,ctrl,shift");
        cwAction = this.actions.addAction("Exit", BDMsg.gettext("Exit", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Exit the Desktop application.", new Object[0]));
        cwAction.setAccelerator("0x73,alt");
        cwAction = this.actions.addAction("Edit", BDMsg.gettext("Edit", new Object[0]));
        cwAction = this.actions.addAction("Copy", BDMsg.gettext("Copy", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Copy the selection.", new Object[0]));
        cwAction.setSmallIcon("toolbarButtonGraphics/general/Copy16.gif");
        cwAction.setLargeIcon("toolbarButtonGraphics/general/Copy24.gif");
        cwAction.setAccelerator("C,ctrl");
        cwAction = this.actions.addAction("Navigate", BDMsg.gettext("Navigate", new Object[0]));
        cwAction = this.actions.addAction("Back", BDMsg.gettext("Back", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Go back to previous passage.", new Object[0]));
        cwAction.setSmallIcon("toolbarButtonGraphics/navigation/Back16.gif");
        cwAction.setLargeIcon("toolbarButtonGraphics/navigation/Back24.gif");
        cwAction = this.actions.addAction("Forward", BDMsg.gettext("Forward", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Go forward to next passage.", new Object[0]));
        cwAction.setSmallIcon("toolbarButtonGraphics/navigation/Forward16.gif");
        cwAction.setLargeIcon("toolbarButtonGraphics/navigation/Forward24.gif");
        cwAction = this.actions.addAction("Verse", BDMsg.gettext("Verse Numbers", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Set the style for verse numbers", new Object[0]));
        cwAction = this.actions.addAction(XSLTProperty.VERSE_NUMBERS.getName(), BDMsg.gettext("Show Verse Numbers", new Object[0]));
        cwAction = this.actions.addAction(XSLTProperty.CV.getName(), BDMsg.gettext("Show Chapter and Verse Numbers", new Object[0]));
        cwAction = this.actions.addAction(XSLTProperty.BCV.getName(), BDMsg.gettext("Show Book, Chapter and Verse Numbers", new Object[0]));
        cwAction = this.actions.addAction(XSLTProperty.NO_VERSE_NUMBERS.getName(), BDMsg.gettext("Hide Verse Numbers", new Object[0]));
        cwAction = this.actions.addAction("View", BDMsg.gettext("View", new Object[0]));
        cwAction = this.actions.addAction(XSLTProperty.TINY_VERSE_NUMBERS.getName(), BDMsg.gettext("Use Small Verse Numbers", new Object[0]));
        cwAction = this.actions.addAction(XSLTProperty.START_VERSE_ON_NEWLINE.getName(), BDMsg.gettext("Start Verses on Separate Lines", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Start each verses on a new line", new Object[0]));
        cwAction = this.actions.addAction("CompareToggle", BDMsg.gettext("Show Differences", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Toggle display of differences between different Bibles", new Object[0]));
        cwAction = this.actions.addAction(XSLTProperty.HEADINGS.getName(), BDMsg.gettext("Show Headings", new Object[0]));
        cwAction = this.actions.addAction(XSLTProperty.NOTES.getName(), BDMsg.gettext("Show Study Notes", new Object[0]));
        cwAction = this.actions.addAction(XSLTProperty.XREF.getName(), BDMsg.gettext("Use Cross Reference Linkings", new Object[0]));
        cwAction = this.actions.addAction(XSLTProperty.STRONGS_NUMBERS.getName(), BDMsg.gettext("Show Strong's Numbers", new Object[0]));
        cwAction = this.actions.addAction(XSLTProperty.MORPH.getName(), BDMsg.gettext("Show Word Morphology", new Object[0]));
        cwAction = this.actions.addAction("ToolTipToggle", BDMsg.gettext("Show Tool Tips", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Toggle display of tool tips", new Object[0]));
        cwAction.setAccelerator("T,ctrl");
        cwAction = this.actions.addAction("StatusToggle", BDMsg.gettext("Show the Status Area", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Toggle display of the status area", new Object[0]));
        cwAction = this.actions.addAction("SidebarToggle", BDMsg.gettext("Show the Passage Sidebar", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Toggle display of the Passage Sidebar", new Object[0]));
        cwAction.setAccelerator("B,ctrl");
        cwAction = this.actions.addAction("ViewSource", BDMsg.gettext("View Source", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("View the HTML and OSIS source to the current window", new Object[0]));
        cwAction.setAccelerator("U,ctrl");
        cwAction = this.actions.addAction("Tools", BDMsg.gettext("Tools", new Object[0]));
        cwAction = this.actions.addAction("Books", BDMsg.gettext("Books", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Display/Install Books", new Object[0]));
        cwAction.setSmallIcon("toolbarButtonGraphics/general/Import16.gif");
        cwAction.setLargeIcon("toolbarButtonGraphics/general/Import24.gif");
        cwAction = this.actions.addAction("Options", BDMsg.gettext("Options", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Alter system settings.", new Object[0]));
        cwAction.setSmallIcon("toolbarButtonGraphics/general/Properties16.gif");
        cwAction.setLargeIcon("toolbarButtonGraphics/general/Properties24.gif");
        cwAction = this.actions.addAction("Help", BDMsg.gettext("Help", new Object[0]));
        cwAction = this.actions.addAction("Contents", BDMsg.gettext("Contents", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Help file contents.", new Object[0]));
        cwAction.setSmallIcon("toolbarButtonGraphics/general/Help16.gif");
        cwAction.setLargeIcon("toolbarButtonGraphics/general/Help24.gif");
        cwAction.setAccelerator("0x70");
        cwAction = this.actions.addAction("About", BDMsg.gettext("About", new Object[0]));
        cwAction.setTooltip(BDMsg.gettext("Information about Bible Desktop", new Object[0]));
        cwAction.setSmallIcon("toolbarButtonGraphics/general/About16.gif");
        cwAction.setLargeIcon("toolbarButtonGraphics/general/About24.gif");
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu(this.actions.findAction("File"));
        menu.setToolTipText(null);
        menu.add(this.views.getContextAction("NewTab")).addMouseListener(this.barStatus);
        menu.add(this.views.getContextAction("CloseView")).addMouseListener(this.barStatus);
        menu.add(this.views.getContextAction("ClearView")).addMouseListener(this.barStatus);
        menu.add(this.views.getContextAction("CloseOtherViews")).addMouseListener(this.barStatus);
        menu.add(this.views.getContextAction("CloseAllViews")).addMouseListener(this.barStatus);
        menu.addSeparator();
        menu.add(this.actions.findAction("Open")).addMouseListener(this.barStatus);
        menu.add(this.actions.findAction("Save")).addMouseListener(this.barStatus);
        menu.add(this.actions.findAction("SaveAs")).addMouseListener(this.barStatus);
        menu.add(this.actions.findAction("SaveAll")).addMouseListener(this.barStatus);
        if (!this.desktopActions.isOSXRegistered()) {
            menu.addSeparator();
            menu.add(this.actions.findAction("Exit")).addMouseListener(this.barStatus);
        }
        return menu;
    }

    private JMenu createEditMenu() {
        JMenu menu = new JMenu(this.actions.findAction("Edit"));
        menu.setToolTipText(null);
        menu.add(this.actions.findAction("Copy")).addMouseListener(this.barStatus);
        return menu;
    }

    private JMenu createNavigateMenu() {
        JMenu menu = new JMenu(this.actions.findAction("Navigate"));
        menu.setToolTipText(null);
        menu.add(this.actions.findAction("Back")).addMouseListener(this.barStatus);
        menu.add(this.actions.findAction("Forward")).addMouseListener(this.barStatus);
        return menu;
    }

    private JRadioButtonMenuItem createRadioButton(ButtonGroup group, XSLTProperty prop) {
        JRadioButtonMenuItem radio = new JRadioButtonMenuItem(this.actions.findAction(prop.getName()));
        group.add(radio);
        radio.setSelected(prop.getDefaultState());
        return radio;
    }

    private JCheckBoxMenuItem createCheckbox(XSLTProperty prop) {
        JCheckBoxMenuItem toggle = new JCheckBoxMenuItem(this.actions.findAction(prop.getName()));
        toggle.setSelected(prop.getDefaultState());
        return toggle;
    }

    private JMenu createVerseMenu() {
        JMenu menu = new JMenu(this.actions.findAction("Verse"));
        ButtonGroup group = new ButtonGroup();
        menu.add(this.createRadioButton(group, XSLTProperty.VERSE_NUMBERS)).addMouseListener(this.barStatus);
        menu.add(this.createRadioButton(group, XSLTProperty.CV)).addMouseListener(this.barStatus);
        menu.add(this.createRadioButton(group, XSLTProperty.BCV)).addMouseListener(this.barStatus);
        menu.add(this.createRadioButton(group, XSLTProperty.NO_VERSE_NUMBERS)).addMouseListener(this.barStatus);
        return menu;
    }

    private JMenu createViewMenu(ToolBar toolbar) {
        JMenu menu = new JMenu(this.actions.findAction("View"));
        menu.add(this.createCheckbox(XSLTProperty.TINY_VERSE_NUMBERS)).addMouseListener(this.barStatus);
        menu.add(this.createCheckbox(XSLTProperty.START_VERSE_ON_NEWLINE)).addMouseListener(this.barStatus);
        menu.add(this.createVerseMenu());
        menu.addSeparator();
        menu.add(new JCheckBoxMenuItem(this.actions.findAction("CompareToggle"))).addMouseListener(this.barStatus);
        menu.add(this.createCheckbox(XSLTProperty.HEADINGS)).addMouseListener(this.barStatus);
        menu.add(this.createCheckbox(XSLTProperty.NOTES)).addMouseListener(this.barStatus);
        menu.add(this.createCheckbox(XSLTProperty.XREF)).addMouseListener(this.barStatus);
        menu.add(this.createCheckbox(XSLTProperty.STRONGS_NUMBERS)).addMouseListener(this.barStatus);
        menu.add(this.createCheckbox(XSLTProperty.MORPH)).addMouseListener(this.barStatus);
        menu.addSeparator();
        menu.add(this.views.getTdiView()).addMouseListener(this.barStatus);
        menu.add(this.views.getMdiView()).addMouseListener(this.barStatus);
        menu.addSeparator();
        menu.add(toolbar.getShowToggle()).addMouseListener(this.barStatus);
        menu.add(toolbar.getTextToggle()).addMouseListener(this.barStatus);
        menu.add(toolbar.getIconSizeToggle()).addMouseListener(this.barStatus);
        JCheckBoxMenuItem toggle = new JCheckBoxMenuItem(this.actions.findAction("ToolTipToggle"));
        toggle.setSelected(true);
        menu.add(toggle).addMouseListener(this.barStatus);
        toggle = new JCheckBoxMenuItem(this.actions.findAction("StatusToggle"));
        toggle.setSelected(true);
        menu.add(toggle).addMouseListener(this.barStatus);
        this.sidebarToggle = new JCheckBoxMenuItem(this.actions.findAction("SidebarToggle"));
        this.sidebarToggle.setSelected(Desktop.isSidebarShowing());
        menu.add(this.sidebarToggle).addMouseListener(this.barStatus);
        if (viewSourceShowing) {
            menu.addSeparator();
            menu.add(this.actions.findAction("ViewSource")).addMouseListener(this.barStatus);
            menu.setToolTipText(null);
        }
        return menu;
    }

    private JMenu createToolsMenu() {
        JMenu menu = new JMenu(this.actions.findAction("Tools"));
        menu.setToolTipText(null);
        menu.add(this.actions.findAction("Books")).addMouseListener(this.barStatus);
        if (!this.desktopActions.isOSXRegistered()) {
            menu.add(this.actions.findAction("Options")).addMouseListener(this.barStatus);
        }
        return menu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = new JMenu(this.actions.findAction("Help"));
        menu.setToolTipText(null);
        menu.add(this.actions.findAction("Contents")).addMouseListener(this.barStatus);
        if (!this.desktopActions.isOSXRegistered()) {
            menu.addSeparator();
            menu.add(this.actions.findAction("About")).addMouseListener(this.barStatus);
        }
        return menu;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.views.getContextAction("NewTab")).addMouseListener(this.barStatus);
        menu.add(this.views.getContextAction("CloseView")).addMouseListener(this.barStatus);
        menu.add(this.views.getContextAction("ClearView")).addMouseListener(this.barStatus);
        menu.add(this.views.getContextAction("CloseOtherViews")).addMouseListener(this.barStatus);
        menu.add(this.views.getContextAction("CloseAllViews")).addMouseListener(this.barStatus);
        menu.addSeparator();
        menu.add(this.actions.findAction("Open")).addMouseListener(this.barStatus);
        menu.add(this.actions.findAction("Save")).addMouseListener(this.barStatus);
        menu.add(this.actions.findAction("SaveAs")).addMouseListener(this.barStatus);
        menu.add(this.actions.findAction("SaveAll")).addMouseListener(this.barStatus);
        return menu;
    }

    private ToolBar createToolBar() {
        ToolBar menu = new ToolBar(this);
        menu.add(this.views.getContextAction("NewTab")).addMouseListener(this.barStatus);
        menu.add(this.actions.findAction("Open")).addMouseListener(this.barStatus);
        menu.add(this.actions.findAction("Save")).addMouseListener(this.barStatus);
        menu.addSeparator();
        menu.add(this.actions.findAction("Copy")).addMouseListener(this.barStatus);
        menu.addSeparator();
        menu.add(this.actions.findAction("Back")).addMouseListener(this.barStatus);
        menu.add(this.actions.findAction("Forward")).addMouseListener(this.barStatus);
        menu.addSeparator();
        menu.add(this.actions.findAction("Contents")).addMouseListener(this.barStatus);
        if (!this.desktopActions.isOSXRegistered()) {
            menu.add(this.actions.findAction("About")).addMouseListener(this.barStatus);
        }
        menu.setRollover(true);
        return menu;
    }

    public void establishPreferredSize() {
        Container contentPane = this.getContentPane();
        if (contentPane instanceof JComponent) {
            ((JComponent)contentPane).setPreferredSize(contentPane.getSize());
        }
    }

    public ViewManager getViews() {
        return this.views;
    }

    @Override
    public Component createView() {
        boolean show = this.sidebarToggle == null ? Desktop.isSidebarShowing() : this.sidebarToggle.isSelected();
        BibleViewPane view = new BibleViewPane(show);
        BookDataDisplay display = view.getPassagePane().getBookDataDisplay();
        display.addURIEventListener(this);
        display.addURIEventListener(this.barStatus);
        display.setCompareBooks(this.compareShowing);
        this.changeSupport.addPropertyChangeListener("ComparingBooks", display);
        DisplaySelectPane dsp = view.getSelectPane();
        dsp.addCommandListener(this);
        return view;
    }

    @Override
    public void viewRemoved(ViewEvent event) {
        BibleViewPane view = (BibleViewPane)event.getSource();
        BookDataDisplay display = view.getPassagePane().getBookDataDisplay();
        display.removeURIEventListener(this);
        display.removeURIEventListener(this.barStatus);
        this.changeSupport.removePropertyChangeListener("ComparingBooks", display);
        DisplaySelectPane dsp = view.getSelectPane();
        dsp.removeCommandListener(this);
    }

    @Override
    public void bookChosen(DisplaySelectEvent ev) {
    }

    @Override
    public void passageSelected(DisplaySelectEvent ev) {
        Key key = ev.getKey();
        if (key != null && !key.isEmpty()) {
            this.history.add((Object)key.getName());
        }
    }

    public void selectHistory(int i) {
        Object obj = this.history.go(i);
        if (obj != null) {
            this.activateURI(new URIEvent(this, BIBLE_PROTOCOL, (String)obj));
        }
    }

    @Override
    public void activateURI(URIEvent ev) {
        this.barStatus.activateURI(ev);
        String protocol = ev.getScheme();
        String data = ev.getURI();
        try {
            if (protocol.equals(BIBLE_PROTOCOL)) {
                BibleViewPane view;
                BibleViewPane clearView = null;
                for (Component comp : this.views) {
                    BibleViewPane view2 = (BibleViewPane)comp;
                    if (view2.isClear()) {
                        clearView = view2;
                        continue;
                    }
                    Book book = view2.getSelectPane().getFirstBook();
                    if (book == null) continue;
                    Key key = book.getKey(data);
                    String dataPassage = key.getName();
                    if (!view2.getTitle().equals(dataPassage)) continue;
                    this.views.select(view2);
                    return;
                }
                if (Desktop.isBibleViewReused() && (view = (BibleViewPane)this.views.getSelected()) != null) {
                    clearView = view;
                }
                if (clearView != null) {
                    Book book = clearView.getSelectPane().getFirstBook();
                    if (book != null) {
                        Key key = book.getKey(data);
                        clearView.setKey(book.createEmptyKeyList());
                        clearView.setKey(key);
                        this.views.select(clearView);
                    }
                    return;
                }
                view = (BibleViewPane)this.views.addView();
                Book book = view.getSelectPane().getFirstBook();
                if (book != null) {
                    Key key = book.getKey(data);
                    view.setKey(key);
                }
            } else if (protocol.equals(COMMENTARY_PROTOCOL)) {
                Book book = Defaults.getCommentary();
                if (book != null && Books.installed().getBook(book.getName()) != null) {
                    this.reference.selectBook(book);
                    Book[] books = this.reference.getBooks();
                    Key key = books[0].getKey(data);
                    this.reference.setKey(key);
                }
            } else if (protocol.equals(GREEK_DEF_PROTOCOL)) {
                this.jump(Defaults.getGreekDefinitions(), data);
            } else if (protocol.equals(HEBREW_DEF_PROTOCOL)) {
                this.jump(Defaults.getHebrewDefinitions(), data);
            } else if (protocol.equals(GREEK_MORPH_PROTOCOL)) {
                this.jump(Defaults.getGreekParse(), data);
            } else if (protocol.equals(HEBREW_MORPH_PROTOCOL)) {
                this.jump(Defaults.getHebrewParse(), data);
            } else if (protocol.equals(DICTIONARY_PROTOCOL)) {
                this.jump(Defaults.getDictionary(), data);
            } else {
                Reporter.informUser((Object)this, (Throwable)new MalformedURLException(BDMsg.gettext("Unknown protocol {0}", protocol)));
            }
        }
        catch (NoSuchKeyException ex) {
            Reporter.informUser((Object)this, (LucidException)ex);
        }
    }

    private void jump(Book book, String data) {
        if (book != null && Books.installed().getBook(book.getName()) != null) {
            this.reference.selectBook(book);
            this.reference.setWord(data);
        }
    }

    @Override
    public void enterURI(URIEvent ev) {
    }

    @Override
    public void leaveURI(URIEvent ev) {
    }

    public void showStatusBar(boolean show) {
        if (show) {
            this.corePanel.add((Component)this.barStatus, "South");
        } else {
            this.corePanel.remove(this.barStatus);
        }
        this.validate();
    }

    public void setCloseEnabled(boolean enabled) {
        this.views.getContextAction("ClearView").setEnabled(enabled);
        this.views.getContextAction("CloseOtherViews").setEnabled(enabled);
    }

    public final void generateConfig() {
        this.fillChoiceFactory();
        this.config = new Config(BDMsg.gettext("Desktop Options", new Object[0]));
        try {
            Document xmlconfig = XMLUtil.getDocument((String)CONFIG_KEY);
            Locale defaultLocale = Locale.getDefault();
            ResourceBundle configResources = ResourceBundle.getBundle(CONFIG_KEY, defaultLocale, (ClassLoader)CWClassLoader.instance(Desktop.class));
            this.config.add(xmlconfig, configResources);
            try {
                this.config.setProperties(ResourceUtil.getProperties((String)DESKTOP_KEY));
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                ExceptionPane.showExceptionDialog(null, ex);
            }
            this.config.localToApplication();
            this.config.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    BibleViewPane view;
                    if ("BibleDisplay.ConfigurableFont".equals(evt.getPropertyName())) {
                        view = (BibleViewPane)Desktop.this.getViews().getSelected();
                        SplitBookDataDisplay da = view.getPassagePane();
                        da.getBookDataDisplay().refresh();
                        Desktop.this.reference.refresh();
                    }
                    if ("BibleDisplay.MaxPickers".equals(evt.getPropertyName())) {
                        view = (BibleViewPane)Desktop.this.getViews().getSelected();
                        DisplaySelectPane selector = view.getSelectPane();
                        selector.getBiblePicker().enableButtons();
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            ExceptionPane.showExceptionDialog(null, e);
        }
        catch (JDOMException e) {
            e.printStackTrace(System.err);
            ExceptionPane.showExceptionDialog(null, e);
        }
    }

    public void checkForBooks() {
        List bibles = Books.installed().getBooks(BookFilters.getBibles());
        if (bibles.isEmpty()) {
            String title = BDMsg.gettext("Install Bibles?", new Object[0]);
            StringBuilder msg = new StringBuilder(200);
            msg.append(BDMsg.gettext("You have no Bibles installed. Do you wish to install some now?", new Object[0]));
            msg.append("\n");
            msg.append("(This is also available from Books in the Tools menu)");
            int reply = CWOptionPane.showConfirmDialog(this, msg, title, 2, 3);
            if (reply == 0) {
                this.desktopActions.doBooks();
            }
        }
    }

    public static void setSidebarShowing(boolean show) {
        sidebarShowing = show;
    }

    public static boolean isSidebarShowing() {
        return sidebarShowing;
    }

    public static void setViewSourceShowing(boolean show) {
        viewSourceShowing = show;
    }

    public static boolean isViewSourceShowing() {
        return viewSourceShowing;
    }

    public void setCompareShowing(boolean show) {
        boolean old = this.compareShowing;
        this.compareShowing = show;
        this.changeSupport.firePropertyChange("ComparingBooks", old, this.compareShowing);
    }

    public boolean isCompareShowing() {
        return this.compareShowing;
    }

    public static void setBibleViewReused(boolean reuse) {
        reuseBibleView = reuse;
    }

    public static boolean isBibleViewReused() {
        return reuseBibleView;
    }

    public static void setCSSOverride(String override) {
        XSLTProperty.CSS.setState(override);
    }

    public static String getCSSOverride() {
        return XSLTProperty.CSS.getStringState();
    }

    final void fillChoiceFactory() {
        this.refreshBooks();
        Translations.instance().register();
        Map converters = ConverterFactory.getKnownConverters();
        Set keys = converters.keySet();
        String[] names = keys.toArray(new String[keys.size()]);
        ChoiceFactory.getDataMap().put(CONV_KEY, names);
        ConfigurableSwingConverter cstyle = new ConfigurableSwingConverter();
        String[] cstyles = cstyle.getStyles();
        ChoiceFactory.getDataMap().put(CSWING_KEY, cstyles);
    }

    protected final void refreshBooks() {
        boolean newRefBooks;
        Defaults.refreshBooks();
        boolean hasDictionaries = Defaults.getDictionary() != null;
        boolean hasCommentaries = Defaults.getCommentary() != null;
        boolean bl = newRefBooks = hasDictionaries || hasCommentaries;
        if (newRefBooks != this.hasRefBooks) {
            if (this.reference != null) {
                if (!newRefBooks) {
                    this.sptBooks.setDividerLocation(8000);
                } else {
                    int norm = (int)((double)this.sptBooks.getMaximumDividerLocation() * 0.8);
                    this.sptBooks.setDividerLocation(norm);
                }
            }
            this.hasRefBooks = newRefBooks;
        }
    }

    public Config getConfig() {
        return this.config;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.config = null;
        this.history = null;
        this.desktopActions = new DesktopActions(this);
        this.actions = new ActionFactory(this.desktopActions);
        this.buildActionMap();
        this.views = new ViewManager(this);
        this.views.addViewEventListener(this);
        is.defaultReadObject();
    }

    static {
        CWProject.setHome((String)"jsword.home", (String)".jsword", (String)"JSword");
        reuseBibleView = true;
        ICON_APP = GuiUtil.getIcon("images/BibleDesktop16.png");
        log = LoggerFactory.getLogger(Desktop.class);
    }

    private static class DesktopRunner
    implements Runnable {
        private Desktop desktop;
        private Splash splash;

        public DesktopRunner(Desktop aDesktop, Splash aSplash) {
            this.desktop = aDesktop;
            this.splash = aSplash;
        }

        @Override
        public void run() {
            this.splash.close();
            this.desktop.setVisible(true);
            this.desktop.establishPreferredSize();
            this.desktop.pack();
            this.desktop.checkForBooks();
        }
    }

    private static final class DesktopThread
    extends Thread {
        DesktopThread(ThreadGroup group) {
            super(group, "BibleDesktopUIThread");
        }

        @Override
        public void run() {
            Translations.instance().setLocale();
            if (OSType.MAC.equals((Object)OSType.getOSType())) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", BDMsg.getApplicationTitle());
                System.setProperty("com.apple.mrj.application.live-resize", "true");
            }
            ExceptionPane.setHelpDeskListener(true);
            LookAndFeelUtil.initialize();
            Splash splash = new Splash();
            Desktop desktop = new Desktop();
            LayoutPersistence layoutPersistence = LayoutPersistence.instance();
            if (layoutPersistence.isLayoutPersisted(desktop)) {
                layoutPersistence.restoreLayout(desktop);
            } else {
                GuiUtil.defaultDesktopSize(desktop);
                GuiUtil.centerOnScreen(desktop);
            }
            SwingUtilities.invokeLater(new DesktopRunner(desktop, splash));
        }
    }
}

