/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.desktop;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.ToolTipManager;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.bibledesktop.book.BibleViewPane;
import org.crosswire.bibledesktop.book.install.InternetWarning;
import org.crosswire.bibledesktop.book.install.SitesPane;
import org.crosswire.bibledesktop.desktop.AboutPane;
import org.crosswire.bibledesktop.desktop.Desktop;
import org.crosswire.bibledesktop.desktop.ViewSourcePane;
import org.crosswire.bibledesktop.desktop.XSLTProperty;
import org.crosswire.bibledesktop.display.BookDataDisplay;
import org.crosswire.bibledesktop.display.basic.SplitBookDataDisplay;
import org.crosswire.bibledesktop.display.basic.TabbedBookDataDisplay;
import org.crosswire.common.config.swing.ConfigEditorFactory;
import org.crosswire.common.swing.ActionFactory;
import org.crosswire.common.swing.CWOptionPane;
import org.crosswire.common.swing.desktop.LayoutPersistence;
import org.crosswire.common.swing.desktop.ViewVisitor;
import org.crosswire.common.util.CWProject;
import org.crosswire.common.util.ClassUtil;
import org.crosswire.common.util.LucidException;
import org.crosswire.common.util.OSType;
import org.crosswire.common.util.ReflectionUtil;
import org.crosswire.common.util.Reporter;
import org.crosswire.jsword.passage.Key;
import org.crosswire.jsword.passage.NoSuchKeyException;
import org.crosswire.jsword.util.WebWarning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopActions {
    protected Desktop desktop;
    private ActionFactory actions;
    private boolean osxRegistered;
    private AboutPane atp;
    private SitesPane sites;
    protected static final Logger log = LoggerFactory.getLogger(DesktopActions.class);

    public DesktopActions(Desktop desktop) {
        this.desktop = desktop;
        this.actions = new ActionFactory(this);
        this.osxRegistered = this.macOSXRegistration();
    }

    public Desktop getDesktop() {
        return this.desktop;
    }

    public ActionFactory getActions() {
        return this.actions;
    }

    public boolean macOSXRegistration() {
        if (OSType.MAC.equals((Object)OSType.getOSType())) {
            try {
                Class osxAdapter = ClassUtil.forName((String)"org.crosswire.common.aqua.OSXAdapter");
                Object[] registerOSXArgs = new Object[]{this.actions, "About", "Options", "Exit"};
                ReflectionUtil.invoke((Class)osxAdapter, (Object)osxAdapter, (String)"registerMacOSXApplication", (Object[])registerOSXArgs);
                Class[] enablePrefTypes = new Class[]{Boolean.TYPE};
                Object[] enablePrefArgs = new Object[]{Boolean.TRUE};
                ReflectionUtil.invoke((Class)osxAdapter, (Object)osxAdapter, (String)"enablePrefs", (Object[])enablePrefArgs, (Class[])enablePrefTypes);
                return true;
            }
            catch (NoClassDefFoundError e) {
                log.error("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled.", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled.", (Throwable)e);
            }
            catch (Exception e) {
                log.error("Exception while loading the OSXAdapter:", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isOSXRegistered() {
        return this.osxRegistered;
    }

    public SitesPane getSites() {
        if (this.sites == null) {
            this.sites = new SitesPane();
        }
        return this.sites;
    }

    public void doOpen() {
        try {
            BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
            view.open();
        }
        catch (NoSuchKeyException e) {
            Reporter.informUser((Object)this.getDesktop(), (LucidException)e);
        }
        catch (IOException e) {
            Reporter.informUser((Object)this.getDesktop(), (Throwable)e);
        }
    }

    public void doSave() {
        try {
            BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
            if (!view.maySave()) {
                Reporter.informUser((Object)this.getDesktop(), (String)BDMsg.gettext("No Passage to Save", new Object[0]));
                return;
            }
            view.save();
        }
        catch (IOException ex) {
            Reporter.informUser((Object)this.getDesktop(), (Throwable)ex);
        }
    }

    public void doSaveAs() {
        try {
            BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
            if (!view.maySave()) {
                Reporter.informUser((Object)this.getDesktop(), (String)BDMsg.gettext("No Passage to Save", new Object[0]));
                return;
            }
            view.saveAs();
        }
        catch (IOException ex) {
            Reporter.informUser((Object)this.getDesktop(), (Throwable)ex);
        }
    }

    public void doSaveAll() {
        BibleViewPane view;
        boolean ok = false;
        for (Component comp : this.getDesktop().getViews()) {
            view = (BibleViewPane)comp;
            if (!view.maySave()) continue;
            ok = true;
        }
        if (!ok) {
            Reporter.informUser((Object)this.getDesktop(), (String)BDMsg.gettext("No Passage to Save", new Object[0]));
            return;
        }
        for (Component comp : this.getDesktop().getViews()) {
            try {
                view = (BibleViewPane)comp;
                view.save();
            }
            catch (IOException ex) {
                Reporter.informUser((Object)this.getDesktop(), (Throwable)ex);
            }
        }
    }

    public void doExit() {
        LayoutPersistence.instance().saveLayout(this.desktop);
        System.exit(0);
    }

    public void doCopy() {
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        da.copy();
    }

    public void doBack() {
        this.getDesktop().selectHistory(-1);
    }

    public void doForward() {
        this.getDesktop().selectHistory(1);
    }

    public void doStrongs(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.STRONGS_NUMBERS.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doMorph(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.MORPH.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doVLine(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.START_VERSE_ON_NEWLINE.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doVNum() {
        XSLTProperty.VERSE_NUMBERS.setState(true);
        XSLTProperty.CV.setState(false);
        XSLTProperty.BCV.setState(false);
        XSLTProperty.NO_VERSE_NUMBERS.setState(false);
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doTinyVNum(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.TINY_VERSE_NUMBERS.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doBCVNum() {
        XSLTProperty.VERSE_NUMBERS.setState(false);
        XSLTProperty.CV.setState(false);
        XSLTProperty.BCV.setState(true);
        XSLTProperty.NO_VERSE_NUMBERS.setState(false);
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doCVNum() {
        XSLTProperty.VERSE_NUMBERS.setState(false);
        XSLTProperty.CV.setState(true);
        XSLTProperty.BCV.setState(false);
        XSLTProperty.NO_VERSE_NUMBERS.setState(false);
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doNoVNum() {
        XSLTProperty.VERSE_NUMBERS.setState(false);
        XSLTProperty.CV.setState(false);
        XSLTProperty.BCV.setState(false);
        XSLTProperty.NO_VERSE_NUMBERS.setState(true);
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doCompareToggle(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        this.getDesktop().setCompareShowing(toggle.getState());
    }

    public void doHeadings(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.HEADINGS.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doNotes(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.NOTES.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doXRef(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        XSLTProperty.XREF.setState(toggle.isSelected());
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        da.getBookDataDisplay().refresh();
    }

    public void doViewSource() {
        Key key;
        BibleViewPane view = (BibleViewPane)this.getDesktop().getViews().getSelected();
        SplitBookDataDisplay da = view.getPassagePane();
        BookDataDisplay bdd = da.getBookDataDisplay();
        if (bdd instanceof TabbedBookDataDisplay) {
            bdd = ((TabbedBookDataDisplay)bdd).getInnerDisplayPane();
        }
        if ((key = bdd.getKey()) == null) {
            Reporter.informUser((Object)this.getDesktop(), (String)BDMsg.gettext("No current passage to view", new Object[0]));
            return;
        }
        ViewSourcePane viewer = new ViewSourcePane(da.getBooks(), key);
        viewer.showInFrame(this.getDesktop());
    }

    public void doBooks() {
        int webAccess = 0;
        if (WebWarning.instance().isShown()) {
            webAccess = InternetWarning.showDialog(this.desktop, "?");
        }
        if (webAccess == 0) {
            this.getSites().showInDialog(this.getDesktop());
        }
    }

    public void doOptions() {
        URI configUri = CWProject.instance().getWritableURI("desktop", ".properties");
        ConfigEditorFactory.showDialog(this.desktop.getConfig(), (Component)this.desktop, configUri);
    }

    public void doContents() {
        StringBuilder buf = new StringBuilder(200);
        buf.append(BDMsg.gettext("Currently on-line help is only available via the Bible Desktop's website:", new Object[0]));
        buf.append("\nhttp://www.crosswire.org/bibledesktop");
        CWOptionPane.showMessageDialog(this.getDesktop(), buf.toString());
    }

    public void doAbout() {
        if (this.atp == null) {
            this.atp = new AboutPane();
        }
        this.atp.showInDialog(this.getDesktop());
    }

    public void doToolTipToggle(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        ToolTipManager.sharedInstance().setEnabled(toggle.isSelected());
    }

    public void doStatusToggle(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        this.desktop.showStatusBar(toggle.isSelected());
    }

    public void doSidebarToggle(ActionEvent ev) {
        JCheckBoxMenuItem toggle = (JCheckBoxMenuItem)ev.getSource();
        boolean show = toggle.isSelected();
        this.desktop.getViews().visit(new ShowSideBarVisitor(show));
    }

    private static final class ShowSideBarVisitor
    implements ViewVisitor {
        private boolean show;

        public ShowSideBarVisitor(boolean show) {
            this.show = show;
        }

        @Override
        public void visitView(Component component) {
            if (component instanceof BibleViewPane) {
                BibleViewPane view = (BibleViewPane)component;
                SplitBookDataDisplay sbDisplay = view.getPassagePane();
                sbDisplay.showSidebar(this.show);
            }
        }
    }
}

