/*
 * Decompiled with CFR 0.152.
 */
package org.crosswire.bibledesktop.passage;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.crosswire.bibledesktop.BDMsg;
import org.crosswire.common.icu.NumberShaper;
import org.crosswire.jsword.passage.Verse;
import org.crosswire.jsword.passage.VerseRange;
import org.crosswire.jsword.versification.BibleBook;
import org.crosswire.jsword.versification.Versification;
import org.crosswire.jsword.versification.system.Versifications;

public final class WholeBibleTreeNode
implements TreeNode {
    private Versification v11n = Versifications.instance().getDefaultVersification();
    private NumberShaper shaper;
    private VerseRange range;
    private TreeNode parent;
    private Level level;

    public static WholeBibleTreeNode getRootNode() {
        return new WholeBibleTreeNode(null, Versifications.instance().getDefaultVersification().getAllVerses(), Level.BIBLE);
    }

    protected static WholeBibleTreeNode getNode(TreeNode parent, BibleBook b, int c, int v) {
        Versification v11n = Versifications.instance().getDefaultVersification();
        Verse start = null;
        Verse end = null;
        Level thislevel = Level.BOOK;
        if (b == null) {
            assert (false) : "BibleBook is null";
        } else if (c == -1) {
            thislevel = Level.BOOK;
            int ec = v11n.getLastChapter(b);
            int ev = v11n.getLastVerse(b, ec);
            start = new Verse(v11n, b, 0, 0);
            end = new Verse(v11n, b, ec, ev);
        } else if (v == -1) {
            thislevel = Level.CHAPTER;
            int ev = v11n.getLastVerse(b, c);
            start = new Verse(v11n, b, c, 0);
            end = new Verse(v11n, b, c, ev);
        } else {
            thislevel = Level.VERSE;
            end = start = new Verse(v11n, b, c, v);
        }
        VerseRange rng = new VerseRange(v11n, start, end);
        return new WholeBibleTreeNode(parent, rng, thislevel);
    }

    private WholeBibleTreeNode(TreeNode parent, VerseRange range, Level level) {
        this.parent = parent != null ? parent : this;
        this.range = range;
        this.level = level;
        this.shaper = new NumberShaper();
    }

    public VerseRange getVerseRange() {
        return this.range;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.level != Level.VERSE;
    }

    @Override
    public boolean isLeaf() {
        return this.level == Level.VERSE;
    }

    public String toString() {
        switch (this.level) {
            case BIBLE: {
                return BDMsg.gettext("The Bible", new Object[0]);
            }
            case BOOK: {
                Verse start = this.range.getStart();
                return start.getVersification().getPreferredName(start.getBook());
            }
            case CHAPTER: {
                return this.shaper.shape(Integer.toString(this.range.getStart().getChapter()));
            }
            case VERSE: {
                return this.shaper.shape(Integer.toString(this.range.getStart().getVerse()));
            }
        }
        return BDMsg.gettext("Error", new Object[0]);
    }

    @Override
    public TreeNode getChildAt(int i) {
        switch (this.level) {
            case BIBLE: {
                return WholeBibleTreeNode.getNode(this, this.v11n.getBook(i), -1, -1);
            }
            case BOOK: {
                return WholeBibleTreeNode.getNode(this, this.range.getStart().getBook(), i, -1);
            }
            case CHAPTER: {
                return WholeBibleTreeNode.getNode(this, this.range.getStart().getBook(), this.range.getStart().getChapter(), i);
            }
        }
        return null;
    }

    @Override
    public int getChildCount() {
        switch (this.level) {
            case BIBLE: {
                return this.v11n.getBookCount();
            }
            case BOOK: {
                return this.v11n.getLastChapter(this.range.getStart().getBook()) + 1;
            }
            case CHAPTER: {
                return this.v11n.getLastVerse(this.range.getStart().getBook(), this.range.getStart().getChapter()) + 1;
            }
        }
        return 0;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (!(node instanceof WholeBibleTreeNode)) {
            return 0;
        }
        WholeBibleTreeNode vnode = (WholeBibleTreeNode)node;
        switch (this.level) {
            case BIBLE: {
                return vnode.getVerseRange().getStart().getBook().ordinal();
            }
            case BOOK: {
                return vnode.getVerseRange().getStart().getChapter();
            }
            case CHAPTER: {
                return vnode.getVerseRange().getStart().getVerse();
            }
        }
        return 0;
    }

    public Enumeration<TreeNode> children() {
        return new WholeBibleEnumeration(this);
    }

    private static enum Level {
        BIBLE,
        BOOK,
        CHAPTER,
        VERSE;

    }

    private class WholeBibleEnumeration
    implements Enumeration<TreeNode> {
        private WholeBibleTreeNode treeNode;
        private int count;

        public WholeBibleEnumeration(WholeBibleTreeNode treeNode) {
            this.treeNode = treeNode;
        }

        @Override
        public boolean hasMoreElements() {
            return this.count < this.treeNode.getChildCount();
        }

        @Override
        public TreeNode nextElement() {
            ++this.count;
            return this.treeNode.getChildAt(this.count);
        }
    }
}

